/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.arena;

import com.elmakers.mine.bukkit.api.entity.EntityData;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.arena.Arena;
import com.elmakers.mine.bukkit.arena.ArenaMobSpawner;
import com.elmakers.mine.bukkit.arena.ArenaPlayer;
import com.elmakers.mine.bukkit.arena.ArenaStageTemplate;
import com.elmakers.mine.bukkit.arena.DefaultStage;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.random.RandomUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class ArenaStage
extends ArenaStageTemplate {
    private static Random random = new Random();
    private int index;
    private String name;
    private Map<Entity, ArenaPlayer> spawned = new WeakHashMap<Entity, ArenaPlayer>();
    private long started;
    private long lastTick;

    public ArenaStage(Arena arena, int index) {
        super(arena);
        this.index = index;
    }

    public ArenaStage(Arena arena, int index, ConfigurationSection configuration) {
        super(arena, configuration);
        this.index = index;
    }

    @Override
    protected void load() {
        ConfigurationSection effectiveConfiguration = ConfigurationUtils.cloneConfiguration(this.configuration);
        DefaultStage defaultStage = this.arena.getDefaultStage();
        ConfigurationUtils.addConfigurations(effectiveConfiguration, defaultStage.configuration, false);
        this.load(effectiveConfiguration);
    }

    @Override
    protected void load(ConfigurationSection configuration) {
        super.load(configuration);
        this.name = configuration.getString("name");
    }

    @Override
    public void describe(CommandSender sender) {
        sender.sendMessage(ChatColor.AQUA + this.getName() + ChatColor.GRAY + " (" + ChatColor.DARK_AQUA + this.getNumber() + ChatColor.GRAY + ")");
        super.describe(sender);
    }

    public void start() {
        this.lastTick = this.started = System.currentTimeMillis();
        if (!this.mobs.isEmpty()) {
            this.arena.messageInGamePlayers("t:" + this.getName());
            MageController magic = this.arena.getController().getMagic();
            magic.setForceSpawn(true);
            ArrayList<ArenaPlayer> players = new ArrayList<ArenaPlayer>(this.arena.getLivingParticipants());
            if (players.isEmpty()) {
                this.arena.getController().getMagic().getLogger().warning("Arena stage " + this.getNumber() + " of " + this.arena.getKey() + " starting without any living players");
                return;
            }
            try {
                List<Location> spawns = this.getMobSpawns();
                int num = 0;
                for (ArenaMobSpawner mobSpawner : this.mobs) {
                    EntityData mobType = mobSpawner.getEntity();
                    if (mobType == null) continue;
                    for (int i = 0; i < mobSpawner.getCount(); ++i) {
                        Location spawn = spawns.get(num);
                        if (this.randomizeMobSpawn != null) {
                            spawn = spawn.clone();
                            spawn.add((2.0 * random.nextDouble() - 1.0) * this.randomizeMobSpawn.getX(), (2.0 * random.nextDouble() - 1.0) * this.randomizeMobSpawn.getY(), (2.0 * random.nextDouble() - 1.0) * this.randomizeMobSpawn.getZ());
                        }
                        num = (num + 1) % spawns.size();
                        Entity spawnedEntity = mobType.spawn(spawn);
                        if (spawnedEntity == null) continue;
                        this.arena.getController().register(spawnedEntity, this.arena);
                        if (!this.defaultDrops) {
                            magic.disableDrops(spawnedEntity);
                        }
                        ArenaPlayer targetPlayer = null;
                        if (this.forceTarget && spawnedEntity instanceof Creature) {
                            targetPlayer = RandomUtils.getRandom(players);
                            Player player = targetPlayer.getPlayer();
                            ((Creature)spawnedEntity).setTarget((LivingEntity)player);
                            CompatibilityLib.getMobUtils().setPathfinderTarget(spawnedEntity, (Entity)player, 0.0);
                        }
                        this.spawned.put(spawnedEntity, targetPlayer);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            magic.setForceSpawn(false);
        }
        if (this.startSpell != null && !this.startSpell.isEmpty()) {
            Mage arenaMage = this.arena.getMage();
            arenaMage.setLocation(this.arena.getCenter());
            MageSpell spell = arenaMage.getSpell(this.startSpell);
            if (spell != null) {
                spell.cast();
            }
        }
    }

    public void checkAggro(Entity mob) {
        Set<ArenaPlayer> currentPlayers = this.arena.getLivingParticipants();
        if (!currentPlayers.isEmpty()) {
            ArenaPlayer target = this.spawned.get(mob);
            if (target != null && !currentPlayers.contains(target)) {
                target = null;
            }
            if (target == null) {
                target = RandomUtils.getRandom(new ArrayList<ArenaPlayer>(currentPlayers));
                this.spawned.put(mob, target);
            }
            if (mob instanceof Creature) {
                ((Creature)mob).setTarget((LivingEntity)target.getPlayer());
            }
            CompatibilityLib.getMobUtils().setPathfinderTarget(mob, (Entity)target.getPlayer(), 1.0);
        }
    }

    public void mobDied(Entity entity) {
        this.arena.getController().unregister(entity);
        this.spawned.remove(entity);
    }

    public void completed() {
        this.arena.messageInGamePlayers(ChatColor.GREEN + "Congratulations!" + ChatColor.AQUA + "  You have passed " + ChatColor.DARK_AQUA + this.getName());
        Collection<ArenaPlayer> players = this.arena.getParticipants();
        for (ArenaPlayer player : players) {
            Mage mage = player.getMage();
            if (this.winXP > 0) {
                mage.sendMessage(ChatColor.AQUA + "You have been awarded " + ChatColor.DARK_AQUA + Integer.toString(this.winXP) + ChatColor.AQUA + " experience!");
                mage.giveExperience(this.winXP);
            }
            if (this.winSP > 0) {
                mage.sendMessage(ChatColor.AQUA + "You have been awarded " + ChatColor.DARK_AQUA + Integer.toString(this.winSP) + ChatColor.AQUA + " spell points!");
                mage.addSkillPoints(this.winSP);
            }
            if (this.winMoney <= 0) continue;
            mage.sendMessage(ChatColor.AQUA + "You have been awarded $" + ChatColor.DARK_AQUA + Integer.toString(this.winMoney) + ChatColor.AQUA + "!");
            mage.addVaultCurrency(this.winMoney);
        }
        this.finish();
    }

    public void finish() {
        if (this.endSpell != null && !this.endSpell.isEmpty()) {
            Mage arenaMage = this.arena.getMage();
            arenaMage.setLocation(this.arena.getCenter());
            MageSpell spell = arenaMage.getSpell(this.endSpell);
            if (spell != null) {
                spell.cast();
            }
        }
        this.reset();
    }

    public boolean isFinished() {
        this.checkSpawns();
        return this.spawned.isEmpty();
    }

    public void checkSpawnsAndArena() {
        this.checkSpawns(true, true);
    }

    public void checkSpawns() {
        this.checkSpawns(false, false);
    }

    public void checkSpawns(boolean checkAggro, boolean checkArena) {
        Iterator<Map.Entry<Entity, ArenaPlayer>> it = this.spawned.entrySet().iterator();
        boolean mobsDied = false;
        while (it.hasNext()) {
            Entity entity = it.next().getKey();
            if (entity.isDead() || !entity.isValid()) {
                mobsDied = true;
                this.arena.getController().unregister(entity);
                it.remove();
                continue;
            }
            if (!checkAggro || !this.forceTarget) continue;
            this.checkAggro(entity);
        }
        if (checkArena && (mobsDied || this.spawned.isEmpty()) && this.arena.isStarted()) {
            this.arena.check();
        }
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)this.name);
        }
        return "Stage " + this.getNumber();
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.configuration.set("name", (Object)name);
        this.arena.saveEditingStage();
    }

    public int getNumber() {
        return this.index + 1;
    }

    public void reset() {
        for (Entity entity : this.spawned.keySet()) {
            if (!entity.isValid()) continue;
            this.arena.getController().unregister(entity);
            entity.remove();
        }
        this.spawned.clear();
    }

    public int getActiveMobs() {
        this.checkSpawns();
        return this.spawned.size();
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isRespawning() {
        return this.arena.hasDeadPlayers() && this.respawnDuration > 0;
    }

    public void tick() {
        this.checkSpawnsAndArena();
        if (this.duration <= 0 && this.respawnDuration <= 0) {
            return;
        }
        long now = System.currentTimeMillis();
        long previousTick = this.lastTick;
        this.lastTick = now;
        long previousTime = previousTick - this.started;
        long currentTime = now - this.started;
        if (this.duration > 0) {
            long previousSecondsRemaining = ((long)this.duration - previousTime) / 1000L;
            long secondsRemaining = ((long)this.duration - currentTime) / 1000L;
            if (secondsRemaining > 0L && secondsRemaining < previousSecondsRemaining) {
                if (secondsRemaining == 10L || secondsRemaining == 30L) {
                    this.arena.messageInGamePlayers("t:" + ChatColor.RED + secondsRemaining + " Seconds!");
                } else if (secondsRemaining <= 5L) {
                    this.arena.messageInGamePlayers("t:" + ChatColor.RED + secondsRemaining);
                }
            }
            if (currentTime > (long)this.duration) {
                this.arena.draw();
                return;
            }
        }
        if (this.respawnDuration > 0 && this.arena.hasDeadPlayers()) {
            long secondsRemaining;
            long lastDeathTime = this.arena.getLastDeathTime();
            long deathTime = now - lastDeathTime;
            long respawnSecondsRemaining = ((long)this.respawnDuration - deathTime) / 1000L;
            if (this.duration > 0 && (secondsRemaining = ((long)this.duration - currentTime) / 1000L) <= respawnSecondsRemaining) {
                return;
            }
            long previousDeathTime = previousTick - lastDeathTime;
            long previousRespawnSecondsRemaining = ((long)this.respawnDuration - previousDeathTime) / 1000L;
            if (respawnSecondsRemaining > 0L && respawnSecondsRemaining < previousRespawnSecondsRemaining) {
                if (respawnSecondsRemaining == 10L) {
                    this.arena.messageDeadPlayers("t:" + ChatColor.GREEN + "Respawning\n" + ChatColor.GRAY + "in 10 Seconds!");
                } else if (respawnSecondsRemaining <= 5L) {
                    this.arena.messageDeadPlayers("t:" + ChatColor.GREEN + respawnSecondsRemaining);
                }
            }
            if (deathTime > (long)this.respawnDuration) {
                this.arena.respawn();
                return;
            }
            this.arena.showRespawnBossBar((double)deathTime / (double)this.respawnDuration);
        }
    }
}

