/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class OrientAction
extends BaseSpellAction {
    private Float pitch;
    private Float yaw;
    private Float pitchOffset;
    private Float yawOffset;
    private boolean orientTarget;
    private boolean targetBlock;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.pitch = parameters.contains("pitch") ? Float.valueOf((float)parameters.getDouble("pitch")) : null;
        this.yaw = parameters.contains("yaw") ? Float.valueOf((float)parameters.getDouble("yaw")) : null;
        this.pitchOffset = parameters.contains("pitch_offset") ? Float.valueOf((float)parameters.getDouble("pitch_offset")) : null;
        this.yawOffset = parameters.contains("yaw_offset") ? Float.valueOf((float)parameters.getDouble("yaw_offset")) : null;
        this.orientTarget = parameters.getBoolean("orient_target", false);
        this.targetBlock = parameters.getBoolean("target_block", false);
    }

    @Override
    public SpellResult perform(CastContext context) {
        Entity entity;
        Mage mage = context.getMage();
        Entity entity2 = entity = this.orientTarget ? context.getTargetEntity() : mage.getEntity();
        if (entity == null) {
            return this.orientTarget ? SpellResult.NO_TARGET : SpellResult.ENTITY_REQUIRED;
        }
        Location location = entity.getLocation();
        context.registerMoved(entity);
        if (this.pitch != null || this.yaw != null) {
            if (this.pitch != null) {
                location.setPitch(this.pitch.floatValue());
            }
            if (this.yaw != null) {
                location.setYaw(this.yaw.floatValue());
            }
        }
        if (this.pitchOffset != null || this.yawOffset != null) {
            if (this.pitchOffset != null) {
                location.setPitch(location.getPitch() + this.pitchOffset.floatValue());
            }
            if (this.yawOffset != null) {
                location.setYaw(location.getYaw() + this.yawOffset.floatValue());
            }
        }
        if (this.pitchOffset == null && this.yawOffset == null && this.yaw == null && this.pitch == null) {
            Entity targetEntity;
            Entity entity3 = targetEntity = this.orientTarget ? mage.getEntity() : context.getTargetEntity();
            if (targetEntity == null && this.orientTarget) {
                return SpellResult.ENTITY_REQUIRED;
            }
            Location targetLocation = null;
            if (this.targetBlock) {
                targetLocation = context.getTargetLocation();
            } else {
                Location location2 = targetLocation = targetEntity == null ? null : targetEntity.getLocation();
            }
            if (targetLocation == null) {
                return SpellResult.NO_TARGET;
            }
            Vector direction = targetLocation.toVector().subtract(location.toVector());
            location.setDirection(direction);
        }
        entity.teleport(location);
        return SpellResult.CAST;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("pitch");
        parameters.add("yaw");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("pitch") || parameterKey.equals("yaw")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

