/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.v1_12.entity;

import com.elmakers.mine.bukkit.entity.EntityExtraData;
import org.bukkit.DyeColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Shulker;

public class EntityShulkerData
extends EntityExtraData {
    private DyeColor color;

    public EntityShulkerData(ConfigurationSection parameters) {
        String colorString = parameters.getString("color");
        if (colorString != null) {
            try {
                this.color = DyeColor.valueOf((String)colorString.toUpperCase());
            }
            catch (Exception ex) {
                this.color = null;
            }
        }
    }

    public EntityShulkerData(Entity entity) {
        if (entity instanceof Shulker) {
            Shulker shulker = (Shulker)entity;
            this.color = shulker.getColor();
        }
    }

    @Override
    public void apply(Entity entity) {
        if (entity instanceof Shulker) {
            Shulker shulker = (Shulker)entity;
            if (this.color != null) {
                shulker.setColor(this.color);
            }
        }
    }

    @Override
    public boolean cycle(Entity entity) {
        if (!this.canCycle(entity)) {
            return false;
        }
        Shulker shulker = (Shulker)entity;
        DyeColor dyeColor = shulker.getColor();
        DyeColor[] dyeColorValues = DyeColor.values();
        dyeColor = dyeColorValues[(dyeColor.ordinal() + 1) % dyeColorValues.length];
        shulker.setColor(dyeColor);
        return true;
    }

    @Override
    public boolean canCycle(Entity entity) {
        return entity instanceof Shulker;
    }
}

