/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.api.event.MagicErrorEvent;
import com.elmakers.mine.bukkit.api.event.MagicWarningEvent;
import com.elmakers.mine.bukkit.tasks.CallEventTask;
import com.elmakers.mine.bukkit.utility.ColoredLogger;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.LogMessage;
import com.elmakers.mine.bukkit.utility.Messages;
import com.elmakers.mine.bukkit.utility.platform.CompatibilityUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class MagicLogger
extends ColoredLogger {
    private static int MAX_ERRORS = 50;
    private Plugin plugin;
    private boolean notify = false;
    private String context = null;
    private boolean capture = false;
    private final Set<LogMessage> warnings = Collections.newSetFromMap(new LinkedHashMap<LogMessage, Boolean>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<LogMessage, Boolean> eldest) {
            return this.size() > MAX_ERRORS;
        }
    });
    private final Set<LogMessage> errors = Collections.newSetFromMap(new LinkedHashMap<LogMessage, Boolean>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<LogMessage, Boolean> eldest) {
            return this.size() > MAX_ERRORS;
        }
    });
    private int pendingWarningCount = 0;
    private int pendingErrorCount = 0;
    private long lastMessageSent;

    public MagicLogger(Plugin plugin, Logger delegate) {
        super(delegate);
        this.plugin = plugin;
        this.lastMessageSent = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(LogRecord record) {
        if (!this.capture || !record.getLevel().equals(Level.WARNING) && !record.getLevel().equals(Level.SEVERE) || record.getThrown() != null) {
            super.log(record);
        }
        Server server = Bukkit.getServer();
        CompatibilityUtils compatibility = CompatibilityLib.isInitialized() ? CompatibilityLib.getCompatibilityUtils() : null;
        String message = record.getMessage();
        if (message != null) {
            message = message.replace("[Magic] ", "");
        }
        LogMessage logMessage = new LogMessage(this.context, message);
        if (record.getLevel().equals(Level.WARNING)) {
            Set<LogMessage> set = this.warnings;
            synchronized (set) {
                ++this.pendingWarningCount;
                this.warnings.add(logMessage);
                if (server != null) {
                    MagicWarningEvent event = new MagicWarningEvent(record, this.context, this.pendingWarningCount, this.capture);
                    if (compatibility != null && compatibility.isPrimaryThread()) {
                        server.getPluginManager().callEvent((Event)event);
                    } else if (this.plugin != null && this.plugin.isEnabled()) {
                        server.getScheduler().runTask(this.plugin, (Runnable)new CallEventTask(event));
                    }
                }
            }
        }
        if (record.getLevel().equals(Level.SEVERE)) {
            Set<LogMessage> set = this.errors;
            synchronized (set) {
                ++this.pendingErrorCount;
                this.errors.add(logMessage);
                if (server != null) {
                    MagicErrorEvent event = new MagicErrorEvent(record, this.context, this.pendingErrorCount, this.capture);
                    if (compatibility != null && compatibility.isPrimaryThread()) {
                        server.getPluginManager().callEvent((Event)event);
                    } else if (this.plugin != null && this.plugin.isEnabled()) {
                        server.getScheduler().runTask(this.plugin, (Runnable)new CallEventTask(event));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableCapture(boolean enable) {
        this.capture = enable;
        this.context = null;
        Set<LogMessage> set = this.errors;
        synchronized (set) {
            this.pendingErrorCount = 0;
            this.errors.clear();
        }
        set = this.warnings;
        synchronized (set) {
            this.pendingWarningCount = 0;
            this.warnings.clear();
        }
    }

    public void setContext(String context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogMessage> getErrors() {
        ArrayList<LogMessage> copy;
        Set<LogMessage> set = this.errors;
        synchronized (set) {
            copy = new ArrayList<LogMessage>(this.errors);
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogMessage> getWarnings() {
        ArrayList<LogMessage> copy;
        Set<LogMessage> set = this.warnings;
        synchronized (set) {
            copy = new ArrayList<LogMessage>(this.warnings);
        }
        return copy;
    }

    public boolean isCapturing() {
        return this.capture;
    }

    public void notify(Messages messages, CommandSender sender) {
        if (this.pendingErrorCount == 0 && this.pendingWarningCount == 0) {
            return;
        }
        long timeSince = System.currentTimeMillis() - this.lastMessageSent;
        String sinceMessage = messages.getTimeDescription(timeSince, "description", "cooldown");
        String messageKey = "logs.notify_errors";
        if (this.pendingErrorCount == 0) {
            messageKey = "logs.notify_warnings";
        } else if (this.pendingWarningCount != 0) {
            messageKey = "logs.notify_errors_and_warnings";
        }
        String message = messages.get(messageKey);
        message = message.replace("$time", sinceMessage).replace("$warnings", Integer.toString(this.pendingWarningCount)).replace("$errors", Integer.toString(this.pendingErrorCount));
        if (!message.isEmpty()) {
            sender.sendMessage(message);
        }
    }

    public void checkNotify(Messages messages) {
        if (this.pendingErrorCount == 0 && this.pendingWarningCount == 0) {
            return;
        }
        if (!this.notify) {
            return;
        }
        boolean sent = false;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission("magic.notify")) continue;
            this.notify(messages, (CommandSender)player);
            String message = messages.get("logs.notify_instructions");
            if (!message.isEmpty()) {
                player.sendMessage(message);
            }
            sent = true;
        }
        if (sent) {
            this.clearNotify();
        }
    }

    public void clearNotify() {
        this.pendingErrorCount = 0;
        this.pendingWarningCount = 0;
        this.lastMessageSent = System.currentTimeMillis();
    }

    public void setNotify(boolean notify) {
        this.notify = notify;
    }
}

