/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.essentials;

import com.earth2me.essentials.api.IItemDb;
import com.earth2me.essentials.items.AbstractItemDb;
import com.elmakers.mine.bukkit.api.spell.SpellCategory;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.ess3.api.IEssentials;
import net.ess3.api.IItemDb;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MagicItemDb
implements IItemDb.ItemResolver {
    private final MagicController controller;
    private final List<String> names = new ArrayList<String>();

    public static boolean register(MagicController controller, Plugin essentialsPlugin) throws Exception {
        IEssentials essentials = (IEssentials)essentialsPlugin;
        IItemDb itemDb = essentials.getItemDb();
        if (!(itemDb instanceof AbstractItemDb)) {
            return false;
        }
        ((AbstractItemDb)itemDb).registerResolver(controller.getPlugin(), "Magic", (IItemDb.ItemResolver)new MagicItemDb(controller));
        return true;
    }

    private MagicItemDb(MagicController controller) {
        this.controller = controller;
        Collection<SpellTemplate> spellList = controller.getSpellTemplates(false);
        for (SpellTemplate spellTemplate : spellList) {
            this.names.add("spell:" + spellTemplate.getKey());
        }
        Collection<String> allWands = controller.getWandTemplateKeys();
        for (String string : allWands) {
            this.names.add("wand:" + string);
        }
        Set<String> set = controller.getItemKeys();
        for (String itemKey : set) {
            this.names.add("magic:" + itemKey);
        }
        Set<String> set2 = controller.getCurrencyKeys();
        for (String currency : set2) {
            this.names.add("magic:" + currency);
        }
    }

    public Collection<String> getNames() {
        return this.names;
    }

    @Nullable
    public ItemStack apply(String id) {
        if (id.startsWith("m:")) {
            String itemId = id.replace("m:", "");
            return this.controller.createItem(itemId);
        }
        if (id.startsWith("magic:")) {
            String itemId = id.replace("magic:", "");
            return this.controller.createItem(itemId);
        }
        if (id.equals("wand")) {
            Wand wand = Wand.createWand(this.controller, "");
            if (wand != null) {
                return wand.getItem();
            }
        } else if (id.startsWith("wand:")) {
            String wandId = id.replace("wand:", "");
            Wand wand = Wand.createWand(this.controller, wandId.trim());
            if (wand != null) {
                return wand.getItem();
            }
        } else if (id.startsWith("w:")) {
            String wandId = id.replace("w:", "");
            Wand wand = Wand.createWand(this.controller, wandId.trim());
            if (wand != null) {
                return wand.getItem();
            }
        } else if (id.startsWith("book:")) {
            ItemStack bookItem;
            String bookCategory = id.replace("book:", "");
            SpellCategory category = null;
            if (bookCategory.length() > 0 && !bookCategory.equalsIgnoreCase("all")) {
                category = this.controller.getCategory(bookCategory);
            }
            if ((bookItem = this.controller.getSpellBook(category, 1)) != null) {
                return bookItem;
            }
        } else if (id.startsWith("spell:")) {
            String spellKey = id.replace("spell:", "");
            ItemStack itemStack = Wand.createSpellItem(spellKey, this.controller, null, true);
            if (itemStack != null) {
                return itemStack;
            }
        } else if (id.startsWith("s:")) {
            String spellKey = id.replace("s:", "");
            ItemStack itemStack = Wand.createSpellItem(spellKey, this.controller, null, true);
            if (itemStack != null) {
                return itemStack;
            }
        } else if (id.startsWith("brush:")) {
            String brushKey = id.replace("brush:", "");
            ItemStack itemStack = Wand.createBrushItem(brushKey, this.controller, null, true);
            if (itemStack != null) {
                return itemStack;
            }
        } else if (id.startsWith("upgrade:")) {
            String wandId = id.replace("upgrade:", "");
            Wand wand = Wand.createWand(this.controller, wandId.trim());
            if (wand != null) {
                wand.makeUpgrade();
                return wand.getItem();
            }
        } else if (id.startsWith("item:")) {
            String wandId = id.replace("item:", "");
            return this.controller.createItem(wandId);
        }
        return null;
    }
}

