/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.spigot;

import com.elmakers.mine.bukkit.utility.ChatUtils;
import com.elmakers.mine.bukkit.utility.platform.Platform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SpigotUtils
implements com.elmakers.mine.bukkit.utility.platform.SpigotUtils {
    private final Platform platform;
    private static final Pattern url = Pattern.compile("^(?:(https?)://)?([-\\w_\\.]{2,}\\.[a-z]{2,4})(/\\S*)?$");

    public SpigotUtils(Platform platform) {
        this.platform = platform;
    }

    @Override
    public void sendMessage(CommandSender sender, String message) {
        if (sender instanceof Player) {
            sender.spigot().sendMessage(this.parseChatComponents(message));
        } else {
            sender.sendMessage(ChatUtils.getSimpleMessage(message));
        }
    }

    @Override
    public boolean sendActionBar(Player player, String message) {
        if (ChatUtils.hasJSON(message)) {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, this.parseChatComponents(message));
        } else {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message));
        }
        return true;
    }

    @Override
    public boolean sendActionBar(Player player, String message, String font) {
        BaseComponent[] components = ChatUtils.hasJSON(message) ? this.parseChatComponents(message) : new BaseComponent[]{new TextComponent(message)};
        BaseComponent[] fontComponent = new ComponentBuilder("").font(font).append(components).create();
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, fontComponent);
        return true;
    }

    @Override
    @Nullable
    public String serializeBossBar(String title, String font) {
        if (ChatUtils.isDefaultFont(font)) {
            return null;
        }
        BaseComponent[] components = ChatUtils.hasJSON(title) ? this.parseChatComponents(title) : new BaseComponent[]{new TextComponent(title)};
        BaseComponent[] fontComponent = new ComponentBuilder("").font(font).append(components).create();
        return this.serializeBossBar(fontComponent);
    }

    @Override
    @Nullable
    public String serializeBossBar(String title) {
        if (ChatUtils.hasJSON(title)) {
            BaseComponent[] components = this.parseChatComponents(title);
            return this.serializeBossBar(components);
        }
        return null;
    }

    @Nullable
    private String serializeBossBar(BaseComponent[] components) {
        if (components.length == 0) {
            return null;
        }
        BaseComponent component = components.length == 1 ? components[0] : this.collapseComponents(Arrays.asList(components));
        return ComponentSerializer.toString((BaseComponent)component);
    }

    @Override
    public String getHexColor(String hexCode) {
        return ChatColor.of((String)hexCode).toString();
    }

    @Override
    public String translateColors(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    @Override
    public String stripColor(String message) {
        return ChatColor.stripColor((String)message);
    }

    @Override
    public List<String> serializeLore(List<String> lore) {
        ArrayList<String> serializedLore = new ArrayList<String>(lore.size());
        for (int i = 0; i < lore.size(); ++i) {
            Object components;
            String line = lore.get(i);
            if (ChatUtils.hasJSON(line)) {
                String[] pieces;
                Object addToComponents = components = new ArrayList();
                BaseComponent addToComponent = null;
                for (String component : pieces = ChatUtils.getComponents(line)) {
                    try {
                        List<BaseComponent> addComponents = component.startsWith("{") ? Arrays.asList(ComponentSerializer.parse((String)component)) : Arrays.asList(SpigotUtils.fromLegacyText(component));
                        if (addComponents.isEmpty()) continue;
                        addToComponents.addAll(addComponents);
                        if (addToComponent != null) {
                            addToComponent.setExtra((List)addToComponents);
                        }
                        if ((addToComponents = (addToComponent = (BaseComponent)addToComponents.get(addToComponents.size() - 1)).getExtra()) != null) continue;
                        addToComponents = new ArrayList();
                    }
                    catch (Exception ex) {
                        this.platform.getLogger().log(Level.SEVERE, "Error parsing chat components from: " + component, ex);
                    }
                }
                serializedLore.add(ComponentSerializer.toString((BaseComponent)this.collapseComponents((List<BaseComponent>)components)));
                continue;
            }
            components = SpigotUtils.fromLegacyText(line);
            components = this.resetItalics((BaseComponent[])components);
            serializedLore.add(ComponentSerializer.toString((BaseComponent[])components));
        }
        return serializedLore;
    }

    protected BaseComponent collapseComponents(List<BaseComponent> list) {
        boolean needsReset;
        if (list.isEmpty()) {
            return new ComponentBuilder("").create()[0];
        }
        BaseComponent single = list.get(0);
        boolean bl = needsReset = single.hasFormatting() && !single.isItalic();
        if (list.size() == 1 && !needsReset) {
            return single;
        }
        BaseComponent wrapper = new ComponentBuilder("").create()[0];
        if (needsReset) {
            wrapper.setItalic(Boolean.valueOf(false));
        }
        wrapper.setExtra(list);
        return wrapper;
    }

    protected BaseComponent[] resetItalics(BaseComponent[] components) {
        BaseComponent[] reset;
        TextComponent text;
        boolean isItalic;
        boolean needsReset = false;
        if (components.length == 0) {
            return components;
        }
        BaseComponent first = components[0];
        if (first instanceof TextComponent && !(isItalic = (text = (TextComponent)first).isItalic())) {
            needsReset = true;
        }
        if (needsReset && (reset = new ComponentBuilder("").italic(false).create()).length > 0) {
            reset[reset.length - 1].setExtra(Arrays.asList(components));
            components = reset;
        }
        return components;
    }

    protected BaseComponent[] parseChatComponents(String containsJson) {
        ArrayList<BaseComponent> components;
        List<Object> addToComponents = components = new ArrayList<BaseComponent>();
        String[] pieces = ChatUtils.getComponents(containsJson);
        BaseComponent addToComponent = null;
        for (String component : pieces) {
            try {
                boolean isJson = component.startsWith("{");
                List<BaseComponent> addComponents = isJson ? Arrays.asList(ComponentSerializer.parse((String)component)) : Arrays.asList(SpigotUtils.fromLegacyText(component));
                if (addComponents.isEmpty()) continue;
                addToComponents.addAll(addComponents);
                if (addToComponent != null) {
                    addToComponent.setExtra(addToComponents);
                }
                if (isJson || (addToComponents = (addToComponent = (BaseComponent)addToComponents.get(addToComponents.size() - 1)).getExtra()) != null) continue;
                addToComponents = new ArrayList();
            }
            catch (Exception ex) {
                this.platform.getLogger().log(Level.SEVERE, "Error parsing chat components from: " + component, ex);
            }
        }
        return components.toArray(new BaseComponent[0]);
    }

    public static BaseComponent[] fromLegacyText(String message) {
        return SpigotUtils.fromLegacyText(message, ChatColor.WHITE);
    }

    public static BaseComponent[] fromLegacyText(String message, ChatColor defaultColor) {
        ArrayList<TextComponent> components = new ArrayList<TextComponent>();
        StringBuilder builder = new StringBuilder();
        TextComponent component = new TextComponent();
        Matcher matcher = url.matcher(message);
        for (int i = 0; i < message.length(); ++i) {
            TextComponent old;
            char c = message.charAt(i);
            if (c == '\u00a7') {
                ChatColor format;
                if (++i >= message.length()) break;
                c = message.charAt(i);
                if (c >= 'A' && c <= 'Z') {
                    c = (char)(c + 32);
                }
                if (c == 'x' && i + 12 < message.length()) {
                    StringBuilder hex = new StringBuilder("#");
                    for (int j = 0; j < 6; ++j) {
                        hex.append(message.charAt(i + 2 + j * 2));
                    }
                    try {
                        format = ChatColor.of((String)hex.toString());
                    }
                    catch (IllegalArgumentException ex) {
                        format = null;
                    }
                    i += 12;
                } else {
                    format = ChatColor.getByChar((char)c);
                }
                if (format == null) continue;
                if (builder.length() > 0) {
                    old = component;
                    component = new TextComponent(old);
                    old.setText(builder.toString());
                    builder = new StringBuilder();
                    components.add(old);
                }
                if (format == ChatColor.BOLD) {
                    component.setBold(Boolean.valueOf(true));
                    continue;
                }
                if (format == ChatColor.ITALIC) {
                    component.setItalic(Boolean.valueOf(true));
                    continue;
                }
                if (format == ChatColor.UNDERLINE) {
                    component.setUnderlined(Boolean.valueOf(true));
                    continue;
                }
                if (format == ChatColor.STRIKETHROUGH) {
                    component.setStrikethrough(Boolean.valueOf(true));
                    continue;
                }
                if (format == ChatColor.MAGIC) {
                    component.setObfuscated(Boolean.valueOf(true));
                    continue;
                }
                if (format == ChatColor.RESET) {
                    format = defaultColor;
                    component = new TextComponent();
                    component.setColor(format);
                    continue;
                }
                component = new TextComponent();
                component.setColor(format);
                continue;
            }
            int pos = message.indexOf(32, i);
            if (pos == -1) {
                pos = message.length();
            }
            if (matcher.region(i, pos).find()) {
                if (builder.length() > 0) {
                    old = component;
                    component = new TextComponent(old);
                    old.setText(builder.toString());
                    builder = new StringBuilder();
                    components.add(old);
                }
                old = component;
                component = new TextComponent(old);
                String urlString = message.substring(i, pos);
                component.setText(urlString);
                component.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, urlString.startsWith("http") ? urlString : "http://" + urlString));
                components.add(component);
                i += pos - i - 1;
                component = old;
                continue;
            }
            builder.append(c);
        }
        component.setText(builder.toString());
        components.add(component);
        return components.toArray(new BaseComponent[0]);
    }
}

