/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.v1_21_5;

import com.elmakers.mine.bukkit.utility.ReflectionUtils;
import com.elmakers.mine.bukkit.utility.platform.Platform;
import com.elmakers.mine.bukkit.utility.platform.base.NBTUtilsBase;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.item.component.CustomData;
import org.bukkit.inventory.ItemStack;

public class NBTUtils
extends NBTUtilsBase {
    public NBTUtils(Platform platform) {
        super(platform);
    }

    @Override
    public Object getTag(ItemStack stack, String tag) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return null;
        }
        Object tagObject = this.platform.getItemUtils().getTag(stack);
        if (tagObject == null || !(tagObject instanceof NBTTagCompound)) {
            return null;
        }
        return ((NBTTagCompound)tagObject).a(tag);
    }

    @Override
    public Object getTag(Object nbtBase, String tag) {
        if (nbtBase == null || !(nbtBase instanceof NBTTagCompound)) {
            return null;
        }
        return ((NBTTagCompound)nbtBase).a(tag);
    }

    @Override
    public Set<String> getAllKeys(Object nbtBase) {
        if (nbtBase == null || !(nbtBase instanceof NBTTagCompound)) {
            return null;
        }
        return ((NBTTagCompound)nbtBase).e();
    }

    @Override
    public boolean contains(Object nbtBase, String tag) {
        if (nbtBase == null || !(nbtBase instanceof NBTTagCompound)) {
            return false;
        }
        return ((NBTTagCompound)nbtBase).b(tag);
    }

    @Override
    public Object createTag(Object nbtBase, String tag) {
        if (nbtBase == null || !(nbtBase instanceof NBTTagCompound)) {
            return null;
        }
        NBTTagCompound compoundTag = (NBTTagCompound)nbtBase;
        Optional childTag = compoundTag.m(tag);
        if (childTag.isPresent()) {
            return childTag.get();
        }
        NBTTagCompound newTag = new NBTTagCompound();
        compoundTag.a(tag, (NBTBase)newTag);
        return newTag;
    }

    @Override
    public Object createTag(ItemStack stack, String tag) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return null;
        }
        Object outputObject = this.getTag(stack, tag);
        if (outputObject == null || !(outputObject instanceof NBTTagCompound)) {
            Object craft = this.platform.getItemUtils().getHandle(stack);
            if (craft == null) {
                return null;
            }
            NBTTagCompound tagObject = (NBTTagCompound)this.platform.getItemUtils().getTag(craft);
            if (tagObject == null) {
                tagObject = new NBTTagCompound();
                CustomData customData = CustomData.a((NBTTagCompound)tagObject);
                tagObject = customData.e();
                ((net.minecraft.world.item.ItemStack)craft).b(DataComponents.b, (Object)customData);
            }
            outputObject = new NBTTagCompound();
            tagObject.a(tag, (NBTBase)((NBTTagCompound)outputObject));
        }
        return outputObject;
    }

    @Override
    public byte[] getByteArray(Object tag, String key) {
        if (tag == null || !(tag instanceof NBTTagCompound)) {
            return null;
        }
        Optional optional = ((NBTTagCompound)tag).j(key);
        return optional.orElse(null);
    }

    @Override
    public int[] getIntArray(Object tag, String key) {
        if (tag == null || !(tag instanceof NBTTagCompound)) {
            return null;
        }
        Optional optional = ((NBTTagCompound)tag).k(key);
        return optional.orElse(null);
    }

    @Override
    public String getString(Object node, String tag) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return null;
        }
        Optional optional = ((NBTTagCompound)node).i(tag);
        return optional.orElse(null);
    }

    @Override
    public String getString(ItemStack stack, String tag) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return null;
        }
        Object meta = null;
        Object tagObject = this.platform.getItemUtils().getTag(stack);
        if (tagObject == null || !(tagObject instanceof NBTTagCompound)) {
            return null;
        }
        Optional optional = ((NBTTagCompound)tagObject).i(tag);
        return optional.orElse(null);
    }

    @Override
    public Byte getOptionalByte(Object node, String tag) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return null;
        }
        Optional optional = ((NBTTagCompound)node).c(tag);
        return optional.orElse(null);
    }

    @Override
    public Integer getOptionalInt(Object node, String tag) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return null;
        }
        Optional optional = ((NBTTagCompound)node).e(tag);
        return optional.orElse(null);
    }

    @Override
    public Short getOptionalShort(Object node, String tag) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return null;
        }
        Optional optional = ((NBTTagCompound)node).d(tag);
        return optional.orElse(null);
    }

    @Override
    public Double getOptionalDouble(Object node, String tag) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return null;
        }
        Optional optional = ((NBTTagCompound)node).h(tag);
        return optional.orElse(null);
    }

    @Override
    public Boolean getOptionalBoolean(Object node, String tag) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return null;
        }
        Optional optional = ((NBTTagCompound)node).q(tag);
        return optional.orElse(null);
    }

    @Override
    public void setLong(Object node, String tag, long value) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return;
        }
        ((NBTTagCompound)node).a(tag, value);
    }

    @Override
    public void setBoolean(Object node, String tag, boolean value) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return;
        }
        ((NBTTagCompound)node).a(tag, value);
    }

    @Override
    public void setDouble(Object node, String tag, double value) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return;
        }
        ((NBTTagCompound)node).a(tag, value);
    }

    @Override
    public void setInt(Object node, String tag, int value) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return;
        }
        ((NBTTagCompound)node).a(tag, value);
    }

    @Override
    public void setMetaShort(Object node, String tag, short value) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return;
        }
        ((NBTTagCompound)node).a(tag, value);
    }

    @Override
    public void removeMeta(Object node, String tag) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return;
        }
        ((NBTTagCompound)node).r(tag);
    }

    @Override
    public void setTag(Object node, String tag, Object child) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return;
        }
        if (child == null) {
            ((NBTTagCompound)node).r(tag);
        } else if (child instanceof NBTBase) {
            ((NBTTagCompound)node).a(tag, (NBTBase)child);
        }
    }

    @Override
    public boolean setTag(ItemStack stack, String tag, Object child) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return false;
        }
        Object craft = this.platform.getItemUtils().getHandle(stack);
        if (craft == null) {
            return false;
        }
        Object node = this.platform.getItemUtils().getOrCreateTag(craft);
        if (node == null || !(node instanceof NBTTagCompound)) {
            return false;
        }
        if (child == null) {
            ((NBTTagCompound)node).r(tag);
        } else {
            ((NBTTagCompound)node).a(tag, (NBTBase)child);
        }
        return true;
    }

    @Override
    public void setString(Object node, String tag, String value) {
        if (node == null || !(node instanceof NBTTagCompound)) {
            return;
        }
        ((NBTTagCompound)node).a(tag, value);
    }

    @Override
    public void setString(ItemStack stack, String tag, String value) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return;
        }
        Object craft = this.platform.getItemUtils().getHandle(stack);
        if (craft == null) {
            return;
        }
        Object tagObject = this.platform.getItemUtils().getOrCreateTag(craft);
        if (tagObject == null || !(tagObject instanceof NBTTagCompound)) {
            return;
        }
        ((NBTTagCompound)tagObject).a(tag, value);
    }

    @Override
    public void setIntArray(Object tag, String key, int[] value) {
        if (tag == null || !(tag instanceof NBTTagCompound)) {
            return;
        }
        ((NBTTagCompound)tag).a(key, (NBTBase)new NBTTagIntArray(value));
    }

    @Override
    public void setByteArray(Object tag, String key, byte[] value) {
        if (tag == null || !(tag instanceof NBTTagCompound)) {
            return;
        }
        ((NBTTagCompound)tag).a(key, (NBTBase)new NBTTagByteArray(value));
    }

    @Override
    public void setEmptyList(Object tag, String key) {
        if (tag == null || !(tag instanceof NBTTagCompound)) {
            return;
        }
        ((NBTTagCompound)tag).a(key, (NBTBase)new NBTTagList());
    }

    @Override
    public void addToList(Object listObject, Object node) {
        if (listObject == null || !(listObject instanceof NBTTagList) || !(node instanceof NBTBase)) {
            return;
        }
        NBTTagList list = (NBTTagList)listObject;
        list.add((Object)((NBTBase)node));
    }

    @Override
    public Object readTagFromStream(InputStream input) {
        NBTTagCompound tag = null;
        try {
            tag = NBTCompressedStreamTools.a((InputStream)input, (NBTReadLimiter)NBTReadLimiter.a());
        }
        catch (Exception ex) {
            this.platform.getLogger().log(Level.WARNING, "Error reading from NBT input stream", ex);
        }
        return tag;
    }

    @Override
    public boolean writeTagToStream(Object tag, OutputStream output) {
        if (tag == null || !(tag instanceof NBTTagCompound)) {
            return false;
        }
        try {
            NBTCompressedStreamTools.a((NBTTagCompound)((NBTTagCompound)tag), (OutputStream)output);
        }
        catch (Exception ex) {
            this.platform.getLogger().log(Level.WARNING, "Error writing NBT output stream", ex);
            return false;
        }
        return true;
    }

    @Override
    public Collection<Object> getTagList(Object tag, String key) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (tag == null || !(tag instanceof NBTTagCompound)) {
            return list;
        }
        Optional optional = ((NBTTagCompound)tag).o(key);
        if (optional.isPresent()) {
            NBTTagList listTag = (NBTTagList)optional.get();
            Logger logger = this.platform.getLogger();
            int size = listTag.size();
            for (int i = 0; i < size; ++i) {
                NBTBase entry = (NBTBase)ReflectionUtils.getListItem(logger, listTag, i);
                list.add(entry);
            }
        }
        return list;
    }

    @Override
    public Object newCompoundTag() {
        return new NBTTagCompound();
    }

    @Override
    public boolean setSpawnEggEntityData(ItemStack spawnEgg, Object entityData) {
        if (this.platform.getItemUtils().isEmpty(spawnEgg)) {
            return false;
        }
        if (entityData == null || !(entityData instanceof NBTTagCompound)) {
            return false;
        }
        Object handle = this.platform.getItemUtils().getHandle(spawnEgg);
        if (handle == null) {
            return false;
        }
        net.minecraft.world.item.ItemStack itemStack = (net.minecraft.world.item.ItemStack)handle;
        CustomData customData = CustomData.a((NBTTagCompound)((NBTTagCompound)entityData));
        itemStack.b(DataComponents.Y, (Object)customData);
        return true;
    }
}

