/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.modern2.entity;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.utility.ConfigUtils;
import com.elmakers.mine.bukkit.utility.platform.base.entity.EntityAnimalData;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Goat;

public class EntityGoatData
extends EntityAnimalData {
    public Boolean screaming;

    public EntityGoatData(ConfigurationSection parameters, MageController controller) {
        super(parameters, controller);
        this.screaming = ConfigUtils.getOptionalBoolean(parameters, "screaming");
    }

    public EntityGoatData(Entity entity) {
        super(entity);
        if (entity instanceof Goat) {
            Goat goat = (Goat)entity;
            this.screaming = goat.isScreaming();
        }
    }

    @Override
    public void apply(Entity entity) {
        super.apply(entity);
        if (entity instanceof Goat && this.screaming != null) {
            Goat goat = (Goat)entity;
            goat.setScreaming(this.screaming.booleanValue());
        }
    }

    @Override
    public boolean cycle(Entity entity) {
        Goat goat;
        if (!this.canCycle(entity)) {
            return false;
        }
        goat.setScreaming(!(goat = (Goat)entity).isScreaming());
        return true;
    }

    @Override
    public boolean canCycle(Entity entity) {
        return entity instanceof Goat;
    }
}

