/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.modern2;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.utility.platform.DeprecatedUtils;
import com.elmakers.mine.bukkit.utility.platform.SchematicUtils;
import com.elmakers.mine.bukkit.utility.platform.SkinUtils;
import com.elmakers.mine.bukkit.utility.platform.modern.ModernPlatform;
import com.elmakers.mine.bukkit.utility.platform.modern2.Modern2DeprecatedUtils;
import com.elmakers.mine.bukkit.utility.platform.modern2.Modern2SchematicUtils;
import com.elmakers.mine.bukkit.utility.platform.modern2.Modern2SkinUtils;
import com.elmakers.mine.bukkit.utility.platform.modern2.event.EntityLoadEventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.PluginManager;

public abstract class Modern2Platform
extends ModernPlatform {
    private Boolean hasEntityLoadEvent;

    public Modern2Platform(MageController controller) {
        super(controller);
    }

    @Override
    protected SkinUtils createSkinUtils() {
        return new Modern2SkinUtils(this);
    }

    @Override
    protected SchematicUtils createSchematicUtils() {
        return new Modern2SchematicUtils(this);
    }

    @Override
    protected DeprecatedUtils createDeprecatedUtils() {
        return new Modern2DeprecatedUtils(this);
    }

    @Override
    public boolean hasEntityLoadEvent() {
        if (this.hasEntityLoadEvent == null) {
            try {
                Class.forName("org.bukkit.event.world.EntitiesLoadEvent");
                this.hasEntityLoadEvent = true;
            }
            catch (Exception ex) {
                this.hasEntityLoadEvent = false;
                this.getLogger().warning("EntitiesLoadEvent not found, it is recommended that you update your server software");
            }
        }
        return this.hasEntityLoadEvent;
    }

    @Override
    public boolean hasDeferredEntityLoad() {
        return true;
    }

    @Override
    public void registerEvents(PluginManager pm) {
        super.registerEvents(pm);
        if (this.hasEntityLoadEvent()) {
            pm.registerEvents((Listener)new EntityLoadEventHandler(this.controller), this.controller.getPlugin());
        }
    }
}

