/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.modern2;

import com.elmakers.mine.bukkit.utility.Base64Coder;
import com.elmakers.mine.bukkit.utility.ReflectionUtils;
import com.elmakers.mine.bukkit.utility.platform.Platform;
import com.elmakers.mine.bukkit.utility.platform.base.InventoryUtilsBase;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.net.URL;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.block.Skull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.SkullMeta;

public abstract class Modern2InventoryUtils
extends InventoryUtilsBase {
    public Modern2InventoryUtils(Platform platform) {
        super(platform);
    }

    @Override
    public ItemStack setSkullURL(ItemStack itemStack, URL url, UUID id, String name) {
        try {
            if (this.platform.getItemUtils().isEmpty(itemStack)) {
                return itemStack;
            }
            GameProfile gameProfile = new GameProfile(id, name);
            PropertyMap properties = gameProfile.getProperties();
            if (properties == null) {
                return itemStack;
            }
            itemStack = this.platform.getItemUtils().makeReal(itemStack);
            if (this.platform.getItemUtils().isEmpty(itemStack)) {
                return itemStack;
            }
            String textureJSON = "{textures:{SKIN:{url:\"" + url + "\"}}}";
            String encoded = Base64Coder.encodeString(textureJSON);
            Property newProperty = new Property("textures", encoded);
            properties.put((Object)"textures", (Object)newProperty);
            ItemMeta skullMeta = itemStack.getItemMeta();
            this.setSkullProfile(skullMeta, (Object)gameProfile);
            itemStack.setItemMeta(skullMeta);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return itemStack;
    }

    @Override
    public boolean isSkull(ItemStack item) {
        if (item == null) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        return meta instanceof SkullMeta;
    }

    @Override
    public Object getSkullProfile(ItemMeta itemMeta) {
        if (itemMeta == null || !(itemMeta instanceof SkullMeta)) {
            return null;
        }
        return ReflectionUtils.getPrivate(this.platform.getLogger(), itemMeta, itemMeta.getClass(), "profile");
    }

    @Override
    public Object getSkullProfile(Skull state) {
        return ReflectionUtils.getPrivate(this.platform.getLogger(), state, state.getClass(), "profile");
    }

    @Override
    public boolean setSkullProfile(Skull state, Object data) {
        return ReflectionUtils.setPrivate(this.platform.getLogger(), state, state.getClass(), "profile", data);
    }

    @Override
    public int getMapId(ItemStack mapItem) {
        ItemMeta meta = mapItem.getItemMeta();
        if (meta instanceof MapMeta) {
            MapMeta mapMeta = (MapMeta)meta;
            return mapMeta.getMapId();
        }
        return 0;
    }

    @Override
    public void setMapId(ItemStack mapItem, int id) {
        ItemMeta meta = mapItem.getItemMeta();
        if (meta instanceof MapMeta) {
            MapMeta mapMeta = (MapMeta)meta;
            mapMeta.setMapId(id);
            mapItem.setItemMeta((ItemMeta)mapMeta);
        }
    }

    @Override
    public ItemStack createMap(Material material, int mapId) {
        ItemStack mapItem = new ItemStack(material, 1);
        this.setMapId(mapItem, mapId);
        return mapItem;
    }
}

