/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.modern.event;

import com.elmakers.mine.bukkit.api.entity.EntityData;
import com.elmakers.mine.bukkit.api.magic.MageController;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.inventory.EntityEquipment;

public class EntityTransformController
implements Listener {
    private MageController controller;

    public EntityTransformController(MageController controller) {
        this.controller = controller;
    }

    @EventHandler
    public void onEntityTransform(EntityTransformEvent event) {
        Entity original = event.getEntity();
        EntityData entityData = this.controller.getMob(original);
        if (entityData != null && !entityData.isTransformable()) {
            event.setCancelled(true);
            Entity transformed = event.getTransformedEntity();
            if (transformed instanceof LivingEntity && original instanceof LivingEntity) {
                LivingEntity from = (LivingEntity)transformed;
                LivingEntity to = (LivingEntity)original;
                EntityEquipment equipment = to.getEquipment();
                if (equipment != null) {
                    equipment.setArmorContents(from.getEquipment().getArmorContents());
                    equipment.setItemInMainHand(from.getEquipment().getItemInMainHand());
                    equipment.setItemInOffHand(from.getEquipment().getItemInOffHand());
                }
            }
        }
    }
}

