/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.modern.entity;

import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.utility.ConfigUtils;
import com.elmakers.mine.bukkit.utility.platform.PlatformInterpreter;
import com.elmakers.mine.bukkit.utility.platform.modern.entity.EntityChestedHorseData;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Llama;
import org.bukkit.inventory.ItemStack;

public class EntityLlamaData
extends EntityChestedHorseData {
    private Llama.Color color;
    private Integer strength;
    protected ItemStack decor;

    public EntityLlamaData(ConfigurationSection parameters, MageController controller) {
        super(parameters, controller);
        Logger log = controller.getLogger();
        String colorString = parameters.getString("llama_color");
        if (colorString != null && !colorString.isEmpty()) {
            try {
                this.color = Llama.Color.valueOf((String)colorString.toUpperCase());
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Invalid llama_color: " + colorString, ex);
            }
        }
        this.strength = ConfigUtils.getOptionalInteger(parameters, "llama_strength");
        String itemKey = parameters.getString("decor_item");
        if (itemKey != null && !itemKey.isEmpty()) {
            ItemData itemData = controller.getOrCreateItem(itemKey);
            if (itemData == null) {
                log.warning("Invalid decor_item in llama config: " + itemKey);
            } else {
                this.decor = itemData.getItemStack();
            }
        }
    }

    public EntityLlamaData(Entity entity, MageController controller) {
        super(entity, controller);
        if (entity instanceof Llama) {
            Llama llama = (Llama)entity;
            this.color = llama.getColor();
            this.strength = llama.getStrength();
            this.decor = PlatformInterpreter.getPlatform().getItemUtils().getCopy(llama.getInventory().getDecor());
        }
    }

    @Override
    public void apply(Entity entity) {
        super.apply(entity);
        if (entity instanceof Llama) {
            Llama llama = (Llama)entity;
            if (this.color != null) {
                llama.setColor(this.color);
            }
            if (this.strength != null && this.strength > 0 && this.strength < 6) {
                llama.setStrength(this.strength.intValue());
            }
            if (!PlatformInterpreter.getPlatform().getItemUtils().isEmpty(this.decor)) {
                llama.getInventory().setDecor(this.decor);
            }
        }
    }

    @Override
    public boolean cycle(Entity entity) {
        if (!this.canCycle(entity)) {
            return false;
        }
        Llama llama = (Llama)entity;
        Llama.Color type = llama.getColor();
        Llama.Color[] typeValues = Llama.Color.values();
        int typeOrdinal = (type.ordinal() + 1) % typeValues.length;
        type = typeValues[typeOrdinal];
        llama.setColor(type);
        return true;
    }

    @Override
    public boolean canCycle(Entity entity) {
        return entity instanceof Llama;
    }
}

