/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.modern.entity;

import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.utility.ConfigUtils;
import com.elmakers.mine.bukkit.utility.platform.modern.entity.EntityAbstractHorseData;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.AbstractHorseInventory;
import org.bukkit.inventory.ItemStack;

public class EntityChestedHorseData
extends EntityAbstractHorseData {
    private Boolean hasChest;
    private ItemStack[] inventory;

    public EntityChestedHorseData(ConfigurationSection parameters, MageController controller) {
        super(parameters, controller);
        this.hasChest = ConfigUtils.getOptionalBoolean(parameters, "has_chest");
        List<String> inventory = ConfigUtils.getStringList(parameters, "inventory");
        if (inventory != null && !inventory.isEmpty()) {
            this.inventory = new ItemStack[inventory.size()];
            int index = 0;
            for (String itemKey : inventory) {
                ItemData data = controller.getOrCreateItem(itemKey);
                this.inventory[index++] = data == null ? null : data.getItemStack();
            }
        }
    }

    public EntityChestedHorseData(Entity entity, MageController controller) {
        super(entity, controller);
        if (entity instanceof ChestedHorse) {
            ChestedHorse horse = (ChestedHorse)entity;
            this.hasChest = horse.isCarryingChest();
            AbstractHorseInventory inventory = horse.getInventory();
            if (inventory != null) {
                this.inventory = inventory.getContents();
            }
        }
    }

    @Override
    public void apply(Entity entity) {
        super.apply(entity);
        if (entity instanceof ChestedHorse) {
            AbstractHorseInventory inventory;
            ChestedHorse horse = (ChestedHorse)entity;
            if (this.hasChest != null) {
                horse.setCarryingChest(this.hasChest.booleanValue());
            }
            if (this.inventory != null && (inventory = horse.getInventory()) != null) {
                inventory.clear();
                inventory.setContents(this.inventory);
            }
        }
    }
}

