/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.modern.entity;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.entity.EntityExtraData;
import com.elmakers.mine.bukkit.utility.ConfigUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.PiglinAbstract;

public class EntityAbstractPiglinData
extends EntityExtraData {
    private Boolean transformable;

    public EntityAbstractPiglinData(ConfigurationSection parameters, MageController controller) {
        this.transformable = ConfigUtils.getOptionalBoolean(parameters, "transformable");
    }

    public EntityAbstractPiglinData(Entity entity) {
        if (entity instanceof PiglinAbstract) {
            PiglinAbstract piglin = (PiglinAbstract)entity;
            this.transformable = !piglin.isImmuneToZombification();
        }
    }

    @Override
    public void apply(Entity entity) {
        if (entity instanceof PiglinAbstract) {
            PiglinAbstract piglin = (PiglinAbstract)entity;
            if (this.transformable != null) {
                piglin.setImmuneToZombification(this.transformable == false);
            }
        }
    }
}

