/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.base;

import com.elmakers.mine.bukkit.utility.ProfileCallback;
import com.elmakers.mine.bukkit.utility.ProfileResponse;
import com.elmakers.mine.bukkit.utility.SkullLoadedCallback;
import com.elmakers.mine.bukkit.utility.WordUtils;
import com.elmakers.mine.bukkit.utility.platform.DeprecatedUtils;
import com.elmakers.mine.bukkit.utility.platform.Platform;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.UnsafeValues;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;

public abstract class DeprecatedUtilsBase
implements DeprecatedUtils {
    protected final Platform platform;

    protected DeprecatedUtilsBase(Platform platform) {
        this.platform = platform;
    }

    @Override
    public void updateInventory(Player player) {
        player.updateInventory();
    }

    @Override
    public byte getData(Block block) {
        return block.getData();
    }

    @Override
    public byte getWoolData(DyeColor color) {
        return color.getWoolData();
    }

    @Override
    public int getId(Material material) {
        return material.getId();
    }

    @Override
    public int getTypeId(Block block) {
        return block.getType().getId();
    }

    @Override
    public MapView getMap(int id) {
        return this.platform.getCompatibilityUtils().getMapById(id);
    }

    @Override
    public short getMapId(MapView mapView) {
        return mapView.getId();
    }

    @Override
    public String getName(EntityType entityType) {
        String name = entityType.getName();
        return WordUtils.capitalize(name);
    }

    @Override
    public String getDisplayName(Entity entity) {
        if (entity instanceof Player) {
            return ((Player)entity).getDisplayName();
        }
        String customName = entity.getCustomName();
        if (customName != null && !customName.isEmpty()) {
            return customName;
        }
        return this.getName(entity.getType());
    }

    @Override
    public OfflinePlayer getOfflinePlayer(String name) {
        return Bukkit.getOfflinePlayer((String)name);
    }

    @Override
    public Player getPlayer(String name) {
        return Bukkit.getPlayer((String)name);
    }

    @Override
    public Player getPlayerExact(String name) {
        return Bukkit.getPlayerExact((String)name);
    }

    @Override
    public FallingBlock spawnFallingBlock(Location location, Material material, byte data) {
        return location.getWorld().spawnFallingBlock(location, material, data);
    }

    @Override
    public byte getRawData(BlockState state) {
        return state.getRawData();
    }

    @Override
    public DyeColor getBaseColor(BannerMeta banner) {
        return banner.getBaseColor();
    }

    @Override
    public void setBaseColor(BannerMeta banner, DyeColor color) {
        banner.setBaseColor(color);
    }

    @Override
    public void setSkullOwner(final ItemStack itemStack, String ownerName, final SkullLoadedCallback callback) {
        this.platform.getSkinUtils().fetchProfile(ownerName, new ProfileCallback(){

            @Override
            public void result(ProfileResponse response) {
                if (response != null) {
                    Object gameProfile = response.getGameProfile();
                    ItemMeta meta = itemStack.getItemMeta();
                    if (meta instanceof SkullMeta) {
                        DeprecatedUtilsBase.this.platform.getInventoryUtils().setSkullProfile(meta, gameProfile);
                        itemStack.setItemMeta(meta);
                    }
                }
                if (callback != null) {
                    callback.updated(itemStack);
                }
            }
        });
    }

    @Override
    public void setSkullOwner(final ItemStack itemStack, UUID ownerUUID, final SkullLoadedCallback callback) {
        this.platform.getSkinUtils().fetchProfile(ownerUUID, new ProfileCallback(){

            @Override
            public void result(ProfileResponse response) {
                if (response != null) {
                    Object gameProfile = response.getGameProfile();
                    ItemMeta meta = itemStack.getItemMeta();
                    if (meta instanceof SkullMeta) {
                        DeprecatedUtilsBase.this.platform.getInventoryUtils().setSkullProfile(meta, gameProfile);
                        itemStack.setItemMeta(meta);
                    }
                }
                if (callback != null) {
                    callback.updated(itemStack);
                }
            }
        });
    }

    @Override
    public void setOwner(final Skull skull, UUID uuid) {
        this.platform.getSkinUtils().fetchProfile(uuid, new ProfileCallback(){

            @Override
            public void result(ProfileResponse response) {
                if (response != null) {
                    Object gameProfile = response.getGameProfile();
                    DeprecatedUtilsBase.this.platform.getInventoryUtils().setSkullProfile(skull, gameProfile);
                }
                skull.update(true, false);
            }
        });
    }

    @Override
    public void setOwner(final Skull skull, String ownerName) {
        this.platform.getSkinUtils().fetchProfile(ownerName, new ProfileCallback(){

            @Override
            public void result(ProfileResponse response) {
                if (response != null) {
                    Object gameProfile = response.getGameProfile();
                    DeprecatedUtilsBase.this.platform.getInventoryUtils().setSkullProfile(skull, gameProfile);
                }
                skull.update(true, false);
            }
        });
    }

    @Override
    public void showPlayer(Plugin plugin, Player toPlayer, Player showPlayer) {
        toPlayer.showPlayer(showPlayer);
    }

    @Override
    public void hidePlayer(Plugin plugin, Player fromPlayer, Player hidePlayer) {
        fromPlayer.hidePlayer(hidePlayer);
    }

    @Override
    public int[] getExpLevelCostsOffered(PrepareItemEnchantEvent event) {
        return event.getExpLevelCostsOffered();
    }

    @Override
    public Entity getPassenger(Entity mount) {
        return mount.getPassenger();
    }

    @Override
    public void setPassenger(Entity mount, Entity passenger) {
        mount.setPassenger(passenger);
    }

    @Override
    public UnsafeValues getUnsafe() {
        return Bukkit.getUnsafe();
    }

    @Override
    public boolean isTransparent(Material material) {
        return material.isTransparent();
    }

    @Override
    public void setItemDamage(ItemStack itemStack, short damage) {
        if (this.getItemDamage(itemStack) != damage) {
            itemStack.setDurability(damage);
        }
    }

    @Override
    public short getItemDamage(ItemStack itemStack) {
        return itemStack.getDurability();
    }

    @Override
    public Biome getBiome(Location location) {
        return location.getWorld().getBiome(location.getBlockX(), location.getBlockZ());
    }

    @Override
    public ItemStack createItemStack(Material material, int amount, short legacyData) {
        return new ItemStack(material, amount, legacyData);
    }
}

