/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.api.entity.EntityData;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.slikey.effectlib.math.EquationTransform;
import com.elmakers.mine.bukkit.slikey.effectlib.math.EquationVariableProvider;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class SpellUtils {
    public static Mage getCastSource(EntityData.SourceType sourceType, Entity initiator, Entity target, Mage magicBlock, MageController controller, String loggerContext) {
        Entity sourceEntity = initiator;
        switch (sourceType) {
            case PLAYER: {
                sourceEntity = initiator;
                break;
            }
            case OPPED_PLAYER: {
                controller.getLogger().info("Invalid spell source on " + loggerContext + ": OPPED_initiator, will not op initiator for spell cast");
                sourceEntity = initiator;
                break;
            }
            case MOB: {
                if (target == null) {
                    controller.getLogger().info("Invalid spell source on " + loggerContext + ": MOB, there is no target entity");
                    break;
                }
                sourceEntity = target;
                break;
            }
            case BLOCK: {
                if (magicBlock == null) {
                    controller.getLogger().info("Invalid spell source on " + loggerContext + ": BLOCK, there is no magic block");
                } else {
                    return magicBlock;
                }
            }
            default: {
                controller.getLogger().info("Invalid spell source on " + loggerContext + ": " + String.valueOf((Object)sourceType) + ", using MOB instead");
                sourceEntity = target;
            }
        }
        return controller.getMage(sourceEntity);
    }

    public static void prepareParameters(EntityData.TargetType targetType, ConfigurationSection parameters, Entity initiator, Entity target, Mage magicBlock, MageController controller, String loggerContext) {
        switch (targetType) {
            case PLAYER: {
                parameters.set("player", (Object)initiator.getName());
                break;
            }
            case MOB: {
                if (target == null) {
                    controller.getLogger().info("Invalid spell source on " + loggerContext + ": MOB, there is no target entity");
                    break;
                }
                parameters.set("entity", (Object)target.getUniqueId().toString());
                break;
            }
            case BLOCK: {
                if (magicBlock == null) {
                    controller.getLogger().info("Invalid spell source on " + loggerContext + ": BLOCK, there is no magic block");
                    break;
                }
                Location loc = magicBlock.getLocation();
                parameters.set("tx", (Object)loc.getX());
                parameters.set("ty", (Object)loc.getY());
                parameters.set("tz", (Object)loc.getZ());
                parameters.set("tworld", (Object)loc.getWorld().getName());
                break;
            }
        }
    }

    public static Double modifyProperty(double original, String equation, String originalVariable, EquationVariableProvider variableProvider) {
        EquationTransform transform = new EquationTransform(equation, originalVariable);
        transform.setVariableProvider(variableProvider);
        if (transform.isValid()) {
            transform.setVariable(originalVariable, original);
            double transformedValue = transform.get();
            if (!Double.isNaN(transformedValue)) {
                return transformedValue;
            }
        }
        return null;
    }
}

