/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.maps.MapController;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.TargetingSpell;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.Target;
import com.elmakers.mine.bukkit.utility.WordUtils;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CameraSpell
extends TargetingSpell {
    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        String url;
        ItemStack newMapItem = null;
        Integer priority = ConfigurationUtils.getInteger(parameters, "priority", null);
        boolean selfie = false;
        if (parameters.contains("id")) {
            newMapItem = this.controller.getMap(parameters.getInt("id", 0));
            String mapName = parameters.getString("name", "Image");
            ItemMeta meta = newMapItem.getItemMeta();
            meta.setDisplayName(mapName);
            newMapItem.setItemMeta(meta);
        }
        MapController maps = this.controller.getMaps();
        if (newMapItem == null && (url = parameters.getString("url")) != null) {
            int x = parameters.getInt("x", 0);
            int y = parameters.getInt("y", 0);
            int width = parameters.getInt("width", 0);
            int height = parameters.getInt("height", 0);
            String mapName = parameters.getString("name", "Photo");
            newMapItem = maps.getURLItem(this.getWorld().getName(), url, mapName, x, y, width, height, priority);
        }
        if (newMapItem == null) {
            Target target = this.getTarget();
            String playerName = parameters.getString("name");
            String metaName = null;
            if (playerName == null && target != null) {
                if (target.hasEntity()) {
                    Entity targetEntity = target.getEntity();
                    boolean bl = selfie = targetEntity == this.mage.getEntity();
                    if (targetEntity instanceof Player) {
                        playerName = ((Player)targetEntity).getName();
                    } else {
                        playerName = this.getMobSkin(targetEntity.getType());
                        if (playerName != null && ((metaName = targetEntity.getCustomName()) == null || metaName.isEmpty())) {
                            metaName = targetEntity.getType().getName();
                            metaName = WordUtils.capitalize(metaName.toLowerCase().replace('_', ' '));
                        }
                    }
                } else {
                    Block targetBlock = target.getBlock();
                    if (targetBlock == null) {
                        return SpellResult.NO_TARGET;
                    }
                    playerName = this.getBlockSkin(targetBlock.getType());
                    if (playerName != null) {
                        metaName = target.getBlock().getType().name();
                        metaName = WordUtils.capitalize(metaName.toLowerCase().replace('_', ' '));
                    }
                }
            }
            if (playerName == null) {
                Player player = this.mage.getPlayer();
                if (player == null) {
                    return SpellResult.NO_TARGET;
                }
                playerName = player.getName();
                selfie = true;
            }
            if (parameters.contains("reload")) {
                maps.forceReloadPlayerPortrait(this.getWorld().getName(), playerName);
            }
            metaName = metaName == null ? playerName : metaName;
            newMapItem = maps.getPlayerPortrait(this.getWorld().getName(), playerName, priority, "Photo of " + metaName);
        }
        if (newMapItem == null) {
            return SpellResult.FAIL;
        }
        this.getWorld().dropItemNaturally(this.getLocation(), newMapItem);
        return selfie ? SpellResult.CAST_SELF : SpellResult.CAST_TARGET;
    }
}

