/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.integration;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.utility.Replacer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderHook;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;

public class PlaceholderAPIManager
extends PlaceholderExpansion {
    private final MageController controller;

    public PlaceholderAPIManager(MageController controller) {
        this.controller = controller;
        if (!this.register()) {
            controller.getLogger().warning("PlaceholderAPI integration failed");
        } else {
            controller.getLogger().info("PlaceholderAPI integration enabled. Available placeholders:");
            controller.getLogger().info("magic_path, magic_class, magic_wand, magic_spell, magic_mana, magic_mana_max, magic_sp, magic_spell_count");
            controller.getLogger().info("All magic attributes also available with a magic_ prefix");
            controller.getLogger().info("Add to messages/placeholders to add custom placeholders");
        }
    }

    @Nullable
    public String getPlaceholder(Player player, String namespace, String variable) {
        PlaceholderHook hook = (PlaceholderHook)PlaceholderAPI.getPlaceholders().get(namespace);
        return hook == null ? null : hook.onPlaceholderRequest(player, variable);
    }

    @Nonnull
    public String setPlaceholders(Player player, String message) {
        return PlaceholderAPI.setPlaceholders((Player)player, (String)message);
    }

    public String onPlaceholderRequest(Player player, String placeholder) {
        Mage mage = this.controller.getMage(player);
        String replacement = this.controller.getMessages().getIfSet("placeholders." + placeholder);
        if (replacement == null && mage instanceof Replacer) {
            replacement = ((Replacer)((Object)mage)).getReplacement(placeholder, true);
        } else if (replacement != null) {
            replacement = mage.parameterize(replacement);
        }
        return replacement == null ? "" : replacement;
    }

    public String getIdentifier() {
        return "magic";
    }

    public String getPlugin() {
        return "Magic";
    }

    public String getAuthor() {
        return "NathanWolf";
    }

    public String getVersion() {
        return this.controller.getPlugin().getDescription().getVersion();
    }
}

