/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CheckAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.item.InventorySlot;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.platform.CompatibilityUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CheckInventoryAction
extends CheckAction {
    private ItemStack item;
    private InventorySlot slot;
    private Collection<Enchantment> allowedEnchantments;
    private Collection<Enchantment> blockedEnchantments;
    private boolean targetCaster;
    private boolean targetBlock;
    private boolean materialOnly;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        String slotName;
        super.prepare(context, parameters);
        this.targetBlock = parameters.getBoolean("target_block", false);
        this.targetCaster = parameters.getBoolean("target_caster", false);
        this.materialOnly = parameters.getBoolean("material_only", false);
        String itemKey = parameters.getString("item");
        if (itemKey != null && !itemKey.isEmpty()) {
            this.item = context.getController().createItem(itemKey);
            if (this.item == null) {
                context.getLogger().warning("Invalid item: " + itemKey);
            }
        }
        if ((slotName = parameters.getString("slot")) != null && !slotName.isEmpty()) {
            this.slot = InventorySlot.parse(slotName);
            if (this.slot == null) {
                context.getLogger().warning("Invalid slot in CheckInventory action: " + slotName);
            }
        }
        this.allowedEnchantments = this.parseEnchantmentList(context, parameters, "allowed_enchantments");
        this.blockedEnchantments = this.parseEnchantmentList(context, parameters, "blocked_enchantments");
    }

    @Nullable
    private Collection<Enchantment> parseEnchantmentList(CastContext context, ConfigurationSection parameters, String key) {
        ArrayList<Enchantment> enchantments = null;
        List keys = parameters.getStringList(key);
        if (keys != null && !keys.isEmpty()) {
            enchantments = new ArrayList<Enchantment>();
            CompatibilityUtils compatibilityUtils = CompatibilityLib.getCompatibilityUtils();
            for (String enchantmentKey : keys) {
                Enchantment enchantment = compatibilityUtils.getEnchantmentByKey(enchantmentKey);
                if (enchantment != null) {
                    enchantments.add(enchantment);
                    continue;
                }
                context.getLogger().warning("Invalid enchantment in CheckInventory action " + key + ": " + enchantmentKey);
            }
        }
        return enchantments;
    }

    protected boolean checkBlock(CastContext context) {
        BlockState state;
        Block targetBlock = context.getTargetBlock();
        BlockState blockState = state = targetBlock == null ? null : targetBlock.getState();
        if (state == null || !(state instanceof InventoryHolder)) {
            return false;
        }
        InventoryHolder holder = (InventoryHolder)state;
        if (this.slot != null) {
            int slotNumber = this.slot.getSlot();
            if (slotNumber == -1) {
                context.getLogger().warning("Invalid slot for CheckInventory action: " + String.valueOf(this.slot));
                return false;
            }
            ItemStack item = holder.getInventory().getItem(slotNumber);
            return this.checkItem(item);
        }
        if (this.item == null) {
            context.getLogger().warning("CheckInventory needs an item or slot to check for a container");
            return false;
        }
        if (this.materialOnly) {
            return holder.getInventory().contains(this.item.getType());
        }
        return holder.getInventory().contains(this.item);
    }

    protected boolean checkItem(ItemStack checkItemStack) {
        ItemMeta meta;
        boolean defaultResult = false;
        if (this.item != null) {
            if (CompatibilityLib.getItemUtils().isEmpty(checkItemStack)) {
                return CompatibilityLib.getItemUtils().isEmpty(this.item);
            }
            if (this.materialOnly) {
                return checkItemStack.getType() == this.item.getType() && checkItemStack.getAmount() >= this.item.getAmount();
            }
            return checkItemStack.isSimilar(this.item) && checkItemStack.getAmount() >= this.item.getAmount();
        }
        ItemMeta itemMeta = meta = checkItemStack == null ? null : checkItemStack.getItemMeta();
        if (this.blockedEnchantments != null) {
            defaultResult = true;
            if (meta != null) {
                for (Enchantment enchantment : this.blockedEnchantments) {
                    if (!meta.hasEnchant(enchantment)) continue;
                    return false;
                }
            }
        }
        if (this.allowedEnchantments != null) {
            defaultResult = false;
            if (meta == null) {
                return false;
            }
            for (Enchantment enchantment : this.allowedEnchantments) {
                if (!meta.hasEnchant(enchantment)) continue;
                return true;
            }
        }
        return defaultResult;
    }

    @Override
    protected boolean isAllowed(CastContext context) {
        Mage mage;
        if (this.targetBlock) {
            return this.checkBlock(context);
        }
        if (this.targetCaster) {
            mage = context.getMage();
        } else {
            Entity targetEntity = context.getTargetEntity();
            if (targetEntity == null || !(targetEntity instanceof Player)) {
                return false;
            }
            mage = context.getController().getMage(targetEntity);
        }
        if (this.slot != null) {
            int slotNumber = this.slot.getSlot(mage);
            if (slotNumber == -1) {
                context.getLogger().warning("Invalid slot for CheckInventory action: " + String.valueOf(this.slot));
                return false;
            }
            ItemStack item = mage.getItem(slotNumber);
            return this.checkItem(item);
        }
        return this.item != null && mage.hasItem(this.item);
    }

    @Override
    public boolean requiresTarget() {
        return !this.targetCaster;
    }

    @Override
    public boolean requiresTargetEntity() {
        return !this.targetCaster && !this.targetBlock;
    }
}

