/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.world.spawn.builtin;

import com.elmakers.mine.bukkit.api.entity.EntityData;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.StringUtils;
import com.elmakers.mine.bukkit.utility.random.RandomUtils;
import com.elmakers.mine.bukkit.utility.random.WeightedPair;
import com.elmakers.mine.bukkit.world.spawn.SpawnOption;
import com.elmakers.mine.bukkit.world.spawn.SpawnOptionParser;
import com.elmakers.mine.bukkit.world.spawn.SpawnResult;
import com.elmakers.mine.bukkit.world.spawn.SpawnRule;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import javax.annotation.Nonnull;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;

public class ReplaceRule
extends SpawnRule {
    protected Deque<WeightedPair<SpawnOption>> replaceProbability;
    protected int yOffset;
    protected boolean atHighestBlock;

    @Override
    public void finalizeLoad(String worldName) {
        if (!this.parameters.contains("type")) {
            this.parameters.set("type", this.parameters.get("replace_type"));
        }
        if (!this.parameters.contains("sub_type")) {
            this.parameters.set("sub_type", this.parameters.get("replace_sub_type"));
        }
        this.replaceProbability = new ArrayDeque<WeightedPair<SpawnOption>>();
        SpawnOptionParser parser = SpawnOptionParser.getInstance(this.controller);
        RandomUtils.populateProbabilityMap(parser, this.replaceProbability, this.parameters, "type");
        if (this.replaceProbability.isEmpty()) {
            this.controller.getLogger().warning("Error reading in configuration for custom mob in " + worldName + " for rule " + this.key);
            return;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (WeightedPair<SpawnOption> option : this.replaceProbability) {
            names.add(option.getValue().describe());
        }
        String replaceDescription = StringUtils.join(names, ",");
        replaceDescription = ChatColor.stripColor((String)replaceDescription);
        this.atHighestBlock = this.parameters.getBoolean("highest_block", false);
        this.yOffset = this.parameters.getInt("y_offset");
        this.logSpawnRule("Replacing " + this.getTargetEntityTypeName() + " in " + worldName + " with " + replaceDescription);
    }

    @Override
    @Nonnull
    public SpawnResult onProcess(Plugin plugin, LivingEntity entity) {
        if (this.replaceProbability.isEmpty()) {
            return SpawnResult.SKIP;
        }
        SpawnOption option = (SpawnOption)RandomUtils.weightedRandom(this.replaceProbability);
        if (option == null) {
            return SpawnResult.SKIP;
        }
        if (option.getType() == SpawnResult.REPLACE) {
            EntityData replacement = option.getReplacement();
            if (entity.getType() == replacement.getType()) {
                replacement.modify((Entity)entity);
                return SpawnResult.STOP;
            }
            Location location = entity.getLocation();
            if (this.atHighestBlock) {
                location.setY((double)location.getWorld().getHighestBlockYAt(location));
            }
            location.setY(location.getY() + (double)this.yOffset);
            Entity spawned = replacement.spawn(location);
            if (spawned == null) {
                return SpawnResult.SKIP;
            }
            if (!replacement.isPersistent()) {
                CompatibilityLib.getCompatibilityUtils().setPersist(spawned, false);
                CompatibilityLib.getCompatibilityUtils().setRemoveWhenFarAway(spawned, true);
            }
        }
        return option.getType();
    }
}

