/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.world.spawn;

import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.world.spawn.SpawnResult;
import com.elmakers.mine.bukkit.world.spawn.SpawnRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;

public class MagicSpawnHandler {
    public static final String BUILTIN_CLASSPATH = "com.elmakers.mine.bukkit.world.spawn.builtin";
    protected final MagicController controller;
    private final Map<EntityType, List<SpawnRule>> entityTypeMap = new HashMap<EntityType, List<SpawnRule>>();
    private final List<SpawnRule> globalRules = new ArrayList<SpawnRule>();
    protected String worldName;

    public MagicSpawnHandler(MagicController controller) {
        this.controller = controller;
    }

    protected SpawnResult processRules(Plugin plugin, LivingEntity entity, List<SpawnRule> rules) {
        if (rules != null) {
            for (SpawnRule rule : rules) {
                SpawnResult result = rule.process(plugin, entity);
                if (result == SpawnResult.SKIP) continue;
                return result;
            }
        }
        return SpawnResult.SKIP;
    }

    public boolean process(Plugin plugin, LivingEntity entity) {
        List<SpawnRule> entityRules = this.entityTypeMap.get(entity.getType());
        SpawnResult result = this.processRules(plugin, entity, entityRules);
        if (result == SpawnResult.STOP) {
            return false;
        }
        if (result != SpawnResult.SKIP) {
            return true;
        }
        result = this.processRules(plugin, entity, this.globalRules);
        return result == SpawnResult.REMOVE || result == SpawnResult.REPLACE;
    }

    protected void addRule(SpawnRule rule) {
        List<EntityType> targetTypes = rule.getTargetTypes();
        for (EntityType targetType : targetTypes) {
            List<SpawnRule> entityRules = this.entityTypeMap.get(targetType);
            if (entityRules == null) {
                entityRules = new ArrayList<SpawnRule>();
                this.entityTypeMap.put(targetType, entityRules);
            }
            entityRules.add(rule);
        }
        if (rule.isGlobal()) {
            this.globalRules.add(rule);
        }
    }

    public void load(String worldName, ConfigurationSection config) {
        this.worldName = worldName;
        if (config == null) {
            return;
        }
        for (String key : config.getKeys(false)) {
            String className;
            SpawnRule handler;
            ConfigurationSection handlerConfig = config.getConfigurationSection(key);
            if (handlerConfig == null) {
                this.controller.getLogger().warning("Was expecting a properties section in world entity_spawn config for key '" + worldName + "', but got: " + String.valueOf(config.get(key)));
                continue;
            }
            if (!handlerConfig.getBoolean("enabled", true) || (handler = this.createSpawnRule(className = handlerConfig.getString("class"))) == null || !handler.load(key, handlerConfig, this.controller)) continue;
            this.addRule(handler);
        }
    }

    public void finalizeLoad() {
        Collections.sort(this.globalRules);
        for (SpawnRule spawnRule : this.globalRules) {
            spawnRule.finalizeLoad(this.worldName);
        }
        for (List list : this.entityTypeMap.values()) {
            Collections.sort(list);
            for (SpawnRule rule : list) {
                rule.finalizeLoad(this.worldName);
            }
        }
    }

    @Nullable
    protected SpawnRule createSpawnRule(String className) {
        Object newObject;
        if (className == null) {
            return null;
        }
        if (((String)className).indexOf(46) <= 0 && !((String)(className = "com.elmakers.mine.bukkit.world.spawn.builtin." + (String)className)).endsWith("Rule")) {
            className = (String)className + "Rule";
        }
        Class<?> handlerClass = null;
        try {
            handlerClass = Class.forName((String)className);
        }
        catch (Throwable ex) {
            this.controller.getLogger().log(Level.WARNING, "Error loading handler: " + (String)className, ex);
            return null;
        }
        try {
            newObject = handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable ex) {
            this.controller.getLogger().log(Level.WARNING, "Error loading handler: " + (String)className, ex);
            return null;
        }
        if (newObject == null || !(newObject instanceof SpawnRule)) {
            this.controller.getLogger().warning("Error loading handler: " + (String)className + ", does it extend SpawnRule?");
            return null;
        }
        return (SpawnRule)newObject;
    }
}

