/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.v1_21_9;

import com.elmakers.mine.bukkit.utility.ChatUtils;
import com.elmakers.mine.bukkit.utility.EnteredStateTracker;
import com.elmakers.mine.bukkit.utility.ReflectionUtils;
import com.elmakers.mine.bukkit.utility.platform.ItemUtils;
import com.elmakers.mine.bukkit.utility.platform.Platform;
import com.elmakers.mine.bukkit.utility.platform.SpigotUtils;
import com.elmakers.mine.bukkit.utility.platform.base_v1_21_4.CompatibilityUtilsBase_v1_21_4;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.PacketPlayOutBlockBreakAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.decoration.EntityPainting;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityDragonFireball;
import net.minecraft.world.entity.projectile.EntityEgg;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.entity.projectile.EntityFireball;
import net.minecraft.world.entity.projectile.EntityFireballFireball;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.projectile.EntityLargeFireball;
import net.minecraft.world.entity.projectile.EntityLlamaSpit;
import net.minecraft.world.entity.projectile.EntityShulkerBullet;
import net.minecraft.world.entity.projectile.EntitySmallFireball;
import net.minecraft.world.entity.projectile.EntitySnowball;
import net.minecraft.world.entity.projectile.EntitySpectralArrow;
import net.minecraft.world.entity.projectile.EntityThrownExpBottle;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import net.minecraft.world.entity.projectile.EntityWitherSkull;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ThrownSplashPotion;
import net.minecraft.world.item.ItemBoneMeal;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Rotation;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.boss.BossBar;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.craftbukkit.v1_21_R6.CraftArt;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftArmorStand;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftHanging;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftItem;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.scheduler.CraftTask;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Witch;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;

public class CompatibilityUtils
extends CompatibilityUtilsBase_v1_21_4 {
    private final Map<String, EntityTypes<?>> projectileEntityTypes = new HashMap();
    private final Map<String, Class<? extends IProjectile>> projectileClasses = new HashMap<String, Class<? extends IProjectile>>();

    public CompatibilityUtils(Platform platform) {
        super(platform);
        this.populateProjectileClasses();
    }

    private void addProjectileClass(String key, Class<? extends IProjectile> projectileClass, EntityTypes<?> entityType) {
        this.projectileClasses.put(key, projectileClass);
        this.projectileEntityTypes.put(projectileClass.getSimpleName(), entityType);
    }

    private void populateProjectileClasses() {
        this.addProjectileClass("arrow", EntityTippedArrow.class, EntityTypes.i);
        this.addProjectileClass("tippedarrow", EntityTippedArrow.class, EntityTypes.i);
        this.addProjectileClass("tipped_arrow", EntityTippedArrow.class, EntityTypes.i);
        this.addProjectileClass("dragonfireball", EntityDragonFireball.class, EntityTypes.M);
        this.addProjectileClass("dragon_fireball", EntityDragonFireball.class, EntityTypes.M);
        this.addProjectileClass("fireball", EntityLargeFireball.class, EntityTypes.ab);
        this.addProjectileClass("largefireball", EntityLargeFireball.class, EntityTypes.ab);
        this.addProjectileClass("large_fireball", EntityLargeFireball.class, EntityTypes.ab);
        this.addProjectileClass("smallfireball", EntitySmallFireball.class, EntityTypes.bn);
        this.addProjectileClass("small_fireball", EntitySmallFireball.class, EntityTypes.bn);
        this.addProjectileClass("fireworks", EntityFireworks.class, EntityTypes.ac);
        this.addProjectileClass("firework", EntityFireworks.class, EntityTypes.ac);
        this.addProjectileClass("fireworkrocket", EntityFireworks.class, EntityTypes.ac);
        this.addProjectileClass("firework_rocket", EntityFireworks.class, EntityTypes.ac);
        this.addProjectileClass("fireworkrocketentity", EntityFireworks.class, EntityTypes.ac);
        this.addProjectileClass("fishinghook", EntityFishingHook.class, EntityTypes.bY);
        this.addProjectileClass("fishing_hook", EntityFishingHook.class, EntityTypes.bY);
        this.addProjectileClass("fishing_bobber", EntityFishingHook.class, EntityTypes.bY);
        this.addProjectileClass("llamaspit", EntityLlamaSpit.class, EntityTypes.aC);
        this.addProjectileClass("llama_spit", EntityLlamaSpit.class, EntityTypes.aC);
        this.addProjectileClass("shulkerbullet", EntityShulkerBullet.class, EntityTypes.bi);
        this.addProjectileClass("shulker_bullet", EntityShulkerBullet.class, EntityTypes.bi);
        this.addProjectileClass("snowball", EntitySnowball.class, EntityTypes.bp);
        this.addProjectileClass("spectralarrow", EntitySpectralArrow.class, EntityTypes.bs);
        this.addProjectileClass("spectral_arrow", EntitySpectralArrow.class, EntityTypes.bs);
        this.addProjectileClass("egg", EntityEgg.class, EntityTypes.O);
        this.addProjectileClass("thrownegg", EntityEgg.class, EntityTypes.O);
        this.addProjectileClass("enderpearl", EntityEnderPearl.class, EntityTypes.T);
        this.addProjectileClass("ender_pearl", EntityEnderPearl.class, EntityTypes.T);
        this.addProjectileClass("thrownenderpearl", EntityEnderPearl.class, EntityTypes.T);
        this.addProjectileClass("thrownexperiencebottle", EntityThrownExpBottle.class, EntityTypes.X);
        this.addProjectileClass("experiencebottle", EntityThrownExpBottle.class, EntityTypes.X);
        this.addProjectileClass("thrownpotion", ThrownSplashPotion.class, EntityTypes.ba);
        this.addProjectileClass("potion", ThrownSplashPotion.class, EntityTypes.ba);
        this.addProjectileClass("throwntrident", EntityThrownTrident.class, EntityTypes.bE);
        this.addProjectileClass("trident", EntityThrownTrident.class, EntityTypes.bE);
        this.addProjectileClass("witherskull", EntityWitherSkull.class, EntityTypes.bQ);
        this.addProjectileClass("wither_skull", EntityWitherSkull.class, EntityTypes.bQ);
    }

    @Override
    public Painting createPainting(Location location, BlockFace facing, Art art) {
        Painting newPainting = null;
        WorldServer level = ((CraftWorld)location.getWorld()).getHandle();
        EnumDirection directionEnum = null;
        try {
            directionEnum = EnumDirection.valueOf((String)facing.name());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        BlockPosition blockLocation = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        EntityPainting newEntity = new EntityPainting((net.minecraft.world.level.World)level, blockLocation, directionEnum, Holder.a((Object)CraftArt.bukkitToMinecraft((Art)art)));
        CraftEntity bukkitEntity = newEntity.getBukkitEntity();
        if (bukkitEntity != null && bukkitEntity instanceof Painting) {
            newPainting = (Painting)bukkitEntity;
        }
        return newPainting;
    }

    @Override
    public ItemFrame createItemFrame(Location location, BlockFace facing, Rotation rotation, ItemStack item) {
        ItemFrame newItemFrame = null;
        WorldServer level = ((CraftWorld)location.getWorld()).getHandle();
        EnumDirection directionEnum = null;
        try {
            directionEnum = EnumDirection.valueOf((String)facing.name());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        BlockPosition blockLocation = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        EntityItemFrame newEntity = new EntityItemFrame((net.minecraft.world.level.World)level, blockLocation, directionEnum);
        CraftEntity bukkitEntity = newEntity.getBukkitEntity();
        if (bukkitEntity != null && bukkitEntity instanceof ItemFrame) {
            newItemFrame = (ItemFrame)bukkitEntity;
            newItemFrame.setItem(this.platform.getItemUtils().getCopy(item));
            newItemFrame.setRotation(rotation);
        }
        return newItemFrame;
    }

    @Override
    public boolean addToWorld(World world, Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        WorldServer level = ((CraftWorld)world).getHandle();
        net.minecraft.world.entity.Entity entityHandle = ((CraftEntity)entity).getHandle();
        level.addFreshEntity(entityHandle, reason);
        return true;
    }

    @Override
    public void ageItem(Item item, int ticksToAge) {
        EntityItem nmsItem = ((CraftItem)item).getHandle();
        nmsItem.k = ticksToAge;
    }

    @Override
    public void magicDamage(Damageable target, double amount, Entity source) {
        block18: {
            try {
                net.minecraft.world.entity.Entity sourceHandle;
                if (target == null || target.isDead()) {
                    return;
                }
                if (!USE_MAGIC_DAMAGE || target instanceof Witch || target instanceof Enderman || target instanceof ArmorStand || !(target instanceof LivingEntity)) {
                    this.damage(target, amount, source);
                    return;
                }
                net.minecraft.world.entity.Entity targetHandle = ((CraftEntity)target).getHandle();
                if (targetHandle == null) {
                    return;
                }
                net.minecraft.world.entity.Entity entity = sourceHandle = source == null ? null : ((CraftEntity)source).getHandle();
                if (sourceHandle != null && source instanceof LivingEntity) {
                    Location location = target.getLocation();
                    ThrownPotion potion = this.getOrCreatePotionEntity(location);
                    net.minecraft.world.entity.Entity potionHandle = ((CraftEntity)potion).getHandle();
                    potion.setShooter((ProjectileSource)((LivingEntity)source));
                    DamageSource magicSource = sourceHandle.ei().c(potionHandle, sourceHandle);
                    try (EnteredStateTracker.Touchable damaging = this.isDamaging.enter();){
                        damaging.touch();
                        targetHandle.a(magicSource, (float)amount);
                        break block18;
                    }
                }
                try (EnteredStateTracker.Touchable damaging = this.isDamaging.enter();){
                    damaging.touch();
                    targetHandle.a(targetHandle.ei().q(), (float)amount);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected DamageSource getDamageSource(String damageType, net.minecraft.world.entity.Entity source, DamageSources damageSources) {
        switch (damageType.toUpperCase()) {
            case "IN_FIRE": {
                return damageSources.a();
            }
            case "LIGHTNING_BOLT": {
                return damageSources.c();
            }
            case "ON_FIRE": {
                return damageSources.d();
            }
            case "LAVA": {
                return damageSources.e();
            }
            case "HOT_FLOOR": {
                return damageSources.f();
            }
            case "IN_WALL": {
                return damageSources.g();
            }
            case "CRAMMING": {
                return damageSources.h();
            }
            case "DROWN": {
                return damageSources.i();
            }
            case "STARVE": {
                return damageSources.j();
            }
            case "CACTUS": {
                return damageSources.k();
            }
            case "FALL": {
                return damageSources.l();
            }
            case "FLY_INTO_WALL": {
                return damageSources.n();
            }
            case "OUT_OF_WORLD": {
                return damageSources.o();
            }
            case "GENERIC": {
                return damageSources.p();
            }
            case "MAGIC": {
                return damageSources.q();
            }
            case "WITHER": {
                return damageSources.r();
            }
            case "ANVIL": {
                return damageSources.b(source);
            }
            case "FALLING_BLOCK": {
                return damageSources.a(source);
            }
            case "DRAGON_BREATH": {
                return damageSources.s();
            }
            case "DRY_OUT": {
                return damageSources.t();
            }
            case "SWEET_BERRY_BUSH": {
                return damageSources.u();
            }
            case "FREEZE": {
                return damageSources.v();
            }
            case "FALLING_STALACTITE": {
                return damageSources.c(source);
            }
            case "STALAGMITE": {
                return damageSources.w();
            }
        }
        return null;
    }

    @Override
    public void damage(Damageable target, double amount, Entity source, String damageType) {
        if (target == null || target.isDead()) {
            return;
        }
        if (damageType.equalsIgnoreCase("direct")) {
            double health = target.getHealth() - amount;
            target.setHealth(Math.max(health, 0.0));
            return;
        }
        if (damageType.equalsIgnoreCase("magic")) {
            this.magicDamage(target, amount, source);
            return;
        }
        net.minecraft.world.entity.Entity targetHandle = ((CraftEntity)target).getHandle();
        if (targetHandle == null) {
            return;
        }
        net.minecraft.world.entity.Entity sourceHandle = ((CraftEntity)source).getHandle();
        DamageSource damageSource = this.getDamageSource(damageType, sourceHandle, targetHandle.ei());
        if (damageSource == null) {
            this.magicDamage(target, amount, source);
            return;
        }
        try (EnteredStateTracker.Touchable damaging = this.isDamaging.enter();){
            damaging.touch();
            targetHandle.a(damageSource, (float)amount);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public Vector getPosition(Object entityData, String tag) {
        if (entityData == null || !(entityData instanceof NBTTagCompound)) {
            return null;
        }
        NBTTagCompound data = (NBTTagCompound)entityData;
        Optional optionalList = data.o(tag);
        if (!optionalList.isPresent()) {
            return null;
        }
        NBTTagList list = (NBTTagList)optionalList.get();
        Optional optionalX = list.k(0);
        Optional optionalY = list.k(1);
        Optional optionalZ = list.k(2);
        if (!(optionalX.isPresent() && optionalY.isPresent() && optionalZ.isPresent())) {
            return null;
        }
        double x = (Double)optionalX.get();
        double y = (Double)optionalY.get();
        double z = (Double)optionalZ.get();
        return new Vector(x, y, z);
    }

    @Override
    public BlockVector getBlockVector(Object entityData, String tag) {
        if (entityData == null || !(entityData instanceof NBTTagCompound)) {
            return null;
        }
        NBTTagCompound data = (NBTTagCompound)entityData;
        Optional optionalArray = data.k(tag);
        if (!optionalArray.isPresent()) {
            return null;
        }
        int[] coords = (int[])optionalArray.get();
        if (coords.length < 3) {
            return null;
        }
        return new BlockVector(coords[0], coords[1], coords[2]);
    }

    @Override
    public void setEntityMotion(Entity entity, Vector motion) {
        net.minecraft.world.entity.Entity nms = ((CraftEntity)entity).getHandle();
        nms.k(new Vec3D(motion.getX(), motion.getY(), motion.getZ()));
    }

    @Override
    public void setFallingBlockDamage(FallingBlock entity, float fallHurtAmount, int fallHurtMax) {
        entity.setHurtEntities(true);
        EntityFallingBlock nms = (EntityFallingBlock)((CraftEntity)entity).getHandle();
        nms.p = fallHurtMax;
        nms.q = fallHurtAmount;
    }

    @Override
    public void setDisabledSlots(ArmorStand armorStand, int disabledSlots) {
        EntityArmorStand nms = ((CraftArmorStand)armorStand).getHandle();
        nms.cq = disabledSlots;
    }

    @Override
    public int getDisabledSlots(ArmorStand armorStand) {
        EntityArmorStand nms = ((CraftArmorStand)armorStand).getHandle();
        return nms.cq;
    }

    @Override
    public void setInvisible(Entity entity, boolean invisible) {
        net.minecraft.world.entity.Entity nms = ((CraftEntity)entity).getHandle();
        nms.l(invisible);
    }

    @Override
    public Boolean isInvisible(Entity entity) {
        net.minecraft.world.entity.Entity nms = ((CraftEntity)entity).getHandle();
        return nms.cB();
    }

    @Override
    public boolean isPersistentInvisible(Entity entity) {
        net.minecraft.world.entity.Entity nms = ((CraftEntity)entity).getHandle();
        return nms.persistentInvisibility;
    }

    @Override
    public void setPersistentInvisible(Entity entity, boolean invisible) {
        net.minecraft.world.entity.Entity nms = ((CraftEntity)entity).getHandle();
        nms.persistentInvisibility = invisible;
    }

    @Override
    public void setYawPitch(Entity entity, float yaw, float pitch) {
        net.minecraft.world.entity.Entity nms = ((CraftEntity)entity).getHandle();
        nms.v(yaw % 360.0f);
        nms.w(pitch % 360.0f);
    }

    @Override
    public void setLocation(Entity entity, double x, double y, double z, float yaw, float pitch) {
        net.minecraft.world.entity.Entity nms = ((CraftEntity)entity).getHandle();
        nms.a(x, y, z, yaw, pitch);
    }

    @Override
    public void addFlightExemption(Player player, int ticks) {
        EntityPlayer nms = ((CraftPlayer)player).getHandle();
        ReflectionUtils.setPrivateNeedsFixing(this.platform.getLogger(), nms.g, PlayerConnection.class, "aboveGroundTickCount", "J", -ticks);
    }

    @Override
    public boolean isValidProjectileClass(Class<?> projectileType) {
        return projectileType != null && IProjectile.class.isAssignableFrom(projectileType);
    }

    @Override
    public Projectile spawnProjectile(Class<?> projectileType, Location location, Vector direction, ProjectileSource source, float speed, float spread, float spreadLocations, Random random) {
        Constructor<?> constructor = null;
        WorldServer nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        Projectile projectile = null;
        try {
            CraftEntity entity;
            EntityTypes<?> entityType = null;
            constructor = projectileType.getConstructor(EntityTypes.class, net.minecraft.world.level.World.class);
            entityType = this.projectileEntityTypes.get(projectileType.getSimpleName());
            if (entityType == null) {
                throw new Exception("Failed to find entity type for projectile class " + projectileType.getName());
            }
            Object nmsProjectile = null;
            try {
                nmsProjectile = constructor.newInstance(entityType, nmsWorld);
            }
            catch (Exception ex) {
                nmsProjectile = null;
                this.platform.getLogger().log(Level.WARNING, "Error spawning projectile of class " + projectileType.getName(), ex);
            }
            if (nmsProjectile == null || !(nmsProjectile instanceof net.minecraft.world.entity.Entity)) {
                throw new Exception("Failed to spawn projectile of class " + projectileType.getName());
            }
            if (nmsProjectile instanceof EntityFireball) {
                EntityFireball fireballIsh = nmsProjectile;
                double spreadWeight = Math.min((double)0.4f, (double)spread * (double)0.0075f);
                double dx = direction.getX() + random.nextGaussian() * spreadWeight;
                double dy = direction.getY() + random.nextGaussian() * spreadWeight;
                double dz = direction.getZ() + random.nextGaussian() * spreadWeight;
                fireballIsh.a(new Vec3D(dx, dy, dz), (double)speed * 0.1);
            }
            net.minecraft.world.entity.Entity nmsEntity = nmsProjectile;
            Vector modifiedLocation = location.toVector().clone();
            if (EntityFireballFireball.class.isAssignableFrom(projectileType) && spreadLocations > 0.0f) {
                modifiedLocation.setX(modifiedLocation.getX() + direction.getX() + random.nextGaussian() * (double)spread / 5.0);
                modifiedLocation.setY(modifiedLocation.getY() + direction.getY() + random.nextGaussian() * (double)spread / 5.0);
                modifiedLocation.setZ(modifiedLocation.getZ() + direction.getZ() + random.nextGaussian() * (double)spread / 5.0);
            }
            nmsEntity.b(modifiedLocation.getX(), modifiedLocation.getY(), modifiedLocation.getZ(), location.getYaw(), location.getPitch());
            if (nmsEntity instanceof IProjectile) {
                IProjectile nms = (IProjectile)nmsEntity;
                nms.c(direction.getX(), direction.getY(), direction.getZ(), speed, spread);
            }
            if ((entity = nmsEntity.getBukkitEntity()) == null || !(entity instanceof Projectile)) {
                throw new Exception("Got invalid bukkit entity from projectile of class " + projectileType.getName());
            }
            projectile = (Projectile)entity;
            if (source != null) {
                projectile.setShooter(source);
                nmsEntity.projectileSource = source;
            }
            nmsWorld.addFreshEntity(nmsEntity, CreatureSpawnEvent.SpawnReason.DEFAULT);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
        return projectile;
    }

    @Override
    public void setDamage(Projectile projectile, double damage) {
        net.minecraft.world.entity.Entity nms = ((CraftEntity)projectile).getHandle();
        if (!(nms instanceof EntityTippedArrow)) {
            return;
        }
        EntityTippedArrow arrow = (EntityTippedArrow)nms;
        arrow.i(damage);
    }

    @Override
    public void decreaseLifespan(Projectile projectile, int ticks) {
        net.minecraft.world.entity.Entity nms = ((CraftEntity)projectile).getHandle();
        if (!(nms instanceof EntityTippedArrow)) {
            return;
        }
        EntityTippedArrow arrow = (EntityTippedArrow)nms;
        arrow.t = ticks;
    }

    @Override
    public Entity spawnEntity(Location target, EntityType entityType, CreatureSpawnEvent.SpawnReason spawnReason) {
        CraftWorld craftWorld = (CraftWorld)target.getWorld();
        return craftWorld.spawn(target, entityType.getEntityClass(), null, spawnReason);
    }

    public NBTTagCompound getEntityData(Entity entity) {
        if (entity == null) {
            return null;
        }
        TagValueOutput valueOutput = TagValueOutput.a((ProblemReporter)ProblemReporter.a);
        ((CraftEntity)entity).getHandle().c((ValueOutput)valueOutput);
        return valueOutput.b();
    }

    @Override
    public String getEntityType(Entity entity) {
        if (entity == null) {
            return null;
        }
        return ((CraftEntity)entity).getHandle().bW();
    }

    protected void sendPacket(Server server, Location source, Collection<? extends Player> players, Packet<?> packet) throws Exception {
        players = players != null && players.size() > 0 ? players : server.getOnlinePlayers();
        int viewDistance = Bukkit.getServer().getViewDistance() * 16;
        int viewDistanceSquared = viewDistance * viewDistance;
        World sourceWorld = source.getWorld();
        for (Player player : players) {
            Location location = player.getLocation();
            if (!location.getWorld().equals((Object)sourceWorld) || !(location.distanceSquared(source) <= (double)viewDistanceSquared)) continue;
            this.sendPacket(player, packet);
        }
    }

    protected void sendPacket(Player player, Packet<?> packet) throws Exception {
        EntityPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        nmsPlayer.g.b(packet);
    }

    @Override
    public void sendBreaking(Player player, long id, Location location, int breakAmount) {
        try {
            BlockPosition blockPosition = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            PacketPlayOutBlockBreakAnimation packet = new PacketPlayOutBlockBreakAnimation((int)id, blockPosition, breakAmount);
            this.sendPacket(player, (Packet<?>)packet);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public org.bukkit.block.Block getHitBlock(ProjectileHitEvent event) {
        return event.getHitBlock();
    }

    @Override
    public Entity getEntity(World world, UUID uuid) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftWorld)world).getHandle().d(uuid);
        return nmsEntity == null ? null : nmsEntity.getBukkitEntity();
    }

    @Override
    public boolean applyBonemeal(Location location) {
        if (this.dummyItem == null) {
            this.dummyItem = new ItemStack(Material.DIRT, 64);
            this.dummyItem = this.platform.getItemUtils().makeReal(this.dummyItem);
        }
        this.dummyItem.setAmount(64);
        WorldServer nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        net.minecraft.world.item.ItemStack itemStack = (net.minecraft.world.item.ItemStack)this.platform.getItemUtils().getHandle(this.dummyItem);
        BlockPosition blockPosition = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        return ItemBoneMeal.a((net.minecraft.world.item.ItemStack)itemStack, (net.minecraft.world.level.World)nmsWorld, (BlockPosition)blockPosition);
    }

    @Override
    public boolean applyPhysics(org.bukkit.block.Block block) {
        WorldServer nmsWorld = ((CraftWorld)block.getWorld()).getHandle();
        BlockPosition blockLocation = new BlockPosition(block.getX(), block.getY(), block.getZ());
        IBlockData blockState = nmsWorld.a_(blockLocation);
        this.clearItems(block.getLocation());
        this.platform.getDeprecatedUtils().setTypeAndData(block, Material.AIR, (byte)0, false);
        return nmsWorld.a(blockLocation, blockState, 3);
    }

    @Override
    public Location getHangingLocation(Entity entity) {
        Location location = entity.getLocation();
        if (!(entity instanceof Hanging)) {
            return location;
        }
        EntityHanging nms = ((CraftHanging)entity).getHandle();
        BlockPosition position = nms.dF();
        location.setX((double)position.u());
        location.setY((double)position.v());
        location.setZ((double)position.w());
        return location;
    }

    @Override
    public boolean setAutoBlockState(org.bukkit.block.Block block, Location target, BlockFace facing, boolean physics, Player originator) {
        EnumDirection direction;
        if (block == null || facing == null || target == null) {
            return false;
        }
        IBlockData blockState = ((CraftBlock)block).getNMS();
        if (blockState == null) {
            return false;
        }
        Block nmsBlock = blockState.b();
        ItemStack blockItem = new ItemStack(block.getType());
        EntityPlayer originatorHandle = ((CraftPlayer)originator).getHandle();
        WorldServer world = ((CraftWorld)block.getWorld()).getHandle();
        Object item = this.platform.getItemUtils().getHandle(this.platform.getItemUtils().makeReal(blockItem));
        if (originatorHandle == null || world == null || item == null) {
            return false;
        }
        BlockPosition blockPosition = new BlockPosition(block.getX(), block.getY(), block.getZ());
        Vec3D vec3D = new Vec3D(target.getX(), target.getY(), target.getZ());
        try {
            direction = EnumDirection.valueOf((String)facing.name());
        }
        catch (Exception ex) {
            this.platform.getLogger().log(Level.SEVERE, "Could not translate to NMS direction: " + facing);
            return false;
        }
        MovingObjectPositionBlock hitResult = new MovingObjectPositionBlock(vec3D, direction, blockPosition, false);
        BlockActionContext actionContext = new BlockActionContext((EntityHuman)originatorHandle, EnumHand.a, (net.minecraft.world.item.ItemStack)item, hitResult);
        IBlockData state = nmsBlock.a(actionContext);
        if (state == null) {
            return false;
        }
        CraftBlock cBlock = (CraftBlock)block;
        CraftBlock.setTypeAndData((GeneratorAccess)cBlock.getHandle(), (BlockPosition)cBlock.getPosition(), (IBlockData)cBlock.getNMS(), (IBlockData)state, (boolean)physics);
        return true;
    }

    @Override
    public boolean forceUpdate(org.bukkit.block.Block block, boolean physics) {
        if (block == null) {
            return false;
        }
        IBlockData blockState = ((CraftBlock)block).getNMS();
        if (blockState == null) {
            return false;
        }
        Block nmsBlock = blockState.b();
        IBlockData blockData = nmsBlock.m();
        WorldServer world = ((CraftWorld)block.getWorld()).getHandle();
        BlockPosition blockPosition = new BlockPosition(block.getX(), block.getY(), block.getZ());
        world.a(blockPosition, blockData, 11);
        return false;
    }

    @Override
    public Class<?> getProjectileClass(String projectileTypeName) {
        return this.projectileClasses.get(projectileTypeName.toLowerCase());
    }

    @Override
    public Entity spawnFireworkEffect(Material fireworkMaterial, Server server, Location location, FireworkEffect effect, int power, Vector direction, Integer expectedLifespan, Integer ticksFlown, boolean silent) {
        CraftEntity entity = null;
        try {
            if (fireworkMaterial == null) {
                return null;
            }
            WorldServer level = ((CraftWorld)location.getWorld()).getHandle();
            ItemStack itemStack = new ItemStack(fireworkMaterial);
            FireworkMeta meta = (FireworkMeta)itemStack.getItemMeta();
            meta.addEffect(effect);
            meta.setPower(power);
            itemStack.setItemMeta((ItemMeta)meta);
            Object item = this.platform.getItemUtils().getHandle(this.platform.getItemUtils().makeReal(itemStack));
            EntityFireworks fireworkHandle = new EntityFireworks((net.minecraft.world.level.World)level, location.getX(), location.getY(), location.getZ(), (net.minecraft.world.item.ItemStack)item);
            fireworkHandle.f(silent);
            if (direction != null) {
                fireworkHandle.k(new Vec3D(direction.getX(), direction.getY(), direction.getZ()));
            }
            if (ticksFlown != null) {
                fireworkHandle.h = ticksFlown;
            }
            if (expectedLifespan != null) {
                fireworkHandle.i = expectedLifespan;
            }
            if (direction == null) {
                BlockPosition blockPos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
                PacketPlayOutSpawnEntity fireworkPacket = new PacketPlayOutSpawnEntity((net.minecraft.world.entity.Entity)fireworkHandle, 76, blockPos);
                int fireworkId = fireworkHandle.az();
                DataWatcher watcher = fireworkHandle.aC();
                PacketPlayOutEntityMetadata metadataPacket = new PacketPlayOutEntityMetadata(fireworkId, watcher.b());
                PacketPlayOutEntityStatus statusPacket = new PacketPlayOutEntityStatus((net.minecraft.world.entity.Entity)fireworkHandle, 17);
                PacketPlayOutEntityDestroy destroyPacket = new PacketPlayOutEntityDestroy(new int[]{fireworkId});
                Collection players = server.getOnlinePlayers();
                this.sendPacket(server, location, players, (Packet<?>)fireworkPacket);
                this.sendPacket(server, location, players, (Packet<?>)metadataPacket);
                this.sendPacket(server, location, players, (Packet<?>)statusPacket);
                this.sendPacket(server, location, players, (Packet<?>)destroyPacket);
                return null;
            }
            level.addFreshEntity((net.minecraft.world.entity.Entity)fireworkHandle, CreatureSpawnEvent.SpawnReason.CUSTOM);
            entity = fireworkHandle.getBukkitEntity();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return entity;
    }

    @Override
    public boolean loadAllTagsFromNBT(ConfigurationSection tags, Object tag) {
        if (!(tag instanceof NBTTagCompound)) {
            return false;
        }
        NBTTagCompound compoundTag = (NBTTagCompound)tag;
        Set<String> keys = this.platform.getNBTUtils().getTagKeys(tag);
        if (keys == null) {
            return false;
        }
        for (String tagName : keys) {
            NBTBase metaBase = compoundTag.a(tagName);
            if (metaBase == null) continue;
            if (metaBase instanceof NBTTagCompound) {
                ConfigurationSection newSection = tags.createSection(tagName);
                this.loadAllTagsFromNBT(newSection, metaBase);
                continue;
            }
            try {
                tags.set(tagName, this.platform.getNBTUtils().getTagValue(metaBase));
            }
            catch (Exception ex) {
                this.platform.getLogger().log(Level.SEVERE, "Failed to load NBT tags", ex);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean setRawLore(ItemStack itemStack, List<String> lore) {
        ItemUtils itemUtils = this.platform.getItemUtils();
        net.minecraft.world.item.ItemStack mcItemStack = (net.minecraft.world.item.ItemStack)itemUtils.getHandle(itemStack);
        if (mcItemStack == null) {
            return false;
        }
        ArrayList<IChatBaseComponent> components = new ArrayList<IChatBaseComponent>();
        for (String line : lore) {
            components.add(this.toNMSComponent(line));
        }
        ItemLore loreComponent = new ItemLore(components);
        mcItemStack.b(DataComponents.j, (Object)loreComponent);
        return true;
    }

    @Override
    public List<String> getRawLore(ItemStack itemStack) {
        ArrayList<String> lines = new ArrayList<String>();
        ItemUtils itemUtils = this.platform.getItemUtils();
        net.minecraft.world.item.ItemStack mcItemStack = (net.minecraft.world.item.ItemStack)itemUtils.getHandle(itemStack);
        if (mcItemStack == null) {
            return lines;
        }
        ItemLore itemLore = (ItemLore)mcItemStack.a(DataComponents.j);
        for (IChatBaseComponent component : itemLore.a()) {
            lines.add(this.fromNMSComponent(component));
        }
        return lines;
    }

    @Override
    protected boolean sendActionBarPackets(Player player, String message) {
        IChatMutableComponent component = IChatBaseComponent.b((String)message);
        ClientboundSystemChatPacket packet = new ClientboundSystemChatPacket((IChatBaseComponent)component, true);
        try {
            this.sendPacket(player, (Packet<?>)packet);
        }
        catch (Exception ex) {
            this.platform.getLogger().log(Level.SEVERE, "Error updating action bar", ex);
            return false;
        }
        return true;
    }

    @Override
    public boolean setBossBarTitle(BossBar bossBar, String title, String font) {
        if (ChatUtils.isDefaultFont(font)) {
            this.setBossBarTitle(bossBar, title);
            return true;
        }
        SpigotUtils spigot = this.platform.getSpigotUtils();
        if (spigot == null) {
            return false;
        }
        this.setBossBarTitleComponents(bossBar, spigot.serializeBossBar(title, font), title);
        return true;
    }

    @Override
    protected void setBossBarTitleComponents(BossBar bossBar, String serialized, String fallback) {
        Object handle = ReflectionUtils.getHandle(this.platform.getLogger(), bossBar);
        if (handle == null || !(handle instanceof BossBattleServer)) {
            bossBar.setTitle(fallback);
            return;
        }
        BossBattleServer bossEvent = (BossBattleServer)handle;
        IChatBaseComponent component = this.toNMSComponent(serialized);
        if (component == null) {
            bossBar.setTitle(fallback);
        } else {
            bossEvent.a(component);
        }
    }

    private IChatBaseComponent toNMSComponent(String serialized) {
        Object component;
        if (serialized == null || serialized.isEmpty()) {
            return null;
        }
        try {
            component = serialized.isEmpty() ? CommonComponents.a : (serialized.startsWith("{") ? CraftChatMessage.fromJSON((String)serialized) : IChatBaseComponent.b((String)serialized));
        }
        catch (Exception ex) {
            this.platform.getLogger().log(Level.WARNING, "Invalid JSON message: " + serialized, ex);
            component = CommonComponents.a;
        }
        return component;
    }

    private String fromNMSComponent(IChatBaseComponent component) {
        return CraftChatMessage.toJSON((IChatBaseComponent)component);
    }

    @Override
    public Runnable getTaskRunnable(BukkitTask task) {
        return (Runnable)ReflectionUtils.getPrivate(this.platform.getLogger(), task, CraftTask.class, "rTask");
    }

    @Override
    public boolean isSwingingArm(Entity entity) {
        if (entity == null) {
            return false;
        }
        net.minecraft.world.entity.Entity nms = ((CraftEntity)entity).getHandle();
        if (nms == null || !(nms instanceof EntityLiving)) {
            return false;
        }
        return ((EntityLiving)nms).bo;
    }

    @Override
    public boolean setLastDamaged(Entity damaged, Entity damager) {
        if (damager == null) {
            return false;
        }
        net.minecraft.world.entity.Entity nmsDamager = ((CraftEntity)damager).getHandle();
        if (nmsDamager == null || !(nmsDamager instanceof EntityLiving)) {
            return false;
        }
        EntityLiving livingDamager = (EntityLiving)nmsDamager;
        net.minecraft.world.entity.Entity nmsDamaged = damaged == null ? null : ((CraftEntity)damaged).getHandle();
        livingDamager.C(nmsDamaged);
        return true;
    }

    @Override
    public boolean setLastDamagedBy(Entity damaged, Entity damager) {
        if (damager == null) {
            return false;
        }
        net.minecraft.world.entity.Entity nmsDamaged = ((CraftEntity)damager).getHandle();
        if (nmsDamaged == null || !(nmsDamaged instanceof EntityLiving)) {
            return false;
        }
        EntityLiving livingDamaged = (EntityLiving)nmsDamaged;
        net.minecraft.world.entity.Entity nmsDamager = ((CraftEntity)damager).getHandle();
        EntityLiving livingDamager = nmsDamager instanceof EntityLiving ? (EntityLiving)nmsDamaged : null;
        livingDamaged.a(livingDamager);
        return true;
    }
}

