/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.base.event;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.rp.ResourcePackStatus;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;

public class ResourcePackListener
implements Listener {
    private final MageController controller;

    public ResourcePackListener(MageController controller) {
        this.controller = controller;
    }

    @EventHandler
    public void onResourcePackStatus(PlayerResourcePackStatusEvent event) {
        ResourcePackStatus status = ResourcePackStatus.UNKNOWN;
        this.controller.info("Got resource pack status from player " + event.getPlayer().getName() + ": " + String.valueOf(event.getStatus()), 15);
        switch (event.getStatus()) {
            case SUCCESSFULLY_LOADED: {
                status = ResourcePackStatus.LOADED;
                break;
            }
            case DECLINED: {
                status = ResourcePackStatus.DECLINED;
                break;
            }
            case FAILED_DOWNLOAD: {
                status = ResourcePackStatus.FAILED;
                break;
            }
            default: {
                return;
            }
        }
        this.controller.onResourcePackStatus(event.getPlayer(), status);
    }
}

