/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.base.entity;

import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.utility.ConfigUtils;
import com.elmakers.mine.bukkit.utility.platform.base.entity.EntityAnimalData;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class EntityEnderSignalData
extends EntityAnimalData {
    private Boolean dropItem;
    private Integer despawnTimer;
    private Location targetLocation;
    private Object configLocation;
    private ItemStack item;

    public EntityEnderSignalData(ConfigurationSection parameters, MageController controller) {
        super(parameters, controller);
        this.dropItem = ConfigUtils.getOptionalBoolean(parameters, "drop_item");
        if (parameters.contains("despawn_timer")) {
            this.despawnTimer = parameters.getInt("despawn_timer");
        } else if (parameters.contains("duration")) {
            int duration = parameters.getInt("duration");
            this.despawnTimer = 80 - duration / 50;
        }
        String itemKey = parameters.getString("item");
        if (itemKey != null && !itemKey.isEmpty()) {
            ItemData itemData = controller.getOrCreateItem(itemKey);
            if (itemData == null) {
                controller.getLogger().warning("Invalid item in ender_signal.item config: " + itemKey);
            } else {
                this.item = itemData.getItemStack();
            }
        }
        this.configLocation = parameters.get("target_location");
    }

    public EntityEnderSignalData(Entity entity) {
        super(entity);
        if (entity instanceof EnderSignal) {
            EnderSignal signal = (EnderSignal)entity;
            this.dropItem = signal.getDropItem();
            this.despawnTimer = signal.getDespawnTimer();
            this.targetLocation = signal.getTargetLocation();
            this.item = signal.getItem();
        }
    }

    @Override
    public void applyPostSpawn(Entity entity) {
        super.applyPostSpawn(entity);
        if (entity instanceof EnderSignal) {
            EnderSignal signal = (EnderSignal)entity;
            if (this.dropItem != null) {
                signal.setDropItem(this.dropItem.booleanValue());
            }
            if (this.despawnTimer != null) {
                signal.setDespawnTimer(this.despawnTimer.intValue());
            }
        }
    }

    @Override
    public void apply(Entity entity) {
        super.apply(entity);
        if (entity instanceof EnderSignal) {
            EnderSignal signal = (EnderSignal)entity;
            if (this.dropItem != null) {
                signal.setDropItem(this.dropItem.booleanValue());
            }
            if (this.despawnTimer != null) {
                signal.setDespawnTimer(this.despawnTimer.intValue());
            }
            if (this.targetLocation != null) {
                signal.setTargetLocation(this.targetLocation);
            } else if (this.configLocation != null) {
                Location relativeTarget = ConfigUtils.toLocation(this.configLocation, entity.getLocation());
                signal.setTargetLocation(relativeTarget);
            }
            if (this.item != null) {
                signal.setItem(this.item);
            }
        }
    }
}

