/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.base;

import com.elmakers.mine.bukkit.utility.ConfigUtils;
import com.elmakers.mine.bukkit.utility.platform.NBTUtils;
import com.elmakers.mine.bukkit.utility.platform.Platform;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public abstract class NBTUtilsBase
implements NBTUtils {
    protected final Platform platform;

    protected NBTUtilsBase(Platform platform) {
        this.platform = platform;
    }

    @Override
    public boolean containsTag(ItemStack stack, String tag) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return false;
        }
        return this.getTag(stack, tag) != null;
    }

    @Override
    public String getString(ItemStack stack, String tag, String defaultValue) {
        String result = this.getString(stack, tag);
        return result == null ? defaultValue : result;
    }

    @Override
    public String getString(Object node, String tag, String defaultValue) {
        String meta = this.getString(node, tag);
        return meta == null || meta.length() == 0 ? defaultValue : meta;
    }

    @Override
    public short getShort(Object node, String tag, short defaultValue) {
        Short meta = this.getOptionalShort(node, tag);
        return meta == null ? defaultValue : meta;
    }

    @Override
    public int getInt(Object node, String tag, int defaultValue) {
        Integer meta = this.getOptionalInt(node, tag);
        return meta == null ? defaultValue : meta;
    }

    @Override
    public int getInt(ItemStack stack, String tag, int defaultValue) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return defaultValue;
        }
        int result = defaultValue;
        try {
            Object tagObject = this.platform.getItemUtils().getTag(stack);
            if (tagObject == null) {
                return defaultValue;
            }
            Integer value = this.getOptionalInt(tagObject, tag);
            result = value == null ? defaultValue : value;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Override
    public void setInt(ItemStack stack, String tag, int value) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return;
        }
        try {
            Object craft = this.platform.getItemUtils().getHandle(stack);
            if (craft == null) {
                return;
            }
            Object tagObject = this.platform.getItemUtils().getOrCreateTag(craft);
            if (tagObject == null) {
                return;
            }
            this.setInt(tagObject, tag, value);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void removeMeta(ItemStack stack, String tag) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return;
        }
        try {
            Object craft = this.platform.getItemUtils().getHandle(stack);
            if (craft == null) {
                return;
            }
            Object tagObject = this.platform.getItemUtils().getTag(craft);
            if (tagObject == null) {
                return;
            }
            this.removeMeta(tagObject, tag);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void parseAndSet(Object node, String tag, String value) {
        if (value == null) {
            this.removeMeta(node, tag);
            return;
        }
        boolean isTrue = value.equals("true");
        boolean isFalse = value.equals("false");
        if (isTrue || isFalse) {
            this.setBoolean(node, tag, isTrue);
        } else {
            try {
                Integer i = Integer.parseInt(value);
                this.setInt(node, tag, (int)i);
            }
            catch (Exception ex) {
                try {
                    Double d = Double.parseDouble(value);
                    this.setDouble(node, tag, d);
                }
                catch (Exception ex2) {
                    this.setString(node, tag, value);
                }
            }
        }
    }

    @Override
    public void setBoolean(ItemStack stack, String tag, boolean value) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return;
        }
        try {
            Object craft = this.platform.getItemUtils().getHandle(stack);
            if (craft == null) {
                return;
            }
            Object tagObject = this.platform.getItemUtils().getOrCreateTag(craft);
            if (tagObject == null) {
                return;
            }
            this.setBoolean(tagObject, tag, value);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean getBoolean(ItemStack stack, String tag, boolean defaultValue) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return defaultValue;
        }
        boolean result = defaultValue;
        try {
            Object tagObject = this.platform.getItemUtils().getTag(stack);
            if (tagObject == null) {
                return defaultValue;
            }
            Boolean value = this.getOptionalBoolean(tagObject, tag);
            result = value == null ? defaultValue : value;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Override
    public boolean setSpawnEggEntityData(ItemStack spawnEgg, Entity entity, Object entityData) {
        return this.setTag(spawnEgg, "EntityTag", entityData);
    }

    @Override
    public boolean saveTagsToItem(ConfigurationSection tags, ItemStack item) {
        Object handle = this.platform.getItemUtils().getHandle(item);
        if (handle == null) {
            return false;
        }
        Object tag = this.platform.getItemUtils().getOrCreateTag(handle);
        if (tag == null) {
            return false;
        }
        return this.addTagsToNBT(ConfigUtils.toMap(tags), tag);
    }

    @Override
    public boolean saveTagsToNBT(ConfigurationSection tags, Object node) {
        return this.saveTagsToNBT(tags, node, null);
    }

    @Override
    public boolean saveTagsToNBT(ConfigurationSection tags, Object node, Set<String> tagNames) {
        return this.saveTagsToNBT(ConfigUtils.toMap(tags), node, tagNames);
    }

    @Override
    public void convertIntegers(Map<String, Object> m) {
        for (Map.Entry<String, Object> entry : m.entrySet()) {
            Object value = entry.getValue();
            if (value != null && value instanceof Double) {
                double d = (Double)value;
                if (d != (double)((int)d)) continue;
                entry.setValue((int)d);
                continue;
            }
            if (value != null && value instanceof Float) {
                float f = ((Float)value).floatValue();
                if (f != (float)((int)f)) continue;
                entry.setValue((int)f);
                continue;
            }
            if (value == null || !(value instanceof Map)) continue;
            Map map = (Map)value;
            this.convertIntegers(map);
        }
    }

    protected byte[] makeByteArray(List<Object> list) {
        byte[] a2 = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Byte b = (Byte)list.get(i);
            a2[i] = b == null ? (byte)0 : b;
        }
        return a2;
    }

    protected int[] makeIntArray(List<Object> list) {
        int[] a2 = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Integer value = (Integer)list.get(i);
            a2[i] = value == null ? 0 : value;
        }
        return a2;
    }

    protected long[] makeLongArray(List<Object> list) {
        long[] a2 = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Long l = (Long)list.get(i);
            a2[i] = l == null ? 0L : l;
        }
        return a2;
    }

    protected Long convertToLong(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Integer) {
            return (long)((Integer)o);
        }
        if (o instanceof Byte) {
            return (long)((Byte)o);
        }
        if (o instanceof Double) {
            return (long)((Double)o).doubleValue();
        }
        if (o instanceof String) {
            return Long.parseLong((String)o);
        }
        return null;
    }

    protected Integer convertToInteger(Object o) {
        Long intVal = this.convertToLong(o);
        return intVal == null ? null : Integer.valueOf((int)intVal.longValue());
    }

    protected Byte convertToByte(Object o) {
        Long intVal = this.convertToLong(o);
        return intVal == null ? null : Byte.valueOf((byte)intVal.longValue());
    }

    protected Short convertToShort(Object o) {
        Long intVal = this.convertToLong(o);
        return intVal == null ? null : Short.valueOf((short)intVal.longValue());
    }

    protected Double convertToDouble(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Integer) {
            return (double)((Integer)o);
        }
        if (o instanceof Long) {
            return (double)((Long)o);
        }
        if (o instanceof Byte) {
            return (double)((Byte)o);
        }
        if (o instanceof String) {
            return Double.parseDouble((String)o);
        }
        return null;
    }
}

