/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BlockSpell;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.FallingBlock;
import org.bukkit.inventory.ItemStack;

@Deprecated
public class DropSpell
extends BlockSpell {
    private static final int DEFAULT_MAX_RECURSION = 16;
    private int dropCount;
    private boolean falling = true;
    private boolean diagonals = false;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Block target = this.getTargetBlock();
        if (target == null) {
            return SpellResult.NO_TARGET;
        }
        MaterialSet dropMaterials = this.controller.getMaterialSetManager().fromConfigEmpty(parameters.getString("drop"));
        if (!dropMaterials.testBlock(target)) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBreakPermission(target)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        int maxRecursion = parameters.getInt("recursion_depth", 16);
        this.dropCount = parameters.getInt("drop_count", -1);
        this.falling = parameters.getBoolean("falling", true);
        this.diagonals = parameters.getBoolean("diagonals", true);
        this.drop(target, dropMaterials, drops, maxRecursion);
        for (ItemStack drop : drops) {
            target.getWorld().dropItemNaturally(target.getLocation(), drop);
        }
        this.registerForUndo();
        return SpellResult.CAST;
    }

    protected void drop(Block block, MaterialSet dropTypes, Collection<ItemStack> drops, int maxRecursion) {
        this.drop(block, dropTypes, drops, maxRecursion, 0);
    }

    protected void drop(Block block, MaterialSet dropTypes, Collection<ItemStack> drops, int maxRecursion, int rDepth) {
        this.registerForUndo(block);
        if (this.dropCount < 0 || drops.size() < this.dropCount) {
            drops.addAll(block.getDrops());
        } else if (this.falling) {
            Location blockLocation = block.getLocation();
            FallingBlock falling = block.getWorld().spawnFallingBlock(blockLocation, block.getBlockData());
            falling.setDropItem(false);
        }
        block.setType(Material.AIR);
        if (rDepth < maxRecursion) {
            this.tryDrop(block.getRelative(BlockFace.NORTH), dropTypes, drops, maxRecursion, rDepth + 1);
            this.tryDrop(block.getRelative(BlockFace.WEST), dropTypes, drops, maxRecursion, rDepth + 1);
            this.tryDrop(block.getRelative(BlockFace.SOUTH), dropTypes, drops, maxRecursion, rDepth + 1);
            this.tryDrop(block.getRelative(BlockFace.EAST), dropTypes, drops, maxRecursion, rDepth + 1);
            this.tryDrop(block.getRelative(BlockFace.UP), dropTypes, drops, maxRecursion, rDepth + 1);
            this.tryDrop(block.getRelative(BlockFace.DOWN), dropTypes, drops, maxRecursion, rDepth + 1);
            if (this.diagonals) {
                this.tryDrop(block.getRelative(BlockFace.NORTH_EAST), dropTypes, drops, maxRecursion, rDepth + 1);
                this.tryDrop(block.getRelative(BlockFace.NORTH_WEST), dropTypes, drops, maxRecursion, rDepth + 1);
                this.tryDrop(block.getRelative(BlockFace.SOUTH_EAST), dropTypes, drops, maxRecursion, rDepth + 1);
                this.tryDrop(block.getRelative(BlockFace.SOUTH_WEST), dropTypes, drops, maxRecursion, rDepth + 1);
                Block up = block.getRelative(BlockFace.UP);
                this.tryDrop(up.getRelative(BlockFace.NORTH_EAST), dropTypes, drops, maxRecursion, rDepth + 1);
                this.tryDrop(up.getRelative(BlockFace.NORTH_WEST), dropTypes, drops, maxRecursion, rDepth + 1);
                this.tryDrop(up.getRelative(BlockFace.SOUTH_EAST), dropTypes, drops, maxRecursion, rDepth + 1);
                this.tryDrop(up.getRelative(BlockFace.SOUTH_WEST), dropTypes, drops, maxRecursion, rDepth + 1);
                this.tryDrop(up.getRelative(BlockFace.NORTH), dropTypes, drops, maxRecursion, rDepth + 1);
                this.tryDrop(up.getRelative(BlockFace.WEST), dropTypes, drops, maxRecursion, rDepth + 1);
                this.tryDrop(up.getRelative(BlockFace.SOUTH), dropTypes, drops, maxRecursion, rDepth + 1);
                this.tryDrop(up.getRelative(BlockFace.EAST), dropTypes, drops, maxRecursion, rDepth + 1);
                Block down = block.getRelative(BlockFace.DOWN);
                this.tryDrop(down.getRelative(BlockFace.NORTH_EAST), dropTypes, drops, maxRecursion, rDepth + 1);
                this.tryDrop(down.getRelative(BlockFace.NORTH_WEST), dropTypes, drops, maxRecursion, rDepth + 1);
                this.tryDrop(down.getRelative(BlockFace.SOUTH_EAST), dropTypes, drops, maxRecursion, rDepth + 1);
                this.tryDrop(down.getRelative(BlockFace.SOUTH_WEST), dropTypes, drops, maxRecursion, rDepth + 1);
                this.tryDrop(down.getRelative(BlockFace.NORTH), dropTypes, drops, maxRecursion, rDepth + 1);
                this.tryDrop(down.getRelative(BlockFace.WEST), dropTypes, drops, maxRecursion, rDepth + 1);
                this.tryDrop(down.getRelative(BlockFace.SOUTH), dropTypes, drops, maxRecursion, rDepth + 1);
                this.tryDrop(down.getRelative(BlockFace.EAST), dropTypes, drops, maxRecursion, rDepth + 1);
            }
        }
    }

    protected void tryDrop(Block target, MaterialSet dropTypes, Collection<ItemStack> drops, int maxRecursion, int rDepth) {
        if (!dropTypes.testBlock(target) || this.contains(target)) {
            return;
        }
        this.drop(target, dropTypes, drops, maxRecursion, rDepth);
    }
}

