/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.slikey.effectlib.util;

import org.bukkit.Location;
import org.bukkit.util.Vector;

public final class VectorUtils {
    private VectorUtils() {
    }

    public static Vector rotateAroundAxisX(Vector vector, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double y = vector.getY() * cos - vector.getZ() * sin;
        double z = vector.getY() * sin + vector.getZ() * cos;
        return vector.setY(y).setZ(z);
    }

    public static Vector rotateAroundAxisY(Vector vector, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x = vector.getX() * cos + vector.getZ() * sin;
        double z = vector.getX() * -sin + vector.getZ() * cos;
        return vector.setX(x).setZ(z);
    }

    public static Vector rotateAroundAxisZ(Vector vector, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x = vector.getX() * cos - vector.getY() * sin;
        double y = vector.getX() * sin + vector.getY() * cos;
        return vector.setX(x).setY(y);
    }

    public static Vector rotateVector(Vector vector, double angleX, double angleY, double angleZ) {
        VectorUtils.rotateAroundAxisX(vector, angleX);
        VectorUtils.rotateAroundAxisY(vector, angleY);
        VectorUtils.rotateAroundAxisZ(vector, angleZ);
        return vector;
    }

    public static Vector rotateVector(Vector vector, Location location) {
        return VectorUtils.rotateVector(vector, location.getYaw(), location.getPitch());
    }

    public static Vector rotateVector(Vector vector, float yawDegrees, float pitchDegrees) {
        double yaw = Math.toRadians(-1.0f * (yawDegrees + 90.0f));
        double pitch = Math.toRadians(-pitchDegrees);
        double cosYaw = Math.cos(yaw);
        double cosPitch = Math.cos(pitch);
        double sinYaw = Math.sin(yaw);
        double sinPitch = Math.sin(pitch);
        double initialX = vector.getX();
        double initialY = vector.getY();
        double x = initialX * cosPitch - initialY * sinPitch;
        double y = initialX * sinPitch + initialY * cosPitch;
        double initialZ = vector.getZ();
        initialX = x;
        double z = initialZ * cosYaw - initialX * sinYaw;
        x = initialZ * sinYaw + initialX * cosYaw;
        return new Vector(x, y, z);
    }

    public static double angleToXAxis(Vector vector) {
        return Math.atan2(vector.getX(), vector.getY());
    }
}

