/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.entity.EntityData;
import com.elmakers.mine.bukkit.api.magic.Locatable;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.npc.MagicNPC;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.citizens.CitizensController;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.MagicMetaKeys;
import com.elmakers.mine.bukkit.magic.command.MagicTabExecutor;
import com.elmakers.mine.bukkit.magic.command.NPCSelectionManager;
import com.elmakers.mine.bukkit.utility.CompatibilityConstants;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.StringUtils;
import com.elmakers.mine.bukkit.utility.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class MagicNPCCommandExecutor
extends MagicTabExecutor {
    private final NPCSelectionManager selections;

    public MagicNPCCommandExecutor(MagicAPI api) {
        super(api, "mnpc");
        this.selections = new NPCSelectionManager((MagicController)api.getController());
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!this.api.hasPermission(sender, this.getPermissionNode())) {
            this.sendNoPermission(sender);
            return true;
        }
        if (args.length == 0) {
            return false;
        }
        String subCommand = args[0];
        if (subCommand.equalsIgnoreCase("import")) {
            this.onImportNPCs(sender);
            return true;
        }
        Object[] parameters = Arrays.copyOfRange(args, 1, args.length);
        if (subCommand.equalsIgnoreCase("list")) {
            this.onListNPCs(sender, (String[])parameters);
            return true;
        }
        Mage mage = this.controller.getMage(sender);
        if (subCommand.equalsIgnoreCase("add") || subCommand.equalsIgnoreCase("create")) {
            if (parameters.length == 0) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: mnpc add <name>");
                return true;
            }
            if (!mage.isPlayer()) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "This command may only be used in-game");
                return true;
            }
            this.onAddNPC(mage, StringUtils.join(parameters, " "));
            return true;
        }
        if (subCommand.equalsIgnoreCase("select")) {
            String targetName = null;
            if (parameters.length > 0) {
                targetName = StringUtils.join(parameters, " ");
            }
            this.onSelectNPC(mage, targetName);
            return true;
        }
        if (subCommand.equalsIgnoreCase("clean")) {
            this.onNPCClean(mage);
            return true;
        }
        MagicNPC npc = (MagicNPC)this.selections.getSelected(mage.getCommandSender());
        if (npc == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Select an NPC first using /mnpc select");
            return true;
        }
        if (subCommand.equalsIgnoreCase("template")) {
            if (parameters.length == 0) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: mnpc template <name>");
                return true;
            }
            this.onChangeNPCTemplate(mage, npc, StringUtils.join(parameters, " "));
            return true;
        }
        if (subCommand.equalsIgnoreCase("rename") || subCommand.equalsIgnoreCase("name")) {
            if (parameters.length == 0) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: mnpc rename <name>");
                return true;
            }
            this.onRenameNPC(mage, npc, StringUtils.join(parameters, " "));
            return true;
        }
        if (subCommand.equalsIgnoreCase("type")) {
            if (parameters.length == 0) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: mnpc type <mob type>");
                return true;
            }
            this.onChangeNPCType(mage, npc, StringUtils.join(parameters, " "));
            return true;
        }
        if (subCommand.equalsIgnoreCase("cast") || subCommand.equalsIgnoreCase("spell")) {
            this.onChangeNPCSpell(mage, npc, (String[])parameters);
            return true;
        }
        if (subCommand.equalsIgnoreCase("command")) {
            this.onChangeNPCCommand(mage, npc, (String[])parameters);
            return true;
        }
        if (subCommand.equalsIgnoreCase("tp")) {
            this.onTPNPC(mage, npc);
            return true;
        }
        if (subCommand.equalsIgnoreCase("move") || subCommand.equalsIgnoreCase("tphere")) {
            this.onMoveNPC(mage, npc);
            return true;
        }
        if (subCommand.equalsIgnoreCase("configure")) {
            this.onConfigureNPC(mage, npc, (String[])parameters);
            return true;
        }
        if (subCommand.equalsIgnoreCase("update")) {
            this.onUpdateNPC(mage, npc);
            return true;
        }
        if (subCommand.equalsIgnoreCase("costs")) {
            this.onNPCCost(mage, npc, (String[])parameters);
            return true;
        }
        if (subCommand.equalsIgnoreCase("describe") || subCommand.equalsIgnoreCase("desc")) {
            this.onDescribeNPC(mage, npc);
            return true;
        }
        if (subCommand.equalsIgnoreCase("player")) {
            if (parameters.length == 0) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: mnpc player <player name>");
                return true;
            }
            this.onPlayerNPC(mage, npc, (String)parameters[0]);
            return true;
        }
        if (subCommand.equalsIgnoreCase("remove") || subCommand.equalsIgnoreCase("delete")) {
            this.onRemoveNPC(mage, npc);
            return true;
        }
        if (subCommand.equalsIgnoreCase("dialog") || subCommand.equalsIgnoreCase("text")) {
            this.onNPCDialog(mage, npc);
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown subcommand: mnpc " + subCommand);
        return true;
    }

    protected void onImportNPCs(CommandSender sender) {
        MagicController magic = (MagicController)this.controller;
        CitizensController citizens = magic.getCitizensController();
        if (citizens == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Citizens is not installed");
            return;
        }
        citizens.importAll(magic, this.controller.getMage(sender));
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Finished importing! If everything looks OK now you can safely remove the Citizens plugin.");
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Until then, all of your NPCs will be doubled up");
    }

    protected List<MagicNPC> getNPCList() {
        Collection<MagicNPC> npcs = this.controller.getNPCs();
        if (npcs instanceof List) {
            return (List)npcs;
        }
        ArrayList<MagicNPC> list = new ArrayList<MagicNPC>(npcs);
        return list;
    }

    protected void onListNPCs(CommandSender sender, String[] args) {
        this.selections.list(sender, args);
    }

    protected void onAddNPC(Mage mage, String name) {
        MagicNPC npc = this.controller.addNPC(mage, name);
        this.selections.setSelection(mage.getCommandSender(), npc);
        mage.sendMessage(String.valueOf(ChatColor.GREEN) + "Created npc: " + String.valueOf(ChatColor.GOLD) + npc.getName());
    }

    protected void onChangeNPCTemplate(Mage mage, MagicNPC npc, String templateKey) {
        EntityData template = this.controller.getMob(templateKey);
        if (template == null) {
            mage.sendMessage(String.valueOf(ChatColor.RED) + "Unknown mob template: " + String.valueOf(ChatColor.YELLOW) + " templateKey");
            return;
        }
        if (!template.isNPC()) {
            mage.sendMessage(String.valueOf(ChatColor.YELLOW) + "Mob template " + String.valueOf(ChatColor.WHITE) + templateKey + String.valueOf(ChatColor.YELLOW) + " is not meant to be an NPC. Setting it anyway!");
        }
        if (npc.setTemplate(templateKey)) {
            mage.sendMessage(String.valueOf(ChatColor.GREEN) + "Changed template of npc " + String.valueOf(ChatColor.GOLD) + npc.getName() + String.valueOf(ChatColor.GREEN) + " to " + String.valueOf(ChatColor.YELLOW) + templateKey);
        } else {
            mage.sendMessage(String.valueOf(ChatColor.RED) + "Unknown mob type: " + String.valueOf(ChatColor.YELLOW) + templateKey);
        }
    }

    protected void onRenameNPC(Mage mage, MagicNPC npc, String name) {
        mage.sendMessage(String.valueOf(ChatColor.GREEN) + "Changed name of npc " + String.valueOf(ChatColor.GOLD) + npc.getName() + String.valueOf(ChatColor.GREEN) + " to " + String.valueOf(ChatColor.YELLOW) + name);
        npc.setName(name);
    }

    protected void onChangeNPCType(Mage mage, MagicNPC npc, String typeKey) {
        if (npc.setType(typeKey)) {
            mage.sendMessage(String.valueOf(ChatColor.GREEN) + "Changed type of npc " + String.valueOf(ChatColor.GOLD) + npc.getName() + String.valueOf(ChatColor.GREEN) + " to " + String.valueOf(ChatColor.YELLOW) + typeKey);
        } else {
            mage.sendMessage(String.valueOf(ChatColor.RED) + "Unknown mob type: " + String.valueOf(ChatColor.YELLOW) + typeKey);
        }
    }

    protected void onChangeNPCSpell(Mage mage, MagicNPC npc, String[] parameters) {
        ConfigurationSection currentParameters = npc.getParameters();
        if (parameters.length == 0) {
            String previousSpell = currentParameters.getString("interact_spell");
            if (previousSpell == null || previousSpell.isEmpty()) {
                mage.sendMessage(String.valueOf(ChatColor.DARK_AQUA) + "NPC has no spell set: " + String.valueOf(ChatColor.GOLD));
                return;
            }
            ConfigurationSection previousParameters = ConfigurationUtils.getConfigurationSection(currentParameters, "interact_spell_parameters");
            npc.configure("interact_spell", null);
            mage.sendMessage(String.valueOf(ChatColor.DARK_AQUA) + "Cleared spell cast for npc " + String.valueOf(ChatColor.GOLD));
            mage.sendMessage(String.valueOf(ChatColor.AQUA) + "Was: " + String.valueOf(ChatColor.WHITE) + previousSpell);
            if (previousParameters != null) {
                mage.sendMessage(CompatibilityLib.getInventoryUtils().describeProperty(previousParameters));
            }
        } else {
            currentParameters.set("interact_spell", (Object)parameters[0]);
            mage.sendMessage(String.valueOf(ChatColor.GREEN) + "Changed npc " + String.valueOf(ChatColor.GOLD) + npc.getName() + String.valueOf(ChatColor.GREEN) + " to cast " + String.valueOf(ChatColor.YELLOW) + parameters[0]);
            if (parameters.length > 1) {
                mage.sendMessage(String.valueOf(ChatColor.GREEN) + " With parameters:");
                ConfigurationSection spellParameters = ConfigurationUtils.newConfigurationSection();
                ConfigurationUtils.addParameters(Arrays.copyOfRange(parameters, 1, parameters.length), spellParameters);
                currentParameters.set("interact_spell_parameters", (Object)spellParameters);
                Set keys = spellParameters.getKeys(false);
                for (String key : keys) {
                    Object value = spellParameters.get(key);
                    mage.sendMessage(String.valueOf(ChatColor.DARK_AQUA) + key + String.valueOf(ChatColor.GRAY) + ": " + String.valueOf(ChatColor.WHITE) + CompatibilityLib.getInventoryUtils().describeProperty(value, CompatibilityConstants.MAX_PROPERTY_DISPLAY_LENGTH));
                }
            }
        }
        npc.update();
    }

    protected void onChangeNPCCommand(Mage mage, MagicNPC npc, String[] parameters) {
        ConfigurationSection currentParameters = npc.getParameters();
        if (parameters.length == 0) {
            String previousCommand = currentParameters.getString("interact_commands");
            if (previousCommand == null || previousCommand.isEmpty()) {
                mage.sendMessage(String.valueOf(ChatColor.DARK_AQUA) + "NPC has no commands set: " + String.valueOf(ChatColor.GOLD));
                return;
            }
            npc.configure("interact_commands", null);
            mage.sendMessage(String.valueOf(ChatColor.DARK_AQUA) + "Cleared commands for npc " + String.valueOf(ChatColor.GOLD));
            mage.sendMessage(String.valueOf(ChatColor.AQUA) + "Was: " + String.valueOf(ChatColor.WHITE) + previousCommand);
        } else {
            String command = parameters.length == 1 ? parameters[0] : StringUtils.join((Object[])Arrays.copyOfRange(parameters, 0, parameters.length), " ");
            currentParameters.set("interact_commands", (Object)command);
            mage.sendMessage(String.valueOf(ChatColor.GREEN) + "Changed npc " + String.valueOf(ChatColor.GOLD) + npc.getName() + String.valueOf(ChatColor.GREEN) + " commands to " + String.valueOf(ChatColor.YELLOW) + command);
        }
        npc.update();
    }

    @Nullable
    protected MagicNPC findNPC(@Nullable String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        List<MagicNPC> npcs = this.getNPCList();
        for (MagicNPC npc : npcs) {
            if (!npc.getName().equalsIgnoreCase(name)) continue;
            return npc;
        }
        try {
            int index = Integer.parseInt(name);
            if (index >= 0 && index < npcs.size()) {
                return npcs.get(index);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    protected void onNPCClean(Mage mage) {
        int removed = 0;
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                MagicNPC npc;
                String npcId = CompatibilityLib.getEntityMetadataUtils().getString(entity, MagicMetaKeys.NPC_ID);
                if (npcId == null || (npc = this.controller.getNPC(npcId)) != null && npc.isEntity(entity)) continue;
                Location location = entity.getLocation();
                mage.sendMessage(String.valueOf(ChatColor.YELLOW) + "Removing an invalid NPC entity of type " + String.valueOf(ChatColor.AQUA) + String.valueOf(entity.getType()) + String.valueOf(ChatColor.YELLOW) + " at " + TextUtils.printBlockLocation(location) + String.valueOf(ChatColor.YELLOW) + " in " + String.valueOf(ChatColor.DARK_AQUA) + location.getWorld().getName());
                entity.remove();
                ++removed;
            }
        }
        mage.sendMessage(String.valueOf(ChatColor.YELLOW) + "Removed " + String.valueOf(ChatColor.RED) + removed + String.valueOf(ChatColor.YELLOW) + " orphaned NPC entities");
    }

    protected void onSelectNPC(Mage mage, String name) {
        Locatable npc = null;
        List list = this.selections.getList(mage.getCommandSender());
        if (list != null && name != null && !name.isEmpty()) {
            try {
                int index = Integer.parseInt(name);
                if (index <= 0 || index > list.size()) {
                    mage.sendMessage(String.valueOf(ChatColor.RED) + "Index out of range: " + String.valueOf(ChatColor.WHITE) + name + String.valueOf(ChatColor.GRAY) + "/" + String.valueOf(ChatColor.WHITE) + list.size());
                    return;
                }
                npc = (MagicNPC)list.get(index - 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (npc == null) {
            npc = this.findNPC(name);
        }
        if (npc == null && mage.isPlayer()) {
            npc = this.selections.getTarget(mage.getCommandSender(), (List)null);
        }
        if (npc == null) {
            if (name == null || name.isEmpty()) {
                if (!mage.isPlayer()) {
                    mage.sendMessage(String.valueOf(ChatColor.RED) + "When using from console, must provide NPC name or index");
                } else {
                    mage.sendMessage(String.valueOf(ChatColor.RED) + "There is no NPC in front of you");
                }
            } else {
                mage.sendMessage(String.valueOf(ChatColor.RED) + "Could not find NPC: " + String.valueOf(ChatColor.GOLD) + name);
            }
        } else {
            this.selections.highlight((MagicNPC)npc);
            this.selections.setSelection(mage.getCommandSender(), npc);
            mage.sendMessage(String.valueOf(ChatColor.GRAY) + "Selected NPC: " + String.valueOf(ChatColor.GOLD) + npc.getName());
        }
    }

    protected void onRemoveNPC(Mage mage, MagicNPC npc) {
        this.controller.removeNPC(npc);
        this.selections.clearSelection(mage.getCommandSender());
        mage.sendMessage(String.valueOf(ChatColor.GREEN) + " Removed npc: " + String.valueOf(ChatColor.GOLD) + npc.getName());
    }

    protected void onNPCDialog(Mage mage, MagicNPC npc) {
        if (!mage.isPlayer()) {
            mage.sendMessage(String.valueOf(ChatColor.RED) + "This command may only be used in-game");
            return;
        }
        ItemStack item = mage.getPlayer().getInventory().getItemInMainHand();
        if (CompatibilityLib.getNBTUtils().containsTag(item, "npc")) {
            BookMeta meta = (BookMeta)item.getItemMeta();
            List pages = meta.getPages();
            boolean isEmpty = true;
            for (String page : pages) {
                if (page.trim().isEmpty()) continue;
                isEmpty = false;
                break;
            }
            if (isEmpty) {
                pages = null;
                mage.sendMessage(String.valueOf(ChatColor.GREEN) + "NPC dialog script cleared for " + String.valueOf(ChatColor.GOLD) + npc.getName());
            } else {
                mage.sendMessage(String.valueOf(ChatColor.GREEN) + "NPC dialog script set for " + String.valueOf(ChatColor.GOLD) + npc.getName());
            }
            String title = meta.getTitle();
            if (title != null && !title.isEmpty()) {
                title = title.replace("NPC Script: ", "");
                npc.setName(title);
            }
            npc.configure("dialog", pages);
            mage.getPlayer().getInventory().setItemInMainHand(new ItemStack(Material.AIR));
            return;
        }
        Material bookMaterial = DefaultMaterials.getWriteableBook();
        if (bookMaterial == null) {
            mage.sendMessage(String.valueOf(ChatColor.RED) + "Could not create writable book");
            return;
        }
        ItemStack book = new ItemStack(bookMaterial);
        BookMeta meta = (BookMeta)book.getItemMeta();
        meta.setTitle(npc.getName());
        meta.setAuthor(mage.getDisplayName());
        ArrayList<String> pages = npc.getParameters().getStringList("dialog");
        if (pages == null) {
            pages = new ArrayList<String>();
        }
        if (pages.isEmpty()) {
            pages.add("");
        }
        meta.setPages(pages);
        this.selections.highlight(npc);
        book.setItemMeta((ItemMeta)meta);
        book = CompatibilityLib.getItemUtils().makeReal(book);
        CompatibilityLib.getNBTUtils().setString(book, "npc", npc.getId().toString());
        mage.giveItem(book);
        mage.sendMessage(String.valueOf(ChatColor.GREEN) + "Edit the script book and use this command again while holding the book to set the NPC's chat dialog");
    }

    protected void onTPNPC(Mage mage, MagicNPC npc) {
        if (!mage.isPlayer()) {
            mage.sendMessage(String.valueOf(ChatColor.RED) + "This command may only be used in-game");
            return;
        }
        mage.getEntity().teleport(npc.getLocation());
    }

    protected void onMoveNPC(Mage mage, MagicNPC npc) {
        if (!mage.isPlayer()) {
            mage.sendMessage(String.valueOf(ChatColor.RED) + "This command may only be used in-game");
            return;
        }
        npc.teleport(mage.getEntity().getLocation());
    }

    protected void onDescribeNPC(Mage mage, MagicNPC npc) {
        npc.describe(mage.getCommandSender());
        this.selections.highlight(npc);
    }

    protected void onPlayerNPC(Mage mage, MagicNPC npc, String playerName) {
        if (!this.controller.hasDisguises()) {
            mage.sendMessage(String.valueOf(ChatColor.RED) + "Player NPCs require LibsDisguises");
            return;
        }
        ConfigurationSection parameters = npc.getParameters();
        ConfigurationSection disguise = parameters.createSection("disguise");
        disguise.set("skin", (Object)playerName);
        disguise.set("type", (Object)"player");
        npc.update();
    }

    protected void onNPCCost(Mage mage, MagicNPC npc, String[] parameters) {
        String costType;
        if (parameters.length == 0) {
            mage.sendMessage(String.valueOf(ChatColor.GREEN) + " Configured npc " + String.valueOf(ChatColor.GOLD) + npc.getName() + String.valueOf(ChatColor.GREEN) + ", cleared costs");
            npc.configure("interact_costs", null);
            return;
        }
        double value = 0.0;
        try {
            value = Double.parseDouble(parameters[0]);
        }
        catch (Exception ex) {
            mage.sendMessage(String.valueOf(ChatColor.RED) + "Invalid cost amount: " + parameters[0]);
            return;
        }
        String string = costType = parameters.length > 1 ? parameters[1] : "currency";
        if (this.controller.getCurrency(costType) == null) {
            mage.sendMessage(String.valueOf(ChatColor.RED) + "Invalid cost type: " + costType);
            return;
        }
        ConfigurationSection costSection = ConfigurationUtils.newConfigurationSection();
        costSection.set(costType, (Object)value);
        npc.configure("interact_costs", costSection);
        mage.sendMessage(String.valueOf(ChatColor.GREEN) + " Configured npc " + String.valueOf(ChatColor.GOLD) + npc.getName() + String.valueOf(ChatColor.GREEN) + " to cost " + String.valueOf(ChatColor.WHITE) + (int)value + String.valueOf(ChatColor.YELLOW) + " " + costType);
    }

    protected void onUpdateNPC(Mage mage, MagicNPC npc) {
        npc.update();
        this.selections.highlight(npc);
        mage.sendMessage("NPC Updated");
    }

    protected void onConfigureNPC(Mage mage, MagicNPC npc, String[] parameters) {
        if (parameters.length == 0 || parameters[0].isEmpty()) {
            mage.sendMessage(String.valueOf(ChatColor.RED) + "Missing parameter name");
            return;
        }
        String key = parameters[0];
        String value = null;
        if (parameters.length == 2) {
            value = parameters[1];
        } else if (parameters.length > 2) {
            value = StringUtils.join((Object[])Arrays.copyOfRange(parameters, 1, parameters.length), " ");
        }
        if (key.equals("spell") || key.equals("cast")) {
            key = "interact_spell";
        } else if (key.equals("command") || key.equals("commands")) {
            key = "interact_commands";
        } else if (key.equals("cast_source")) {
            key = "interact_spell_source";
        } else if (key.equals("cast_target")) {
            key = "interact_spell_target";
        } else if (key.equals("command_source")) {
            key = "interact_command_source";
        } else if (key.equals("permission")) {
            key = "interact_permission";
        }
        this.selections.highlight(npc);
        npc.configure(key, value);
        if (value == null) {
            mage.sendMessage(String.valueOf(ChatColor.GREEN) + " Configured npc " + String.valueOf(ChatColor.GOLD) + npc.getName() + String.valueOf(ChatColor.GREEN) + ", cleared " + String.valueOf(ChatColor.AQUA) + key);
        } else {
            mage.sendMessage(String.valueOf(ChatColor.GREEN) + " Configured npc " + String.valueOf(ChatColor.GOLD) + npc.getName() + String.valueOf(ChatColor.GREEN) + ", set " + String.valueOf(ChatColor.AQUA) + key + String.valueOf(ChatColor.GREEN) + " to " + String.valueOf(ChatColor.YELLOW) + value);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<String> onTabComplete(CommandSender sender, String commandName, String[] args) {
        ArrayList<String> options;
        block40: {
            block44: {
                block43: {
                    block42: {
                        block41: {
                            void var7_26;
                            block39: {
                                options = new ArrayList<String>();
                                if (!sender.hasPermission("magic.commands.mnpc")) {
                                    return options;
                                }
                                if (args.length != 1) break block39;
                                options.add("add");
                                options.add("configure");
                                options.add("command");
                                options.add("list");
                                options.add("name");
                                options.add("describe");
                                options.add("desc");
                                options.add("type");
                                options.add("remove");
                                options.add("tp");
                                options.add("move");
                                options.add("import");
                                options.add("select");
                                options.add("cast");
                                options.add("costs");
                                options.add("player");
                                options.add("dialog");
                                options.add("template");
                                options.add("clean");
                                break block40;
                            }
                            if (args.length != 2 || !args[0].equals("type")) break block41;
                            options.addAll(this.controller.getMobKeys());
                            EntityType[] entityTypeArray = EntityType.values();
                            int n = entityTypeArray.length;
                            boolean bl = false;
                            while (var7_26 < n) {
                                EntityType entityType = entityTypeArray[var7_26];
                                if (entityType.isAlive() && entityType.isSpawnable()) {
                                    options.add(entityType.name().toLowerCase());
                                }
                                ++var7_26;
                            }
                            break block40;
                        }
                        if (args.length != 2 || !args[0].equals("add") && !args[0].equals("template")) break block42;
                        options.addAll(this.controller.getNPCKeys());
                        break block40;
                    }
                    if (args.length != 2 || !args[0].equals("select")) break block43;
                    for (MagicNPC magicNPC : this.controller.getNPCs()) {
                        options.add(magicNPC.getName());
                    }
                    break block40;
                }
                if (args.length != 2 || !args[0].equals("configure")) break block44;
                options.add("ai");
                options.add("gravity");
                options.add("cast_source");
                options.add("command_source");
                options.add("cast_target");
                options.add("commands");
                options.add("permission");
                options.add("helmet");
                options.add("item");
                options.add("offhand");
                options.add("chestplate");
                options.add("boots");
                options.add("leggings");
                options.add("villager_profession");
                options.add("dialog_range");
                options.add("dialog_interval");
                options.add("dialog_random");
                options.add("leash_range");
                if (!this.controller.hasDisguises()) break block40;
                options.add("disguise.type");
                options.add("disguise.skin");
                break block40;
            }
            if (args.length == 3 && args[0].equals("configure") && args[1].equals("interact_spell") || args.length == 2 && args[0].equals("cast") || args.length == 2 && args[0].equals("spell")) {
                for (SpellTemplate spellTemplate : this.controller.getSpellTemplates(true)) {
                    options.add(spellTemplate.getKey());
                }
            } else if (args.length == 3 && args[0].equals("configure") && (args[1].equals("ai") || args[1].equals("gravity") || args[1].equals("interact_spell_caster") || args[1].equals("dialog_random"))) {
                options.add("true");
                options.add("false");
            } else if (args.length == 3 && args[0].equals("configure") && (args[1].equals("interact_spell_target") || args[1].equals("cast_target"))) {
                options.add("none");
                options.add("npc");
                options.add("player");
            } else if (args.length == 3 && args[0].equals("configure") && args[1].equals("villager_profession")) {
                void var7_28;
                Villager.Profession[] professionArray = Villager.Profession.values();
                int n = professionArray.length;
                boolean bl = false;
                while (var7_28 < n) {
                    Villager.Profession profession = professionArray[var7_28];
                    options.add(profession.name().toLowerCase());
                    ++var7_28;
                }
            } else if (args.length == 3 && args[0].equals("configure") && args[1].equals("disguise.type")) {
                void var7_30;
                EntityType[] entityTypeArray = EntityType.values();
                int n = entityTypeArray.length;
                boolean bl = false;
                while (var7_30 < n) {
                    EntityType entityType = entityTypeArray[var7_30];
                    options.add(entityType.name().toLowerCase());
                    ++var7_30;
                }
            } else if (args.length == 3 && args[0].equals("configure") && (args[1].equals("interact_spell_source") || args[1].equals("cast_source"))) {
                options.add("npc");
                options.add("player");
            } else if (args.length == 3 && args[0].equals("configure") && (args[1].equals("interact_command_source") || args[1].equals("command_source"))) {
                options.add("player");
                options.add("console");
                options.add("opped_player");
            } else if (args.length == 3 && args[0].equals("configure") && (args[1].equals("helmet") || args[1].equals("item") || args[1].equals("offhand") || args[1].equals("chestplate") || args[1].equals("boots") || args[1].equals("leggings"))) {
                Collection<SpellTemplate> spellList = this.api.getSpellTemplates(true);
                for (SpellTemplate spellTemplate : spellList) {
                    options.add(spellTemplate.getKey());
                }
                Collection<String> collection = this.api.getWandKeys();
                for (String wandKey : collection) {
                    options.add(wandKey);
                }
                for (Material material : Material.values()) {
                    options.add(material.name().toLowerCase());
                }
                Set<String> set = this.api.getController().getItemKeys();
                for (String itemKey : set) {
                    options.add(itemKey);
                }
            } else if (args.length == 2 && args[0].equals("player")) {
                for (Player player : this.controller.getPlugin().getServer().getOnlinePlayers()) {
                    options.add(player.getName());
                }
            } else if (args.length == 2 && (args[0].equals("costs") || args[0].equals("dialog_range"))) {
                options.add("1");
                options.add("10");
                options.add("100");
            } else if (args.length == 2 && args[0].equals("dialog_interval")) {
                options.add("1000");
                options.add("2000");
                options.add("5000");
            } else if (args.length == 3 && args[0].equals("costs")) {
                for (String string : this.controller.getCurrencyKeys()) {
                    options.add(string);
                }
                Collection<String> allWands = this.api.getWandKeys();
                for (String string : allWands) {
                    options.add(string);
                }
                for (Material material : Material.values()) {
                    options.add(material.name().toLowerCase());
                }
                Set<String> set = this.api.getController().getItemKeys();
                for (String itemKey : set) {
                    options.add(itemKey);
                }
            }
        }
        return options;
    }
}

