/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.block.BlockData;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.magic.MagicController;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPhysicsEvent;

public class PhysicsHandler
implements Listener {
    private final MagicController controller;
    private long timeout = 0L;
    private long timeoutBuffer = 2000L;

    public PhysicsHandler(MagicController controller) {
        this.controller = controller;
    }

    @EventHandler
    public void onBlockPhysics(BlockPhysicsEvent event) {
        if (!this.allowPhysics(event.getBlock())) {
            event.setCancelled(true);
        }
    }

    protected boolean allowPhysics(Block block) {
        if (this.timeout == 0L) {
            this.controller.unregisterPhysicsHandler(this);
            return true;
        }
        long now = System.currentTimeMillis();
        if (now > this.timeout) {
            this.controller.unregisterPhysicsHandler(this);
            this.timeout = 0L;
            return true;
        }
        BlockData registered = com.elmakers.mine.bukkit.block.UndoList.getBlockData(block.getLocation());
        if (registered == null) {
            return true;
        }
        UndoList registeredList = registered.getUndoList();
        if (registeredList != null && !registeredList.getApplyPhysics()) {
            this.timeout = Math.min(now + this.timeoutBuffer, this.timeout);
            return false;
        }
        return true;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setInterval(long interval) {
        this.timeout = Math.max(this.timeout, System.currentTimeMillis() + interval);
    }
}

