/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import java.lang.ref.WeakReference;
import java.util.List;
import org.bukkit.entity.Player;

public class MageConversation {
    private final Mage speaker;
    private final WeakReference<Player> targetPlayer;
    private final String formatString;
    private int nextLine;

    public MageConversation(Mage speaker, Player targetPlayer) {
        this.speaker = speaker;
        this.targetPlayer = new WeakReference<Player>(targetPlayer);
        this.formatString = speaker.getController().getMessages().get("npc.dialog");
    }

    public boolean sayNextLine(List<String> dialog) {
        Player target = (Player)this.targetPlayer.get();
        if (target == null || this.nextLine >= dialog.size()) {
            return true;
        }
        String configuredLines = dialog.get(this.nextLine);
        MageConversation.sayLine(target, configuredLines, this.speaker, this.formatString);
        ++this.nextLine;
        return this.nextLine >= dialog.size();
    }

    public static void sayLine(Player target, String configuredLines, Mage speaker) {
        String formatString = speaker.getController().getMessages().get("npc.dialog");
        MageConversation.sayLine(target, configuredLines, speaker, formatString);
    }

    public static void sayLine(Player target, String configuredLines, Mage speaker, String formatString) {
        if (!configuredLines.isEmpty()) {
            String[] lines;
            for (String line : lines = configuredLines.split("\n")) {
                String message = formatString.replace("$line", line);
                message = message.replace("$speaker", speaker.getDisplayName()).replace("$target", target.getDisplayName());
                target.sendMessage(CompatibilityLib.getCompatibilityUtils().translateColors(message));
            }
        }
    }
}

