/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.integration;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.integration.LibsDisguiseManager;
import com.elmakers.mine.bukkit.utility.random.RandomUtils;
import com.google.common.base.Verify;
import java.util.Deque;
import java.util.logging.Level;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MiscDisguise;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.ArmorStandWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.CreeperWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.VillagerWatcher;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ModernLibsDisguiseManager
implements LibsDisguiseManager {
    private final Plugin disguisePlugin;
    private final MageController controller;

    public ModernLibsDisguiseManager(MageController controller, Plugin disguisePlugin) {
        this.disguisePlugin = disguisePlugin;
        this.controller = controller;
    }

    @Override
    public boolean initialize() {
        return this.disguisePlugin != null && this.disguisePlugin instanceof LibsDisguises;
    }

    @Override
    public boolean isDisguised(Entity entity) {
        return DisguiseAPI.isDisguised((Entity)entity);
    }

    @Override
    public boolean disguise(Entity entity, ConfigurationSection configuration) {
        boolean hideItem;
        boolean hideArmor;
        boolean hearDisguise;
        if (configuration == null) {
            DisguiseAPI.undisguiseToAll((Entity)entity);
            return true;
        }
        String disguiseName = configuration.getString("type");
        if (disguiseName == null || disguiseName.isEmpty()) {
            return false;
        }
        Disguise disguise = DisguiseAPI.getCustomDisguise((String)disguiseName);
        if (disguise == null) {
            try {
                ItemStack offhand;
                ItemStack mainhand;
                ItemStack chestplate;
                ItemStack leggings;
                ItemStack boots;
                ItemStack helmet;
                DisguiseType disguiseType = DisguiseType.valueOf((String)disguiseName.toUpperCase());
                switch (disguiseType) {
                    case PLAYER: {
                        Deque skins = RandomUtils.createStringProbabilityMap(configuration, "skin");
                        String skin = (String)RandomUtils.weightedRandom(skins);
                        String name = configuration.getString("name", entity.getCustomName());
                        if (name == null || name.isEmpty()) {
                            name = skin;
                        }
                        if (name == null || name.isEmpty()) {
                            this.controller.getLogger().warning("Missing disguise name in player disguise");
                            return false;
                        }
                        PlayerDisguise playerDisguise = new PlayerDisguise(name);
                        if (skin != null) {
                            playerDisguise.setSkin(skin);
                        }
                        if (configuration.getBoolean("hide_name", false)) {
                            playerDisguise.setNameVisible(false);
                        }
                        disguise = playerDisguise;
                        break;
                    }
                    case ARMOR_STAND: {
                        disguise = new MobDisguise(DisguiseType.ARMOR_STAND);
                        ArmorStandWatcher watcher = (ArmorStandWatcher)disguise.getWatcher();
                        watcher.setMarker(configuration.getBoolean("marker", false));
                        watcher.setNoBasePlate(!configuration.getBoolean("baseplate", true));
                        watcher.setSmall(configuration.getBoolean("small", false));
                        watcher.setShowArms(configuration.getBoolean("arms", false));
                        break;
                    }
                    case FALLING_BLOCK: 
                    case DROPPED_ITEM: {
                        Material material = Material.valueOf((String)configuration.getString("material").toUpperCase());
                        MiscDisguise itemDisguise = new MiscDisguise(disguiseType, material, configuration.getInt("data"));
                        disguise = itemDisguise;
                        break;
                    }
                    case SPLASH_POTION: 
                    case PAINTING: {
                        MiscDisguise paintingDisguise = new MiscDisguise(disguiseType, configuration.getInt("data"));
                        disguise = paintingDisguise;
                        break;
                    }
                    case ARROW: 
                    case SPECTRAL_ARROW: 
                    case FIREBALL: 
                    case SMALL_FIREBALL: 
                    case DRAGON_FIREBALL: 
                    case WITHER_SKULL: 
                    case FISHING_HOOK: {
                        MiscDisguise miscDisguise = new MiscDisguise(disguiseType);
                        disguise = miscDisguise;
                        break;
                    }
                    case VILLAGER: {
                        disguise = new MobDisguise(DisguiseType.VILLAGER);
                        String professionName = configuration.getString("profession");
                        if (professionName == null || professionName.isEmpty()) break;
                        try {
                            Villager.Profession profession = Villager.Profession.valueOf((String)professionName.toUpperCase());
                            VillagerWatcher villager = (VillagerWatcher)disguise.getWatcher();
                            villager.setProfession(profession);
                        }
                        catch (Exception ex) {
                            this.controller.getLogger().warning("Invalid villager profession in disguise config: " + professionName);
                        }
                        break;
                    }
                    default: {
                        boolean isBaby = configuration.getBoolean("baby", false);
                        disguise = new MobDisguise(disguiseType, !isBaby);
                    }
                }
                FlagWatcher watcher = disguise.getWatcher();
                String customName = configuration.getString("custom_name");
                if (customName != null) {
                    watcher.setCustomName(customName);
                    watcher.setCustomNameVisible(configuration.getBoolean("custom_name_visible", true));
                }
                if ((helmet = this.controller.createItem(configuration.getString("helmet"))) != null) {
                    watcher.setHelmet(helmet);
                }
                if ((boots = this.controller.createItem(configuration.getString("boots"))) != null) {
                    watcher.setBoots(boots);
                }
                if ((leggings = this.controller.createItem(configuration.getString("leggings"))) != null) {
                    watcher.setLeggings(leggings);
                }
                if ((chestplate = this.controller.createItem(configuration.getString("chestplate"))) != null) {
                    watcher.setChestplate(chestplate);
                }
                if ((mainhand = this.controller.createItem(configuration.getString("mainhand"))) != null) {
                    watcher.setItemInMainHand(mainhand);
                }
                if ((offhand = this.controller.createItem(configuration.getString("offhand"))) != null) {
                    watcher.setItemInOffHand(offhand);
                }
                if (configuration.getBoolean("invisible", false)) {
                    watcher.setInvisible(true);
                }
                if (configuration.getBoolean("burning", false)) {
                    watcher.setBurning(true);
                }
                if (configuration.getBoolean("glowing", false)) {
                    watcher.setGlowing(true);
                }
                if (configuration.getBoolean("flying", false)) {
                    watcher.setFlyingWithElytra(true);
                }
                if (configuration.getBoolean("sneaking", false)) {
                    watcher.setSneaking(true);
                }
                if (configuration.getBoolean("animations", false)) {
                    watcher.setAddEntityAnimations(true);
                }
                if (configuration.getBoolean("sprinting", false)) {
                    watcher.setSprinting(true);
                }
                if (configuration.getBoolean("swimming", false)) {
                    watcher.setSwimming(true);
                }
                if (configuration.getBoolean("right_clicking", false)) {
                    watcher.setRightClicking(true);
                }
                if (configuration.contains("burning")) {
                    watcher.setBurning(configuration.getBoolean("burning"));
                }
                if (watcher instanceof CreeperWatcher) {
                    CreeperWatcher creeper = (CreeperWatcher)watcher;
                    creeper.setPowered(configuration.getBoolean("powered", false));
                    creeper.setIgnited(configuration.getBoolean("ignited", false));
                }
            }
            catch (Exception ex) {
                this.controller.getLogger().log(Level.WARNING, "Error creating disguise", ex);
                return false;
            }
        }
        Verify.verifyNotNull((Object)disguise);
        boolean selfDisguise = configuration.getBoolean("self", true);
        if (!selfDisguise) {
            disguise.setSelfDisguiseVisible(selfDisguise);
        }
        if (!(hearDisguise = configuration.getBoolean("hear", true))) {
            disguise.setHearSelfDisguise(hearDisguise);
        }
        if (hideArmor = configuration.getBoolean("self_hide_armor", false)) {
            disguise.setHideArmorFromSelf(hideArmor);
        }
        if (hideItem = configuration.getBoolean("self_hide_item", false)) {
            disguise.setHideHeldItemFromSelf(hideItem);
        }
        try {
            DisguiseAPI.disguiseEntity((Entity)entity, (Disguise)disguise);
            return true;
        }
        catch (Exception ex) {
            this.controller.getLogger().log(Level.WARNING, "Error applying disguise", ex);
            return false;
        }
    }
}

