/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.configuration;

import com.elmakers.mine.bukkit.configuration.ParameterizedConfigurationSection;
import com.elmakers.mine.bukkit.slikey.effectlib.math.EquationStore;
import com.elmakers.mine.bukkit.slikey.effectlib.math.EquationTransform;
import com.elmakers.mine.bukkit.slikey.effectlib.math.EquationVariableProvider;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationOptions;
import org.bukkit.configuration.ConfigurationSection;

public abstract class ParameterizedConfiguration
extends ParameterizedConfigurationSection
implements Configuration,
EquationVariableProvider {
    private static String PLACEHOLDER_PATTERN_STRING = "%([a-zA-Z0-9_]+)%";
    private static Pattern PLACEHOLDER_PATTERN = Pattern.compile(PLACEHOLDER_PATTERN_STRING);
    private Options options;
    private String context;
    private String contextField;
    private Set<String> workingParameters;

    protected ParameterizedConfiguration(String context) {
        this.context = context;
    }

    protected ParameterizedConfiguration(ParameterizedConfiguration copy) {
        this(copy.context);
    }

    @Nullable
    public ConfigurationSection getParent() {
        return null;
    }

    public void addDefaults(Map<String, Object> map) {
    }

    public void addDefaults(Configuration configuration) {
    }

    public void setDefaults(Configuration configuration) {
    }

    @Nullable
    public Configuration getDefaults() {
        return null;
    }

    public ConfigurationOptions options() {
        if (this.options == null) {
            this.options = new Options(this);
        }
        return this.options;
    }

    protected String parsePlaceholders(String expression) {
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(expression);
        if (!matcher.matches()) {
            return expression;
        }
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "0");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    @Nullable
    protected Double evaluate(String expression, String field) {
        this.contextField = field;
        Double result = this.evaluate(expression);
        this.contextField = null;
        return result;
    }

    @Nullable
    protected Double evaluate(String expression) {
        if (expression.equals("Optional[1]")) {
            expression = "1";
        } else if (expression.equals("Optional[0]")) {
            expression = "0";
        }
        this.workingParameters = this.getParameters();
        if (this.workingParameters == null || this.workingParameters.isEmpty()) {
            return null;
        }
        expression = expression.replace("$", "");
        expression = this.parsePlaceholders(expression);
        EquationTransform transform = EquationStore.getInstance().getTransform(expression, this.workingParameters);
        transform.setVariableProvider(this);
        double value = transform.get();
        transform.setVariableProvider(null);
        Exception ex = transform.getException();
        if (ex != null) {
            Object thisContext;
            Object object = thisContext = this.context == null ? "unknown" : this.context;
            if (this.contextField != null) {
                thisContext = (String)thisContext + "." + this.contextField;
            }
            ParameterizedConfiguration.warn("Error evaluating transform in " + (String)thisContext + ": '" + expression + "': " + ex.getMessage());
        }
        return Double.isNaN(value) || Double.isInfinite(value) ? 0.0 : value;
    }

    @Override
    @Nullable
    public Double getVariable(String variable) {
        return this.workingParameters != null && this.workingParameters.contains(variable) ? Double.valueOf(this.getParameter(variable)) : null;
    }

    protected abstract Set<String> getParameters();

    protected abstract double getParameter(String var1);

    private static class Options
    extends ConfigurationOptions {
        protected Options(Configuration configuration) {
            super(configuration);
        }
    }
}

