/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.api.block.Schematic;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.entity.EntityData;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.bukkit.Art;
import org.bukkit.Location;
import org.bukkit.Rotation;
import org.bukkit.block.BlockFace;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;

public abstract class AbstractSchematic
implements Schematic {
    private final MageController controller;
    protected volatile boolean loaded = false;
    protected Vector size;
    protected Vector center;
    protected MaterialAndData[][][] blocks;
    protected Collection<com.elmakers.mine.bukkit.api.entity.EntityData> entities;
    protected Map<BlockVector, Object> tileEntities;

    protected AbstractSchematic(MageController controller) {
        this.controller = controller;
    }

    protected void initialize(short width, short height, short length) {
        this.size = new Vector((int)width, (int)height, (int)length);
        this.center = new Vector(Math.floor(this.size.getBlockX() / 2), 0.0, Math.floor(this.size.getBlockZ() / 2));
        this.blocks = new MaterialAndData[width][height][length];
        this.entities = new ArrayList<com.elmakers.mine.bukkit.api.entity.EntityData>();
    }

    protected void loadTileEntities(Collection<Object> tileEntityData) {
        if (tileEntityData == null || tileEntityData.isEmpty()) {
            return;
        }
        this.tileEntities = new HashMap<BlockVector, Object>();
        for (Object tileEntity : tileEntityData) {
            try {
                Integer x = CompatibilityLib.getNBTUtils().getOptionalInt(tileEntity, "x");
                Integer y = CompatibilityLib.getNBTUtils().getOptionalInt(tileEntity, "y");
                Integer z = CompatibilityLib.getNBTUtils().getOptionalInt(tileEntity, "z");
                if (x == null || y == null || z == null) continue;
                BlockVector location = new BlockVector(x.intValue(), y.intValue(), z.intValue());
                this.tileEntities.put(location, tileEntity);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void addTileEntity(BlockVector blockLocation, MaterialAndData block) {
        this.addTileEntity(blockLocation, block, false);
    }

    protected MaterialAndData addTileEntity(BlockVector blockLocation, MaterialAndData block, boolean copy) {
        if (this.tileEntities == null) {
            return block;
        }
        Object tileEntity = this.tileEntities.get(blockLocation);
        if (tileEntity != null) {
            if (copy) {
                block = new MaterialAndData(block);
            }
            try {
                if (DefaultMaterials.isCommand(block.getMaterial())) {
                    String customName = CompatibilityLib.getNBTUtils().getString(tileEntity, "CustomName");
                    if (!customName.isEmpty()) {
                        block.setCustomName(customName);
                    }
                    block.setCommandLine(CompatibilityLib.getNBTUtils().getString(tileEntity, "Command"));
                } else {
                    block.setRawData(tileEntity);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return block;
    }

    protected void loadEntities(Collection<Object> entityData, Vector origin) {
        if (entityData == null || entityData.isEmpty()) {
            return;
        }
        for (Object entity : entityData) {
            Vector position;
            String type = CompatibilityLib.getNBTUtils().getString(entity, "id");
            if (type == null || type.isEmpty()) {
                type = CompatibilityLib.getNBTUtils().getString(entity, "Id");
            }
            if ((position = CompatibilityLib.getCompatibilityUtils().getPosition(entity, "Pos")) == null) continue;
            position = position.subtract(origin).subtract(this.center);
            if (type == null || type.isEmpty()) continue;
            if ((type = type.replace("minecraft:", "")).equalsIgnoreCase("Painting")) {
                String motive = CompatibilityLib.getNBTUtils().getString(entity, "Motive");
                motive = motive.replace("minecraft:", "");
                motive = motive.replace("_", "");
                motive = motive.toLowerCase();
                Art art = Art.ALBAN;
                for (Art test : Art.values()) {
                    if (!test.name().toLowerCase().replace("_", "").equals(motive)) continue;
                    art = test;
                    break;
                }
                byte facingData = CompatibilityLib.getNBTUtils().getOptionalByte(entity, "Facing");
                BlockFace facing = this.getFacing(facingData);
                EntityData painting = EntityData.loadPainting(this.controller, position, art, facing);
                this.entities.add(painting);
                continue;
            }
            if (!type.equalsIgnoreCase("ItemFrame")) continue;
            byte facing = CompatibilityLib.getNBTUtils().getOptionalByte(entity, "Facing");
            byte rotation = CompatibilityLib.getNBTUtils().getOptionalByte(entity, "ItemRotation");
            Rotation rot = Rotation.NONE;
            if (rotation < Rotation.values().length) {
                rot = Rotation.values()[rotation];
            }
            ItemStack item = CompatibilityLib.getItemUtils().getItem(CompatibilityLib.getNBTUtils().getTag(entity, "Item"));
            EntityData itemFrame = EntityData.loadItemFrame(this.controller, position, item, this.getFacing(facing), rot);
            this.entities.add(itemFrame);
        }
    }

    @Override
    public boolean contains(Vector v) {
        int x = v.getBlockX() + this.center.getBlockX();
        int y = v.getBlockY() + this.center.getBlockY();
        int z = v.getBlockZ() + this.center.getBlockZ();
        return x >= 0 && x <= this.size.getBlockX() && y >= 0 && y <= this.size.getBlockY() && z >= 0 && z <= this.size.getBlockZ();
    }

    @Override
    @Nullable
    public MaterialAndData getBlock(Vector v) {
        int x = v.getBlockX() + this.center.getBlockX();
        int y = v.getBlockY() + this.center.getBlockY();
        int z = v.getBlockZ() + this.center.getBlockZ();
        if (x < 0 || x >= this.blocks.length || y < 0 || y >= this.blocks[x].length || z < 0 || z >= this.blocks[x][y].length) {
            return null;
        }
        return this.blocks[x][y][z];
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.entity.EntityData> getEntities(Location center) {
        ArrayList<com.elmakers.mine.bukkit.api.entity.EntityData> translated = new ArrayList<com.elmakers.mine.bukkit.api.entity.EntityData>();
        for (com.elmakers.mine.bukkit.api.entity.EntityData data : this.entities) {
            com.elmakers.mine.bukkit.api.entity.EntityData relative = data == null ? null : data.getRelativeTo(center);
            if (relative == null) continue;
            translated.add(relative);
        }
        return translated;
    }

    @Override
    public Vector getSize() {
        return this.size;
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    protected BlockFace getFacing(byte dir) {
        switch (dir) {
            case 0: {
                return BlockFace.SOUTH;
            }
            case 1: {
                return BlockFace.WEST;
            }
            case 2: {
                return BlockFace.NORTH;
            }
            case 3: {
                return BlockFace.EAST;
            }
        }
        return BlockFace.UP;
    }
}

