/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseTeleportAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class WarpAction
extends BaseTeleportAction {
    private String warpKey;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.warpKey = parameters.getString("warp");
    }

    @Override
    public SpellResult perform(CastContext context) {
        if (this.warpKey == null || this.warpKey.isEmpty()) {
            context.getLogger().warning("Warp action missing 'warp' parameter");
            return SpellResult.FAIL;
        }
        Entity entity = context.getTargetEntity();
        if (entity == null) {
            return SpellResult.ENTITY_REQUIRED;
        }
        Location targetLocation = context.getController().getWarp(this.warpKey);
        if (targetLocation == null) {
            context.getLogger().warning("Unknown warp: " + this.warpKey);
            return SpellResult.NO_TARGET;
        }
        return this.teleport(context, entity, targetLocation);
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    @Override
    public boolean requiresTargetEntity() {
        return true;
    }
}

