/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.slikey.effectlib.util.MathUtils;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.SafetyUtils;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class VelocityAction
extends BaseSpellAction {
    private double livingEntitySpeed;
    private double itemSpeed;
    private double defaultSpeed;
    private double minSpeed;
    private double maxSpeed;
    private int maxSpeedAtElevation;
    private double pushDirection;
    private double yOffset;
    private int exemptionDuration;
    private double maxMagnitude;
    private double maxMagnitudeSquared;
    private boolean additive;
    private Vector direction;
    private boolean registerDamaged;
    private double maxDistanceSquared;
    private boolean invertDistance;
    private boolean allowMaxHeight;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.defaultSpeed = parameters.getDouble("speed", 1.0);
        this.livingEntitySpeed = parameters.getDouble("living_entity_speed", this.defaultSpeed);
        this.itemSpeed = parameters.getDouble("item_speed", this.defaultSpeed);
        this.maxSpeedAtElevation = parameters.getInt("max_altitude", 64);
        this.minSpeed = parameters.getDouble("min_speed", 0.0);
        this.maxSpeed = parameters.getDouble("max_speed", 0.0);
        this.pushDirection = parameters.getDouble("push", 0.0);
        this.yOffset = parameters.getDouble("y_offset", 0.0);
        this.direction = ConfigurationUtils.getVector(parameters, "direction");
        this.exemptionDuration = parameters.getInt("exemption_duration", (int)(this.maxSpeed * 2000.0));
        this.maxMagnitude = parameters.getDouble("max_magnitude", 0.0);
        this.maxMagnitudeSquared = this.maxMagnitude * this.maxMagnitude;
        this.additive = parameters.getBoolean("additive", false);
        this.registerDamaged = parameters.getBoolean("damaged", true);
        double maxDistance = parameters.getDouble("velocity_max_distance");
        this.maxDistanceSquared = maxDistance * maxDistance;
        this.invertDistance = parameters.getBoolean("invert_distance", false);
        this.allowMaxHeight = parameters.getBoolean("allow_max_height", true);
    }

    @Override
    public SpellResult perform(CastContext context) {
        Vector velocity;
        Entity entity = context.getTargetEntity();
        if (entity instanceof Hanging) {
            return SpellResult.NO_TARGET;
        }
        Entity mountEntity = entity.getVehicle();
        while (mountEntity != null) {
            entity = mountEntity;
            mountEntity = entity.getVehicle();
        }
        double magnitude = this.defaultSpeed;
        if (entity instanceof LivingEntity) {
            magnitude = this.livingEntitySpeed;
        } else if (entity instanceof Item) {
            magnitude = this.itemSpeed;
        }
        if (this.minSpeed > 0.0 || this.maxSpeed > 0.0) {
            int height;
            Block playerBlock = context.getLocation().getBlock();
            for (height = 0; height < this.maxSpeedAtElevation && DefaultMaterials.isAir(playerBlock.getType()); ++height) {
                playerBlock = playerBlock.getRelative(BlockFace.DOWN);
            }
            double heightModifier = this.maxSpeedAtElevation > 0 ? (double)height / (double)this.maxSpeedAtElevation : 1.0;
            magnitude = this.minSpeed + (this.maxSpeed - this.minSpeed) * heightModifier;
        }
        Vector vector = velocity = this.direction == null ? context.getDirection() : this.direction.clone();
        if (this.pushDirection != 0.0) {
            Location to = entity.getLocation();
            Location from = context.getLocation();
            Vector toVector = new Vector(to.getX(), to.getY(), to.getZ());
            Vector fromVector = new Vector(from.getX(), from.getY(), from.getZ());
            velocity = toVector;
            velocity.subtract(fromVector);
            double distanceSquared = velocity.lengthSquared();
            if (distanceSquared < Double.MIN_NORMAL) {
                velocity = context.getDirection();
            }
            double speed = this.pushDirection;
            if (this.maxDistanceSquared > 0.0) {
                if (distanceSquared > this.maxDistanceSquared) {
                    return SpellResult.NO_TARGET;
                }
                if (distanceSquared > 0.0) {
                    double ratio = distanceSquared / this.maxDistanceSquared;
                    if (!this.invertDistance) {
                        ratio = 1.0 - ratio;
                    }
                    speed *= ratio;
                }
            }
            velocity.normalize().multiply(speed);
        }
        if (!this.allowMaxHeight && context.getLocation().getBlockY() >= context.getController().getMaxHeight(context.getLocation().getWorld())) {
            velocity.setY(0);
        } else if (this.yOffset != 0.0) {
            velocity.setY(velocity.getY() + this.yOffset);
        }
        velocity.multiply(magnitude);
        if (this.additive) {
            velocity = entity.getVelocity().clone().add(velocity);
        }
        if (this.maxMagnitudeSquared != 0.0 && velocity.lengthSquared() > this.maxMagnitudeSquared) {
            velocity = velocity.normalize().multiply(this.maxMagnitude);
            magnitude = this.maxMagnitude;
        }
        if (this.registerDamaged) {
            context.registerDamaged(entity);
        }
        context.registerVelocity(entity);
        context.registerMoved(entity);
        if (this.exemptionDuration > 0 && entity instanceof Player) {
            context.getController().addFlightExemption((Player)entity, this.exemptionDuration);
        }
        context.getMage().sendDebugMessage(String.valueOf(ChatColor.AQUA) + "Applying velocity of " + String.valueOf(ChatColor.BLUE) + String.valueOf(velocity) + String.valueOf(ChatColor.AQUA) + " to " + String.valueOf(ChatColor.DARK_AQUA) + String.valueOf(entity.getType()) + String.valueOf(ChatColor.AQUA) + " from magnitude of " + String.valueOf(ChatColor.BLUE) + magnitude, 11);
        if (!(MathUtils.isFinite(velocity.getX()) && MathUtils.isFinite(velocity.getY()) && MathUtils.isFinite(velocity.getZ()))) {
            context.getMage().sendDebugMessage(String.valueOf(ChatColor.AQUA) + "Invalid velocity!" + String.valueOf(ChatColor.BLUE) + String.valueOf(velocity) + String.valueOf(ChatColor.AQUA) + "Context direction: " + String.valueOf(ChatColor.DARK_AQUA) + String.valueOf(context.getDirection()) + String.valueOf(ChatColor.AQUA) + "direction: " + String.valueOf(ChatColor.DARK_AQUA) + String.valueOf(this.direction));
        } else {
            SafetyUtils.setVelocity(entity, velocity);
        }
        return SpellResult.CAST;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("push");
        parameters.add("speed");
        parameters.add("living_entity_speed");
        parameters.add("item_speed");
        parameters.add("min_speed");
        parameters.add("max_speed");
        parameters.add("max_altitude");
        parameters.add("exemption_duration");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("push")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("speed") || parameterKey.equals("living_entity_speed") || parameterKey.equals("item_speed") || parameterKey.equals("min_speed") || parameterKey.equals("max_speed") || parameterKey.equals("max_altitude")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean requiresTargetEntity() {
        return true;
    }
}

