/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.protection;

import com.elmakers.mine.bukkit.protection.TownyManager;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TownyBridge {
    private final TownyAPI api;
    private final TownyManager controller;

    public TownyBridge(TownyManager manager, Plugin plugin) throws IllegalArgumentException {
        if (plugin == null) {
            throw new IllegalArgumentException("Towny integration attempt without Towny plugin instance");
        }
        this.controller = manager;
        this.api = TownyAPI.getInstance();
    }

    public boolean isPVPAllowed(Location location) {
        if (location == null) {
            return true;
        }
        if (this.controller.wildernessBypass && this.api.isWilderness(location)) {
            return true;
        }
        TownBlock townBlock = this.api.getTownBlock(location);
        if (townBlock == null) {
            return true;
        }
        if (townBlock.getType().equals((Object)TownBlockType.ARENA)) {
            return true;
        }
        if (townBlock.getWorld().isForcePVP()) {
            return true;
        }
        Town town = null;
        try {
            if (townBlock.hasTown()) {
                town = townBlock.getTown();
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        if (town == null) {
            return true;
        }
        return !town.isAdminDisabledPVP() && town.isPVP();
    }

    public boolean hasBuildPermission(Player player, Block block) {
        if (block != null && player != null) {
            if (this.controller.wildernessBypass && this.api.isWilderness(block.getLocation())) {
                return true;
            }
            return PlayerCacheUtil.getCachePermission((Player)player, (Location)block.getLocation(), (Material)block.getType(), (TownyPermission.ActionType)TownyPermission.ActionType.BUILD);
        }
        return true;
    }

    public boolean hasBreakPermission(Player player, Block block) {
        if (block != null && player != null) {
            if (this.controller.wildernessBypass && this.api.isWilderness(block.getLocation())) {
                return true;
            }
            return PlayerCacheUtil.getCachePermission((Player)player, (Location)block.getLocation(), (Material)block.getType(), (TownyPermission.ActionType)TownyPermission.ActionType.DESTROY);
        }
        return true;
    }

    public boolean canTarget(Entity entity, Entity target) {
        if (target != null && entity != null) {
            TownBlock defenderTB = TownyAPI.getInstance().getTownBlock(target.getLocation());
            TownBlock attackerTB = TownyAPI.getInstance().getTownBlock(entity.getLocation());
            TownyWorld townyWorld = TownyUniverse.getInstance().getWorld(target.getWorld().getName());
            if (townyWorld == null) {
                return true;
            }
            return !CombatUtil.preventPvP((TownyWorld)townyWorld, (TownBlock)attackerTB) || CombatUtil.preventPvP((TownyWorld)townyWorld, (TownBlock)defenderTB);
        }
        return true;
    }

    @Nullable
    protected Resident getResident(Player player) {
        try {
            return TownyUniverse.getInstance().getResident(player.getUniqueId());
        }
        catch (Exception ex) {
            if (!(ex instanceof TownyException)) {
                Bukkit.getLogger().log(Level.WARNING, "Error getting Towny Resident", ex);
            }
            return null;
        }
    }

    @Nullable
    public Location getTownLocation(Player player) {
        if (this.api == null || player == null) {
            return null;
        }
        Resident resident = this.getResident(player);
        if (resident == null) {
            return null;
        }
        Town town = null;
        try {
            town = resident.getTown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (town == null) {
            return null;
        }
        Location location = null;
        try {
            location = town.getSpawn();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return location;
    }

    public boolean createPlot(Location center, Double price) {
        WorldCoord worldCoord = new WorldCoord(center.getWorld().getName(), Coord.parseCoord((Location)center));
        try {
            TownBlock townBlock = worldCoord.getTownBlock();
            if (price == null) {
                price = worldCoord.getTownBlock().getTown().getPlotTypePrice(worldCoord.getTownBlock().getType());
            }
            townBlock.setPlotPrice(price.doubleValue());
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }
}

