/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.block.magic.MagicBlock;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.block.magic.MagicBlockTemplate;
import com.elmakers.mine.bukkit.block.magic.Nearby;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.command.MagicBlockSelectionManager;
import com.elmakers.mine.bukkit.magic.command.MagicTabExecutor;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.StringUtils;
import com.elmakers.mine.bukkit.utility.TextUtils;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class MagicBlockCommandExecutor
extends MagicTabExecutor {
    private final MagicController magicController;
    private final MagicBlockSelectionManager selections;
    private static final ImmutableSet<String> PROPERTY_KEYS = ImmutableSet.of((Object)"name", (Object)"interval", (Object)"effects", (Object)"spawn.mobs", (Object)"spawn.probability", (Object)"spawn.player_range", (Object[])new String[]{"spawn.min_players", "spawn.limit", "spawn.limit_range", "spawn.vertical_range", "spawn.radius", "spawn.vertical_radius", "spawn.retries", "min_players", "player_range", "min_time", "max_time", "min_moon_phase", "max_moon_phase", "moon_phase", "cast.spells", "cast.recast", "cast.undo_all", "spawn.count", "spawn.leash", "spawn.interval", "spawn.parameters", "spawn.check_radius", "spawn.check_floor", "spawn.vertical_check_radius", "portal_warp", "warp_maintain_direction", "portal_spell", "permission"});
    private static final ImmutableSet<String> IGNORE_PROPERTIES = ImmutableSet.of((Object)"name", (Object)"description");

    public MagicBlockCommandExecutor(MagicController controller) {
        super(controller.getAPI(), "mblock");
        this.selections = new MagicBlockSelectionManager(controller);
        this.magicController = controller;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player;
        if (!this.api.hasPermission(sender, this.getPermissionNode())) {
            this.sendNoPermission(sender);
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: mblock [add|select|remove|list|configure|describe|name]");
            return true;
        }
        String subCommand = args[0];
        args = Arrays.copyOfRange(args, 1, args.length);
        com.elmakers.mine.bukkit.block.magic.MagicBlock selection = (com.elmakers.mine.bukkit.block.magic.MagicBlock)this.selections.getSelected(sender);
        if (subCommand.equalsIgnoreCase("list")) {
            this.onListBlocks(sender, args);
            return true;
        }
        if (subCommand.equalsIgnoreCase("select")) {
            this.onSelectBlock(sender, args);
            return true;
        }
        if (subCommand.equalsIgnoreCase("remove")) {
            this.onRemoveBlock(sender, selection);
            return true;
        }
        if (subCommand.equalsIgnoreCase("debug")) {
            this.onDebugBlock(sender, selection, args);
            return true;
        }
        if (subCommand.equalsIgnoreCase("enable")) {
            this.onEnableBlock(sender, selection);
            return true;
        }
        if (subCommand.equalsIgnoreCase("disable")) {
            this.onDisableBlock(sender, selection);
            return true;
        }
        if (subCommand.equalsIgnoreCase("tp")) {
            this.onTeleportBlock(sender, selection);
            return true;
        }
        if (subCommand.equalsIgnoreCase("move") || subCommand.equalsIgnoreCase("tphere")) {
            this.onMoveBlock(sender, selection);
            return true;
        }
        if (subCommand.equalsIgnoreCase("describe") || subCommand.equalsIgnoreCase("desc")) {
            this.onDescribeBlock(sender, selection);
            return true;
        }
        if (subCommand.equalsIgnoreCase("configure")) {
            this.onConfigureBlock(sender, selection, args);
            return true;
        }
        if (subCommand.equalsIgnoreCase("name")) {
            this.onNameBlock(sender, selection, args);
            return true;
        }
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (player == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be used in-game");
            return true;
        }
        if (subCommand.equalsIgnoreCase("add")) {
            this.onMagicBlock(player, args);
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: mblock [add|select|remove|list|configure|describe]");
        return true;
    }

    private void onListBlocks(CommandSender sender, String[] args) {
        this.selections.list(sender, args);
    }

    private void onMagicBlock(Player player, String[] args) {
        if (args.length == 0) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: " + String.valueOf(ChatColor.WHITE) + "/mblock add <template>");
            return;
        }
        String key = args[0];
        if (!this.magicController.isMagicBlockTemplate(key)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid block template: " + String.valueOf(ChatColor.DARK_RED) + key);
            return;
        }
        Location location = player.getLocation();
        com.elmakers.mine.bukkit.block.magic.MagicBlock existing = this.magicController.getMagicBlockAt(location);
        if (existing != null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Magic Block already exists: " + String.valueOf(ChatColor.LIGHT_PURPLE) + existing.getName() + String.valueOf(ChatColor.RED) + " at " + TextUtils.printLocation(existing.getLocation(), 0));
            return;
        }
        ConfigurationSection parameters = null;
        if (args.length > 1) {
            String[] parameterArgs = Arrays.copyOfRange(args, 1, args.length);
            parameters = ConfigurationUtils.newConfigurationSection();
            ConfigurationUtils.addParameters(parameterArgs, parameters);
        }
        com.elmakers.mine.bukkit.block.magic.MagicBlock magicBlock = new com.elmakers.mine.bukkit.block.magic.MagicBlock(this.magicController, location, key, player.getUniqueId().toString(), player.getName(), parameters);
        this.magicController.registerMagicBlock(magicBlock);
        this.playEffects((CommandSender)player, magicBlock, "blockselect");
        this.selections.setSelection((CommandSender)player, magicBlock);
        player.sendMessage(String.valueOf(ChatColor.AQUA) + "Created Magic Block: " + String.valueOf(ChatColor.LIGHT_PURPLE) + magicBlock.getName() + String.valueOf(ChatColor.AQUA) + " at " + TextUtils.printLocation(magicBlock.getLocation(), 0));
    }

    private void playEffects(CommandSender sender, com.elmakers.mine.bukkit.block.magic.MagicBlock magicBlock, String effectsKey) {
        this.selections.playEffects(sender, magicBlock, effectsKey);
    }

    private void onRemoveBlock(CommandSender sender, com.elmakers.mine.bukkit.block.magic.MagicBlock magicBlock) {
        if (magicBlock == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "No magic block selected, use " + String.valueOf(ChatColor.WHITE) + "/mblock select");
            return;
        }
        if (!this.magicController.unregisterMagicBlock(magicBlock)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Could not find magic block at given position (something went wrong)");
            return;
        }
        Location location = magicBlock.getLocation();
        this.selections.clearSelection(sender);
        this.playEffects(sender, magicBlock, "blockremove");
        String rangeMessage = this.selections.getDistanceMessage(sender, magicBlock);
        String message = String.valueOf(ChatColor.YELLOW) + "Removed " + String.valueOf(ChatColor.LIGHT_PURPLE) + magicBlock.getName() + String.valueOf(ChatColor.YELLOW) + " at " + TextUtils.printLocation(location, 0);
        message = message + rangeMessage;
        sender.sendMessage(message);
    }

    private void onDebugBlock(CommandSender sender, com.elmakers.mine.bukkit.block.magic.MagicBlock magicBlock, String[] args) {
        if (magicBlock == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "No magic block selected, use " + String.valueOf(ChatColor.WHITE) + "/mblock select");
            return;
        }
        int level = 1;
        if (args.length > 0) {
            try {
                level = Integer.parseInt(args[0]);
            }
            catch (Exception ex) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Expected debug level, got: " + String.valueOf(ChatColor.WHITE) + args[0]);
                return;
            }
        }
        Mage mage = magicBlock.getMage();
        if (level == 0 || mage.getDebugLevel() > 0 && level == 1) {
            mage.setDebugLevel(0);
            mage.setDebugger(null);
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Disabling debug for " + String.valueOf(ChatColor.AQUA) + magicBlock.getName());
            return;
        }
        mage.setDebugLevel(level);
        mage.setDebugger(sender);
        Location location = magicBlock.getLocation();
        this.playEffects(sender, magicBlock, "blockdebug");
        String rangeMessage = this.selections.getDistanceMessage(sender, magicBlock);
        String message = String.valueOf(ChatColor.YELLOW) + "Debugging " + String.valueOf(ChatColor.LIGHT_PURPLE) + magicBlock.getName() + String.valueOf(ChatColor.YELLOW) + " at " + TextUtils.printLocation(location, 0);
        message = message + rangeMessage;
        sender.sendMessage(message);
    }

    private void onEnableBlock(CommandSender sender, com.elmakers.mine.bukkit.block.magic.MagicBlock magicBlock) {
        if (magicBlock == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "No magic block selected, use " + String.valueOf(ChatColor.WHITE) + "/mblock select");
            return;
        }
        if (magicBlock.isEnabled()) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Block is already enabled");
            return;
        }
        magicBlock.enable();
        Location location = magicBlock.getLocation();
        this.playEffects(sender, magicBlock, "blockselect");
        String rangeMessage = this.selections.getDistanceMessage(sender, magicBlock);
        String message = String.valueOf(ChatColor.YELLOW) + "Enabled " + String.valueOf(ChatColor.LIGHT_PURPLE) + magicBlock.getName() + String.valueOf(ChatColor.YELLOW) + " at " + TextUtils.printLocation(location, 0);
        message = message + rangeMessage;
        sender.sendMessage(message);
    }

    private void onDisableBlock(CommandSender sender, com.elmakers.mine.bukkit.block.magic.MagicBlock magicBlock) {
        if (magicBlock == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "No magic block selected, use " + String.valueOf(ChatColor.WHITE) + "/mblock select");
            return;
        }
        if (!magicBlock.isEnabled()) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Block is already disabled");
            return;
        }
        magicBlock.disable();
        Location location = magicBlock.getLocation();
        this.playEffects(sender, magicBlock, "blockremove");
        String rangeMessage = this.selections.getDistanceMessage(sender, magicBlock);
        String message = String.valueOf(ChatColor.YELLOW) + "Disabled " + String.valueOf(ChatColor.LIGHT_PURPLE) + magicBlock.getName() + String.valueOf(ChatColor.YELLOW) + " at " + TextUtils.printLocation(location, 0);
        message = message + rangeMessage;
        sender.sendMessage(message);
    }

    private void onTeleportBlock(CommandSender sender, com.elmakers.mine.bukkit.block.magic.MagicBlock magicBlock) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command may only be used in-game");
            return;
        }
        if (magicBlock == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "No magic block selected, use " + String.valueOf(ChatColor.WHITE) + "/mblock select");
            return;
        }
        Player player = (Player)sender;
        Location location = magicBlock.getLocation();
        player.teleport(magicBlock.getLocation());
        String message = String.valueOf(ChatColor.YELLOW) + "Teleported you to " + String.valueOf(ChatColor.LIGHT_PURPLE) + magicBlock.getName() + String.valueOf(ChatColor.YELLOW) + " at " + TextUtils.printLocation(location, 0);
        sender.sendMessage(message);
    }

    private void onMoveBlock(CommandSender sender, com.elmakers.mine.bukkit.block.magic.MagicBlock magicBlock) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command may only be used in-game");
            return;
        }
        if (magicBlock == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "No magic block selected, use " + String.valueOf(ChatColor.WHITE) + "/mblock select");
            return;
        }
        Player player = (Player)sender;
        Location location = player.getLocation();
        com.elmakers.mine.bukkit.block.magic.MagicBlock existing = this.magicController.getMagicBlockAt(location);
        if (existing != null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Magic Block already exists: " + String.valueOf(ChatColor.LIGHT_PURPLE) + existing.getName() + String.valueOf(ChatColor.RED) + " at " + TextUtils.printLocation(existing.getLocation(), 0));
            return;
        }
        this.magicController.moveMagicBlock(magicBlock, location);
        String message = String.valueOf(ChatColor.YELLOW) + "Moved " + String.valueOf(ChatColor.LIGHT_PURPLE) + magicBlock.getName() + String.valueOf(ChatColor.YELLOW) + " to " + TextUtils.printLocation(location, 0);
        sender.sendMessage(message);
    }

    private void onDescribeBlock(CommandSender sender, com.elmakers.mine.bukkit.block.magic.MagicBlock magicBlock) {
        String creatorName;
        String description;
        if (magicBlock == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "No magic block selected, use " + String.valueOf(ChatColor.WHITE) + "/mblock select");
            return;
        }
        Location location = magicBlock.getLocation();
        this.playEffects(sender, magicBlock, "blockselect");
        String message = String.valueOf(ChatColor.LIGHT_PURPLE) + magicBlock.getName() + String.valueOf(ChatColor.GREEN) + " at " + TextUtils.printLocation(location, 0) + this.selections.getDistanceMessage(sender, magicBlock);
        sender.sendMessage(message);
        String templateKey = magicBlock.getTemplateKey();
        if (!templateKey.isEmpty()) {
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "  " + templateKey);
        }
        if ((description = magicBlock.getDescription()) != null && !description.isEmpty()) {
            sender.sendMessage(String.valueOf(ChatColor.DARK_PURPLE) + String.valueOf(ChatColor.ITALIC) + description);
        }
        if (magicBlock.hasSpawner()) {
            Nearby nearby = magicBlock.getNearby();
            if (nearby != null) {
                int limit = magicBlock.getSpawnLimit();
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Has " + String.valueOf(ChatColor.GREEN) + nearby.mobs + String.valueOf(ChatColor.GRAY) + "/" + String.valueOf(ChatColor.DARK_GREEN) + limit + String.valueOf(ChatColor.GOLD) + " active mobs");
                int minPlayers = magicBlock.getSpawnMinPlayers();
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Has " + String.valueOf(ChatColor.GREEN) + nearby.players + String.valueOf(ChatColor.GRAY) + "/" + String.valueOf(ChatColor.DARK_GREEN) + minPlayers + String.valueOf(ChatColor.GOLD) + " nearby players");
            }
            long timeToNextSpawn = magicBlock.getTimeToNextSpawn();
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Time to next spawn: " + this.controller.getMessages().getTimeDescription(timeToNextSpawn, "description", "cooldown"));
        }
        if ((creatorName = magicBlock.getCreatorName()) != null && !creatorName.isEmpty()) {
            sender.sendMessage(String.valueOf(ChatColor.DARK_GREEN) + "  Created by: " + String.valueOf(ChatColor.GREEN) + creatorName);
        }
        ConfigurationSection parameters = magicBlock.getParameters();
        Set parameterKeys = null;
        if (parameters == null) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "(No Parameters)");
        } else {
            parameterKeys = parameters.getKeys(true);
            sender.sendMessage(String.valueOf(ChatColor.DARK_AQUA) + "Has " + String.valueOf(ChatColor.AQUA) + parameterKeys.size() + String.valueOf(ChatColor.DARK_AQUA) + " Parameters");
            for (String key : parameterKeys) {
                Object property;
                if (IGNORE_PROPERTIES.contains((Object)key) || (property = parameters.get(key)) instanceof ConfigurationSection) continue;
                sender.sendMessage(String.valueOf(ChatColor.AQUA) + key + String.valueOf(ChatColor.GRAY) + ": " + String.valueOf(ChatColor.DARK_AQUA) + CompatibilityLib.getInventoryUtils().describeProperty(property));
            }
        }
        MagicBlockTemplate template = magicBlock.getTemplate();
        if (template != null) {
            ConfigurationSection templateParameters = template.getConfiguration();
            Set keys = templateParameters.getKeys(true);
            for (String key : keys) {
                Object property;
                if (IGNORE_PROPERTIES.contains((Object)key) || parameterKeys != null && parameterKeys.contains(key) || (property = templateParameters.get(key)) instanceof ConfigurationSection) continue;
                sender.sendMessage(String.valueOf(ChatColor.GRAY) + key + String.valueOf(ChatColor.DARK_GRAY) + ": " + String.valueOf(ChatColor.DARK_AQUA) + CompatibilityLib.getInventoryUtils().describeProperty(property));
            }
        }
    }

    private void onNameBlock(CommandSender sender, com.elmakers.mine.bukkit.block.magic.MagicBlock magicBlock, String[] args) {
        if (magicBlock == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "No magic block selected, use " + String.valueOf(ChatColor.WHITE) + "/mblock select");
            return;
        }
        if (args.length == 0) {
            magicBlock.setName(null);
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Cleared custom name for " + String.valueOf(ChatColor.WHITE) + magicBlock.getName());
            return;
        }
        String currentName = magicBlock.getName();
        magicBlock.setName(StringUtils.join((Object[])args, " "));
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Renamed " + String.valueOf(ChatColor.WHITE) + currentName + String.valueOf(ChatColor.GRAY) + " to " + String.valueOf(ChatColor.AQUA) + magicBlock.getName());
    }

    private void onConfigureBlock(CommandSender sender, com.elmakers.mine.bukkit.block.magic.MagicBlock magicBlock, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: " + String.valueOf(ChatColor.WHITE) + "/mblock configure <property> [value]");
            return;
        }
        if (magicBlock == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "No magic block selected, use " + String.valueOf(ChatColor.WHITE) + "/mblock select");
            return;
        }
        String key = args[0];
        ConfigurationSection parameters = magicBlock.getParameters();
        if (!(args.length != 1 || parameters != null && parameters.contains(key))) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Magic block does not have a " + String.valueOf(ChatColor.WHITE) + key + String.valueOf(ChatColor.RED) + " parameter");
            return;
        }
        Location location = magicBlock.getLocation();
        this.selections.playEffects(sender, magicBlock, "blockselect");
        String message = String.valueOf(ChatColor.GREEN) + "Configured " + String.valueOf(ChatColor.LIGHT_PURPLE) + magicBlock.getName() + String.valueOf(ChatColor.GREEN) + " at " + TextUtils.printLocation(location, 0) + this.selections.getDistanceMessage(sender, magicBlock);
        sender.sendMessage(message);
        boolean isActive = this.magicController.isActive(magicBlock);
        if (isActive) {
            magicBlock.pause();
        }
        if (args.length == 1) {
            parameters.set(key, null);
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Removed property: " + String.valueOf(ChatColor.AQUA) + key);
        } else {
            if (parameters == null) {
                parameters = ConfigurationUtils.newConfigurationSection();
            }
            String configValue = StringUtils.join((Object[])Arrays.copyOfRange(args, 1, args.length), " ");
            ConfigurationUtils.set(parameters, key, configValue);
            Object value = parameters.get(key);
            magicBlock.setParameters(parameters);
            sender.sendMessage(String.valueOf(ChatColor.DARK_AQUA) + "Set property: " + String.valueOf(ChatColor.AQUA) + key + String.valueOf(ChatColor.DARK_AQUA) + " to " + String.valueOf(ChatColor.WHITE) + CompatibilityLib.getInventoryUtils().describeProperty(value));
        }
        magicBlock.reload();
        if (isActive) {
            magicBlock.resume();
        }
    }

    private void onSelectBlock(CommandSender sender, String[] args) {
        List list = this.selections.getList(sender);
        if (list == null || args.length == 0) {
            if (sender instanceof Player) {
                list = this.selections.updateList(sender).getList();
                if (args.length == 0) {
                    if (list.isEmpty()) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Could not find any magic blocks");
                    } else {
                        com.elmakers.mine.bukkit.block.magic.MagicBlock magicBlock = (com.elmakers.mine.bukkit.block.magic.MagicBlock)list.get(0);
                        this.selections.playEffects(sender, magicBlock, "blockselect");
                        String message = String.valueOf(ChatColor.GREEN) + "Selected nearby " + String.valueOf(ChatColor.LIGHT_PURPLE) + magicBlock.getName() + String.valueOf(ChatColor.GREEN) + " at " + TextUtils.printLocation(magicBlock.getLocation(), 0) + this.selections.getDistanceMessage(sender, magicBlock);
                        sender.sendMessage(message);
                        this.selections.setSelection(sender, magicBlock);
                    }
                    return;
                }
            } else {
                if (args.length == 0) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Nothing to select, Use " + String.valueOf(ChatColor.WHITE) + "/mblock list");
                    return;
                }
                list = this.selections.updateList(sender).getList();
            }
        }
        com.elmakers.mine.bukkit.block.magic.MagicBlock magicBlock = null;
        String name = args[0];
        if (args.length > 0) {
            try {
                int index = Integer.parseInt(name);
                if (index <= 0 || index > list.size()) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Index out of range: " + String.valueOf(ChatColor.WHITE) + args[0] + String.valueOf(ChatColor.GRAY) + "/" + String.valueOf(ChatColor.WHITE) + list.size());
                    return;
                }
                magicBlock = (com.elmakers.mine.bukkit.block.magic.MagicBlock)list.get(index - 1);
            }
            catch (NumberFormatException index) {
                // empty catch block
            }
        }
        if (magicBlock == null) {
            for (MagicBlock candidate : list) {
                if (!candidate.getName().equalsIgnoreCase(name) && !candidate.getTemplateKey().equalsIgnoreCase(name)) continue;
                magicBlock = (com.elmakers.mine.bukkit.block.magic.MagicBlock)candidate;
                break;
            }
            if (magicBlock == null) {
                for (MagicBlock candidate : this.selections.getAll()) {
                    if (!candidate.getName().equalsIgnoreCase(name) && !candidate.getTemplateKey().equalsIgnoreCase(name)) continue;
                    magicBlock = (com.elmakers.mine.bukkit.block.magic.MagicBlock)candidate;
                    break;
                }
            }
        }
        if (magicBlock == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Could not find: " + String.valueOf(ChatColor.WHITE) + name);
            return;
        }
        this.selections.setSelection(sender, magicBlock);
        Location location = magicBlock.getLocation();
        this.selections.playEffects(sender, magicBlock, "blockselect");
        String message = String.valueOf(ChatColor.GREEN) + "Selected " + String.valueOf(ChatColor.LIGHT_PURPLE) + magicBlock.getName() + String.valueOf(ChatColor.GREEN) + " at " + TextUtils.printLocation(location, 0) + this.selections.getDistanceMessage(sender, magicBlock);
        sender.sendMessage(message);
    }

    @Override
    public Collection<String> onTabComplete(CommandSender sender, String commandName, String[] args) {
        boolean isConfigure;
        ArrayList<String> options = new ArrayList<String>();
        String subCommand = args[0];
        String property = "";
        boolean bl = isConfigure = args.length >= 3 && subCommand.equalsIgnoreCase("add");
        if (subCommand.equalsIgnoreCase("configure") && args.length >= 2) {
            isConfigure = true;
        }
        if (isConfigure) {
            property = args[args.length - 2];
        }
        if (!sender.hasPermission("magic.commands.mblock")) {
            return options;
        }
        if (args.length == 1) {
            options.add("add");
            options.add("list");
            options.add("remove");
            options.add("select");
            options.add("configure");
            options.add("describe");
            options.add("desc");
            options.add("name");
            options.add("tp");
            options.add("move");
            options.add("debug");
            options.add("enable");
            options.add("disable");
        } else if (args.length == 2 && subCommand.equalsIgnoreCase("add")) {
            options.addAll(this.magicController.getMagicBlockTemplateKeys());
        } else if (isConfigure) {
            switch (property) {
                case "spawn.mobs": {
                    options.addAll(this.api.getController().getMobKeys());
                    for (EntityType entityType : EntityType.values()) {
                        if (!entityType.isAlive() || !entityType.isSpawnable()) continue;
                        options.add(entityType.name().toLowerCase());
                    }
                    break;
                }
                case "cast.spells": {
                    Collection<SpellTemplate> spells = this.api.getController().getSpellTemplates();
                    for (SpellTemplate spell : spells) {
                        options.add(spell.getKey());
                    }
                    break;
                }
                case "cast.undo_all": 
                case "cast.leash": 
                case "cast.recast": 
                case "spawn.check_floor": {
                    options.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
                    break;
                }
                case "spawn.interval": 
                case "interval": {
                    options.addAll(Arrays.asList(BaseSpell.EXAMPLE_DURATIONS));
                    break;
                }
                case "effects": {
                    options.addAll(this.magicController.getEffectKeys());
                    break;
                }
                case "max_moon_phase": 
                case "min_moon_phase": 
                case "moon_phase": {
                    options.add("full");
                    options.add("new");
                    for (int i = 0; i < 8; ++i) {
                        options.add(Integer.toString(i));
                    }
                    break;
                }
                case "max_time": 
                case "min_time": {
                    options.add("dawn");
                    options.add("day");
                    options.add("noon");
                    options.add("dusk");
                    options.add("night");
                    options.add("midnight");
                    options.add("0");
                    options.add("6000");
                    options.add("12000");
                    options.add("18000");
                    break;
                }
                case "spawn.radius": 
                case "spawn.vertical_radius": 
                case "spawn.vertical_range": 
                case "spawn.limit": 
                case "spawn.count": 
                case "spawn.limit_range": 
                case "spawn.player_range": 
                case "spawn.retries": 
                case "spawn.min_players": 
                case "spawn.check_radius": 
                case "spawn.vertical_check_radius": 
                case "player_range": 
                case "min_players": {
                    options.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
                    break;
                }
                case "spawn.probability": {
                    options.addAll(Arrays.asList(BaseSpell.EXAMPLE_PERCENTAGES));
                    break;
                }
                default: {
                    if (PROPERTY_KEYS.contains((Object)property)) break;
                    options.addAll((Collection<String>)PROPERTY_KEYS);
                }
            }
        }
        return options;
    }
}

