/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.economy.Currency;
import com.elmakers.mine.bukkit.api.magic.CasterProperties;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageClassTemplate;
import com.elmakers.mine.bukkit.api.magic.MageModifier;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.magic.ProgressionPath;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.magic.BaseMagicProperties;
import com.elmakers.mine.bukkit.magic.MageClass;
import com.elmakers.mine.bukkit.magic.command.MagicConfigurableExecutor;
import com.elmakers.mine.bukkit.slikey.effectlib.math.EquationStore;
import com.elmakers.mine.bukkit.slikey.effectlib.math.EquationTransform;
import com.elmakers.mine.bukkit.utility.CompatibilityConstants;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.ProfileCallback;
import com.elmakers.mine.bukkit.utility.ProfileResponse;
import com.elmakers.mine.bukkit.utility.StringUtils;
import com.elmakers.mine.bukkit.utility.platform.SkinUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.profile.PlayerProfile;

public class MageCommandExecutor
extends MagicConfigurableExecutor {
    public MageCommandExecutor(MagicAPI api) {
        super(api, "mage");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String playerName;
        ArrayList<Player> players;
        int argStart;
        String subCommand;
        block43: {
            if (args.length == 0) {
                if (!this.api.hasPermission(sender, this.getPermissionNode())) {
                    this.sendNoPermission(sender);
                    return true;
                }
                return false;
            }
            subCommand = args[0];
            if (sender instanceof Player && !this.api.hasPermission(sender, "magic.commands.mage." + subCommand)) {
                this.sendNoPermission(sender);
                return true;
            }
            argStart = 1;
            players = new ArrayList<Player>();
            String string = playerName = args.length > 1 ? args[1] : null;
            if (playerName != null && sender.hasPermission("magic.commands.mage.others")) {
                List<Entity> targets = CompatibilityLib.getCompatibilityUtils().selectEntities(sender, playerName);
                if (targets != null) {
                    argStart = 2;
                    for (Entity entity : targets) {
                        if (!(entity instanceof Player)) continue;
                        players.add((Player)entity);
                    }
                } else {
                    Player player = CompatibilityLib.getDeprecatedUtils().getPlayer(playerName);
                    if (player != null) {
                        argStart = 2;
                        players.add(player);
                    }
                }
                if (players.isEmpty() && subCommand.equalsIgnoreCase("reset") && args.length == 2) {
                    try {
                        UUID uuid = UUID.fromString(playerName);
                        this.api.getController().deleteMage(uuid.toString());
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Reset offline player id " + uuid.toString());
                        return true;
                    }
                    catch (Exception uuid) {
                        OfflinePlayer offlinePlayer = CompatibilityLib.getDeprecatedUtils().getOfflinePlayer(playerName);
                        if (offlinePlayer == null) break block43;
                        this.api.getController().deleteMage(offlinePlayer.getUniqueId().toString());
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Reset offline player " + offlinePlayer.getName() + String.valueOf(ChatColor.GRAY) + " (" + offlinePlayer.getUniqueId().toString() + ")");
                        return true;
                    }
                }
            }
        }
        String[] args2 = Arrays.copyOfRange(args, argStart, args.length);
        if (players.isEmpty()) {
            if (!(sender instanceof Player)) {
                if (subCommand.equalsIgnoreCase("debug")) {
                    this.onMageDebug(sender, sender, args2);
                    return true;
                }
                if (playerName == null) {
                    sender.sendMessage("Must specify a player name");
                } else {
                    sender.sendMessage("No players matched: " + playerName);
                }
                return true;
            }
            players.add((Player)sender);
        }
        boolean handled = false;
        for (Player player : players) {
            if (subCommand.equalsIgnoreCase("check")) {
                this.onMageCheck(sender, player, args2);
                handled = true;
            }
            if (subCommand.equalsIgnoreCase("bypass")) {
                this.onMageBypass(sender, player);
                handled = true;
            }
            if (subCommand.equalsIgnoreCase("reset")) {
                this.onMageReset(sender, player, args2);
                handled = true;
            }
            if (subCommand.equalsIgnoreCase("modifier")) {
                this.onMageModifier(sender, player, args2);
                handled = true;
            }
            if (subCommand.equalsIgnoreCase("debug")) {
                this.onMageDebug(sender, (CommandSender)player, args2);
                handled = true;
            }
            if (subCommand.equalsIgnoreCase("getdata")) {
                this.onMageGetData(sender, player, args2);
                handled = true;
            }
            if (subCommand.equalsIgnoreCase("setdata")) {
                this.onMageSetData(sender, player, args2);
                handled = true;
            }
            if (subCommand.equalsIgnoreCase("attribute")) {
                this.onMageAttribute(sender, player, args2);
                handled = true;
            }
            if (subCommand.equalsIgnoreCase("unbind")) {
                this.onMageUnbind(sender, player, args2);
                handled = true;
            }
            if (subCommand.equalsIgnoreCase("configure")) {
                this.onMageConfigure(sender, player, args2, false);
                handled = true;
            }
            if (subCommand.equalsIgnoreCase("upgrade")) {
                this.onMageConfigure(sender, player, args2, true);
                handled = true;
            }
            if (subCommand.equalsIgnoreCase("promote")) {
                this.onMagePromote(sender, player, args2);
                handled = true;
            }
            if (subCommand.equalsIgnoreCase("describe") || subCommand.equalsIgnoreCase("desc")) {
                this.onMageDescribe(sender, player, args2);
                handled = true;
            }
            if (subCommand.equalsIgnoreCase("activate")) {
                this.onMageActivate(sender, player, args2);
                handled = true;
            }
            if (subCommand.equalsIgnoreCase("deactivate")) {
                this.onMageDeactivate(sender, player, args2);
                handled = true;
            }
            if (subCommand.equalsIgnoreCase("unlock")) {
                this.onMageUnlock(sender, player, args2);
                handled = true;
            }
            if (subCommand.equalsIgnoreCase("lock")) {
                this.onMageLock(sender, player, args2);
                handled = true;
            }
            if (subCommand.equalsIgnoreCase("switch")) {
                this.onMageSwitch(sender, player, args2);
                handled = true;
            }
            if (subCommand.equalsIgnoreCase("add")) {
                this.onMageAdd(sender, player, args2);
                handled = true;
            }
            if (subCommand.equalsIgnoreCase("reward")) {
                this.onMageReward(sender, player, args2);
                handled = true;
            }
            if (subCommand.equalsIgnoreCase("remove")) {
                this.onMageRemove(sender, player, args2);
                handled = true;
            }
            if (subCommand.equalsIgnoreCase("levelspells")) {
                this.onMageLevelSpells(sender, player, args2);
                handled = true;
            }
            if (subCommand.equalsIgnoreCase("clear")) {
                this.onMageClear(sender, player, args2);
                handled = true;
            }
            if (subCommand.equalsIgnoreCase("forget")) {
                this.onMageForget(sender, player, args2);
                handled = true;
            }
            if (subCommand.equalsIgnoreCase("discover")) {
                this.onMageDiscover(sender, player, args2);
                handled = true;
            }
            if (!subCommand.equalsIgnoreCase("skin")) continue;
            this.onMageSkin(sender, player);
            handled = true;
        }
        if (!handled) {
            sender.sendMessage("Unknown mage command: " + subCommand);
            return false;
        }
        return true;
    }

    @Override
    public Collection<String> onTabComplete(CommandSender sender, String commandName, String[] args) {
        ArrayList<String> options = new ArrayList<String>();
        String[] originalArgs = args;
        if (args.length == 1) {
            this.addIfPermissible(sender, options, "magic.commands.mage.", "add");
            this.addIfPermissible(sender, options, "magic.commands.mage.", "reward");
            this.addIfPermissible(sender, options, "magic.commands.mage.", "remove");
            this.addIfPermissible(sender, options, "magic.commands.mage.", "configure");
            this.addIfPermissible(sender, options, "magic.commands.mage.", "describe");
            this.addIfPermissible(sender, options, "magic.commands.mage.", "desc");
            this.addIfPermissible(sender, options, "magic.commands.mage.", "upgrade");
            this.addIfPermissible(sender, options, "magic.commands.mage.", "modifier");
            this.addIfPermissible(sender, options, "magic.commands.mage.", "getdata");
            this.addIfPermissible(sender, options, "magic.commands.mage.", "setdata");
            this.addIfPermissible(sender, options, "magic.commands.mage.", "check");
            this.addIfPermissible(sender, options, "magic.commands.mage.", "debug");
            this.addIfPermissible(sender, options, "magic.commands.mage.", "reset");
            this.addIfPermissible(sender, options, "magic.commands.mage.", "clear");
            this.addIfPermissible(sender, options, "magic.commands.mage.", "unbind");
            this.addIfPermissible(sender, options, "magic.commands.mage.", "activate");
            this.addIfPermissible(sender, options, "magic.commands.mage.", "deactivate");
            this.addIfPermissible(sender, options, "magic.commands.mage.", "unlock");
            this.addIfPermissible(sender, options, "magic.commands.mage.", "lock");
            this.addIfPermissible(sender, options, "magic.commands.mage.", "switch");
            this.addIfPermissible(sender, options, "magic.commands.mage.", "levelspells");
            this.addIfPermissible(sender, options, "magic.commands.mage.", "attribute");
            this.addIfPermissible(sender, options, "magic.commands.mage.", "bypass");
            this.addIfPermissible(sender, options, "magic.commands.mage.", "promote");
            this.addIfPermissible(sender, options, "magic.commands.mage.", "forget");
            this.addIfPermissible(sender, options, "magic.commands.mage.", "discover");
        } else if (args.length == 2 && sender.hasPermission("magic.commands.mage.others")) {
            options.addAll(this.api.getPlayerNames());
        }
        if (args.length >= 2) {
            Object path;
            Mage mage;
            Player targetPlayer;
            CommandSender target = sender;
            String subCommand = args[0];
            if ((args = Arrays.copyOfRange(args, 1, args.length)).length > 1 && (targetPlayer = CompatibilityLib.getDeprecatedUtils().getPlayer(args[0])) != null) {
                target = targetPlayer;
                args = Arrays.copyOfRange(args, 1, args.length);
            }
            String subCommandPNode = "magic.commands.mage." + subCommand;
            if ((subCommand.equalsIgnoreCase("setdata") || subCommand.equalsIgnoreCase("getdata")) && target != null) {
                mage = this.controller.getMage(target);
                if (args.length == 2) {
                    MageSpell mageSpell = mage.getSpell(args[0]);
                    if (mageSpell != null) {
                        options.addAll(mageSpell.getVariables().getKeys(false));
                    }
                } else if (args.length == 1) {
                    ConfigurationSection data = mage.getData();
                    options.addAll(data.getKeys(false));
                    Collection<Spell> spells = mage.getSpells();
                    for (Spell spell : spells) {
                        options.add(spell.getKey());
                    }
                }
            }
            if (subCommand.equalsIgnoreCase("promote") && args.length <= 1 && target != null) {
                ProgressionPath next;
                mage = this.controller.getMage(target);
                path = mage.getActiveProperties().getPath();
                ProgressionPath progressionPath = next = path == null ? null : path.getNextPath();
                while (next != null) {
                    options.add(next.getKey());
                    next = next.getNextPath();
                }
            }
            if (subCommand.equalsIgnoreCase("discover") && args.length <= 1) {
                options.addAll(this.controller.getRecipeKeys());
            }
            if (target != null && subCommand.equalsIgnoreCase("reset") && originalArgs.length == 3) {
                mage = this.controller.getMage(target);
                for (String classKey : mage.getClassKeys()) {
                    options.add(classKey);
                }
            }
            if (subCommand.equalsIgnoreCase("modifier")) {
                if (args.length <= 1) {
                    options.add("add");
                    options.add("remove");
                } else if (args.length == 2) {
                    if (args[0].equalsIgnoreCase("remove") && target != null) {
                        mage = this.controller.getMage(target);
                        options.addAll(mage.getModifierKeys());
                    } else {
                        options.addAll(this.controller.getModifierTemplateKeys());
                    }
                }
            }
            if (args.length < 4) {
                Object mageClass;
                SpellTemplate spell;
                Object spellList;
                if (subCommand.equalsIgnoreCase("add")) {
                    spellList = this.api.getSpellTemplates(sender.hasPermission("magic.bypass_hidden"));
                    path = spellList.iterator();
                    while (path.hasNext()) {
                        spell = path.next();
                        this.addIfPermissible(sender, options, subCommandPNode, spell.getKey());
                    }
                    this.addIfPermissible(sender, options, subCommandPNode, "brush");
                }
                if (subCommand.equalsIgnoreCase("reward")) {
                    if (args.length > 1) {
                        options.addAll(this.controller.getCurrencyKeys());
                    } else {
                        spellList = this.api.getSpellTemplates(sender.hasPermission("magic.bypass_hidden"));
                        path = spellList.iterator();
                        while (path.hasNext()) {
                            spell = path.next();
                            this.addIfPermissible(sender, options, subCommandPNode, spell.getKey());
                        }
                    }
                }
                if (subCommand.equalsIgnoreCase("remove")) {
                    if (target != null) {
                        mage = this.controller.getMage(target);
                        mageClass = mage.getActiveProperties();
                        options.addAll(mageClass.getSpells());
                    }
                    options.add("brush");
                }
                if (subCommand.equalsIgnoreCase("add") && args.length > 0 && args[0].equalsIgnoreCase("brush")) {
                    options.addAll(this.api.getBrushes());
                }
                if (subCommand.equalsIgnoreCase("add")) {
                    spellList = this.api.getSpellTemplates(sender.hasPermission("magic.bypass_hidden"));
                    mageClass = spellList.iterator();
                    while (mageClass.hasNext()) {
                        spell = (SpellTemplate)mageClass.next();
                        this.addIfPermissible(sender, options, subCommandPNode, spell.getKey());
                    }
                    this.addIfPermissible(sender, options, subCommandPNode, "brush");
                }
                if (subCommand.equalsIgnoreCase("clear")) {
                    options.add("all");
                    options.add("magic");
                    options.add("skills");
                    options.add("wands");
                }
                if (subCommand.equalsIgnoreCase("configure") || subCommand.equalsIgnoreCase("describe") || subCommand.equalsIgnoreCase("upgrade")) {
                    for (String key : MageClass.PROPERTY_KEYS) {
                        options.add(key);
                    }
                    for (String protection : this.api.getController().getDamageTypes()) {
                        options.add("protection." + protection);
                    }
                }
                if (subCommand.equalsIgnoreCase("attribute")) {
                    for (String attribute : this.api.getController().getAttributes()) {
                        options.add(attribute);
                    }
                }
                if (subCommand.equalsIgnoreCase("lock") || subCommand.equalsIgnoreCase("unlock") || subCommand.equalsIgnoreCase("deactivate") || subCommand.equalsIgnoreCase("activate") || subCommand.equalsIgnoreCase("switch")) {
                    if (target != null) {
                        mage = this.controller.getMage(target);
                        boolean isActivateCommand = subCommand.equalsIgnoreCase("activate");
                        if (subCommand.equalsIgnoreCase("lock") || subCommand.equalsIgnoreCase("deactivate") || isActivateCommand) {
                            for (String classKey : mage.getClassKeys()) {
                                MageClassTemplate classTemplate;
                                if (mage.hasClassUnlocked(classKey)) {
                                    options.add(classKey);
                                    continue;
                                }
                                if (!isActivateCommand || (classTemplate = this.api.getController().getMageClassTemplate(classKey)) == null || classTemplate.isLocked()) continue;
                                options.add(classKey);
                            }
                        }
                        if (subCommand.equalsIgnoreCase("unlock") || subCommand.equalsIgnoreCase("switch")) {
                            options.addAll(this.api.getController().getMageClassKeys());
                        }
                    } else {
                        options.addAll(this.api.getController().getMageClassKeys());
                    }
                }
            }
        }
        return options;
    }

    public boolean onMageLevelSpells(CommandSender sender, Player player, String[] parameters) {
        Mage mage;
        com.elmakers.mine.bukkit.api.magic.MageClass activeClass;
        Integer maxLevel = null;
        if (parameters.length > 0) {
            try {
                maxLevel = Integer.parseInt(parameters[0]);
            }
            catch (Exception ex) {
                sender.sendMessage("Usage: /wand levelspells <level>");
                return true;
            }
        }
        return this.onLevelSpells("mage", sender, player, (activeClass = (mage = this.controller.getMage(player)).getActiveClass()) == null ? mage.getProperties() : activeClass, maxLevel);
    }

    public boolean onMageSkin(final CommandSender sender, final Player player) {
        final SkinUtils skinUtils = CompatibilityLib.getSkinUtils();
        skinUtils.fetchProfile(player.getUniqueId(), new ProfileCallback(){

            @Override
            public void result(ProfileResponse response) {
                PlayerProfile playerProfile;
                PlayerProfile playerProfile2 = playerProfile = response == null ? null : response.getPlayerProfile();
                if (playerProfile != null) {
                    String skinBlock = skinUtils.toDisguiseFormat(playerProfile);
                    sender.sendMessage(skinBlock);
                } else {
                    sender.sendMessage("Could not get skin for player " + player.getName());
                }
            }
        });
        return true;
    }

    public boolean onMageForget(CommandSender sender, Player player, String[] parameters) {
        int count = 0;
        String target = null;
        if (parameters.length > 0) {
            target = parameters[0];
        }
        for (String recipeKey : this.controller.getRecipeKeys()) {
            if (target != null && !recipeKey.contains(target) || !CompatibilityLib.getCompatibilityUtils().undiscoverRecipe((HumanEntity)player, recipeKey)) continue;
            ++count;
        }
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "Removed knowledge of " + String.valueOf(ChatColor.DARK_AQUA) + count + String.valueOf(ChatColor.AQUA) + " crafting recipes from " + String.valueOf(ChatColor.GOLD) + player.getName());
        return true;
    }

    public boolean onMageDiscover(CommandSender sender, Player player, String[] parameters) {
        if (parameters.length == 0) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /mage discover <recipe>");
            return false;
        }
        String recipe = parameters[0];
        if (!CompatibilityLib.getCompatibilityUtils().discoverRecipe((HumanEntity)player, recipe)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Could not discover recipe: " + String.valueOf(ChatColor.YELLOW) + recipe);
            return false;
        }
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "Discovered " + String.valueOf(ChatColor.DARK_AQUA) + recipe + String.valueOf(ChatColor.AQUA) + " crafting recipe for " + String.valueOf(ChatColor.GOLD) + player.getName());
        return true;
    }

    public boolean onMageClear(CommandSender sender, Player player, String[] parameters) {
        String type = "magic";
        if (parameters.length > 0) {
            type = parameters[0];
        }
        if (!(type.equalsIgnoreCase("magic") || type.equalsIgnoreCase("all") || type.equalsIgnoreCase("wands") || type.equalsIgnoreCase("skills"))) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown clear type: " + String.valueOf(ChatColor.WHITE) + type + String.valueOf(ChatColor.RED) + ", expected one of: " + String.valueOf(ChatColor.AQUA) + "all,magic,wands,skills");
        }
        int cleared = 0;
        Mage mage = this.controller.getMage(player);
        mage.deactivate();
        cleared += this.clearWands((Inventory)player.getInventory(), type);
        mage.checkWand();
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "Cleared " + String.valueOf(ChatColor.WHITE) + (cleared += this.clearWands(player.getEnderChest(), type)) + " " + String.valueOf(ChatColor.DARK_AQUA) + type + String.valueOf(ChatColor.AQUA) + " items from inventory of " + String.valueOf(ChatColor.GOLD) + player.getName());
        return true;
    }

    private int clearWands(Inventory inventory, String type) {
        int cleared = 0;
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (type.equalsIgnoreCase("all")) {
                inventory.setItem(i, null);
                continue;
            }
            ItemStack item = inventory.getItem(i);
            if (CompatibilityLib.getItemUtils().isEmpty(item) || !(type.equalsIgnoreCase("wands") && this.controller.isWand(item) || type.equalsIgnoreCase("skills") && this.controller.isSkill(item)) && (!type.equalsIgnoreCase("magic") || !this.controller.isMagic(item))) continue;
            inventory.setItem(i, null);
            ++cleared;
        }
        return cleared;
    }

    public boolean onMageCheck(CommandSender sender, Player player, String[] args) {
        Mage mage = this.controller.getMage(player);
        mage.debugPermissions(sender, null);
        return true;
    }

    protected boolean onMageBypass(CommandSender sender, Player player) {
        Mage mage = this.controller.getMage(player);
        if (mage.isBypassEnabled()) {
            if (sender != player) {
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Turned off bypass for player " + player.getName());
            }
            player.sendMessage(String.valueOf(ChatColor.GOLD) + "Your magic permissions are back to normal");
            mage.setBypassEnabled(false);
        } else {
            if (sender != player) {
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Turned on bypass for player " + player.getName());
            }
            player.sendMessage(String.valueOf(ChatColor.GOLD) + "Magic PVP/build/break/etc bypass enabled");
            mage.setBypassEnabled(true);
        }
        return true;
    }

    public boolean onMageReset(CommandSender sender, Player player, String[] args) {
        if (args.length == 0) {
            this.api.getController().deleteMage(player.getUniqueId().toString());
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Reset player " + player.getName());
        } else {
            Mage mage = this.controller.getMage(player);
            if (mage.removeClass(args[0])) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Reset " + String.valueOf(ChatColor.GOLD) + "class " + args[0] + " for player " + player.getName());
            } else {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Player " + player.getName() + " does not have class " + args[0] + " unlocked");
            }
        }
        return true;
    }

    public boolean onMageDebug(CommandSender sender, CommandSender player, String[] args) {
        Mage mage = this.controller.getMage(player);
        if (args.length > 0) {
            try {
                int level = Integer.parseInt(args[0]);
                mage.setDebugLevel(level);
                if (level > 0) {
                    mage.setDebugger(sender);
                } else {
                    mage.setDebugger(null);
                }
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Setting debug level for " + String.valueOf(ChatColor.AQUA) + player.getName() + String.valueOf(ChatColor.GOLD) + " to " + String.valueOf(ChatColor.GREEN) + Integer.toString(level));
            }
            catch (Exception ex) {
                sender.sendMessage("Expecting integer, got: " + args[0]);
            }
            return true;
        }
        if (mage.getDebugLevel() > 0) {
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Disabling debug for " + String.valueOf(ChatColor.AQUA) + player.getName());
            mage.setDebugLevel(0);
            mage.setDebugger(null);
        } else {
            sender.sendMessage(String.valueOf(ChatColor.AQUA) + "Enabling debug for " + String.valueOf(ChatColor.AQUA) + player.getName());
            mage.setDebugLevel(1);
            mage.setDebugger(sender);
        }
        return true;
    }

    public boolean onMageGetData(CommandSender sender, Player player, String[] args) {
        Mage mage = this.controller.getMage(player);
        ConfigurationSection data = mage.getData();
        if (args != null && args.length > 0) {
            if (args[0].equals("*")) {
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Mage data for " + String.valueOf(ChatColor.AQUA) + player.getDisplayName() + String.valueOf(ChatColor.GOLD) + ": ");
                Collection<Spell> spells = mage.getSpells();
                if (spells.size() == 0) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "No spell casts!");
                    return true;
                }
                for (Spell spell : spells) {
                    sender.sendMessage(String.valueOf(ChatColor.LIGHT_PURPLE) + spell.getName() + String.valueOf(ChatColor.AQUA) + " Cast Count: " + String.valueOf(ChatColor.GOLD) + spell.getCastCount());
                }
                return true;
            }
            MageSpell spell = mage.getSpell(args[0]);
            if (spell != null) {
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Mage data for " + String.valueOf(ChatColor.AQUA) + player.getDisplayName() + String.valueOf(ChatColor.GOLD) + ": " + String.valueOf(ChatColor.LIGHT_PURPLE) + spell.getName());
                sender.sendMessage(String.valueOf(ChatColor.DARK_AQUA) + " Cast Count: " + String.valueOf(ChatColor.GOLD) + spell.getCastCount());
                ConfigurationSection variables = spell.getVariables();
                for (String key : variables.getKeys(false)) {
                    String value = variables.getString(key);
                    sender.sendMessage(String.valueOf(ChatColor.AQUA) + " " + key + String.valueOf(ChatColor.DARK_AQUA) + ": " + String.valueOf(ChatColor.GOLD) + value);
                }
                return true;
            }
            String key = args[0];
            ConfigurationSection subSection = data.getConfigurationSection(key);
            if (subSection == null) {
                Object value = data.get(key);
                if (value != null) {
                    sender.sendMessage(String.valueOf(ChatColor.AQUA) + " " + key + String.valueOf(ChatColor.DARK_AQUA) + " (" + String.valueOf(value) + ")");
                } else {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown subsection or spell: " + args[0]);
                }
                return true;
            }
            data = subSection;
        }
        Set keys = data.getKeys(false);
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Mage data for " + String.valueOf(ChatColor.AQUA) + player.getDisplayName());
        for (String key : keys) {
            if (data.isConfigurationSection(key)) {
                ConfigurationSection subSection = data.getConfigurationSection(key);
                sender.sendMessage(String.valueOf(ChatColor.AQUA) + " " + key + String.valueOf(ChatColor.DARK_AQUA) + " (" + subSection.getKeys(true).size() + " items)");
                continue;
            }
            String value = data.getString(key);
            if (value != null) {
                sender.sendMessage(String.valueOf(ChatColor.AQUA) + " " + key + String.valueOf(ChatColor.DARK_AQUA) + " (" + value + ")");
                continue;
            }
            sender.sendMessage(String.valueOf(ChatColor.AQUA) + " " + key);
        }
        return true;
    }

    public boolean onMageSetData(CommandSender sender, Player player, String[] args) {
        Mage mage = this.controller.getMage(player);
        if (args.length == 0) {
            return false;
        }
        if (args.length == 1) {
            String key;
            ConfigurationSection data = mage.getData();
            if (!data.contains(key = args[0])) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "No data found with key " + String.valueOf(ChatColor.AQUA) + key + String.valueOf(ChatColor.RED) + " for " + String.valueOf(ChatColor.DARK_AQUA) + player.getDisplayName());
                return true;
            }
            data.set(key, null);
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Removed data for key " + String.valueOf(ChatColor.AQUA) + key + String.valueOf(ChatColor.GOLD) + " for " + String.valueOf(ChatColor.DARK_AQUA) + player.getDisplayName());
            return true;
        }
        if (args.length > 3) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Too many parameters");
            return true;
        }
        if (args[0].equals("*")) {
            long value = 0L;
            try {
                value = Long.parseLong(args[1]);
            }
            catch (Exception ex) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Cast count must be a number");
                return true;
            }
            Collection<Spell> spells = mage.getSpells();
            for (Spell spell : spells) {
                spell.setCastCount(value);
            }
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Set all spell cast counts to " + String.valueOf(ChatColor.AQUA) + value + String.valueOf(ChatColor.GOLD) + " for " + String.valueOf(ChatColor.DARK_AQUA) + player.getDisplayName());
            return true;
        }
        MageSpell spell = mage.getSpell(args[0]);
        if (spell != null) {
            if (args.length > 2) {
                String key = args[1];
                String value = args[2];
                spell.getVariables().set(key, (Object)value);
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Set " + String.valueOf(ChatColor.AQUA) + spell.getName() + " " + String.valueOf(ChatColor.DARK_AQUA) + key + String.valueOf(ChatColor.GOLD) + " variable to " + String.valueOf(ChatColor.AQUA) + value + String.valueOf(ChatColor.GOLD) + " for " + String.valueOf(ChatColor.DARK_AQUA) + player.getDisplayName());
                return true;
            }
            long value = 0L;
            try {
                value = Long.parseLong(args[1]);
            }
            catch (Exception ex) {
                String key = args[1];
                if (spell.getVariables().contains(key)) {
                    spell.getVariables().set(key, null);
                    sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Cleared " + String.valueOf(ChatColor.AQUA) + spell.getName() + " " + String.valueOf(ChatColor.DARK_AQUA) + key + String.valueOf(ChatColor.GOLD) + " variable for " + String.valueOf(ChatColor.DARK_AQUA) + player.getDisplayName());
                    return true;
                }
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Cast count must be a number, and no variable found with name " + key);
                return true;
            }
            spell.setCastCount(value);
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Set " + String.valueOf(ChatColor.AQUA) + spell.getName() + String.valueOf(ChatColor.GOLD) + " cast count to " + String.valueOf(ChatColor.AQUA) + value + String.valueOf(ChatColor.GOLD) + " for " + String.valueOf(ChatColor.DARK_AQUA) + player.getDisplayName());
            return true;
        }
        ConfigurationSection data = mage.getData();
        String key = args[0];
        String value = args[1];
        ConfigurationUtils.set(data, key, value);
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Set " + String.valueOf(ChatColor.AQUA) + key + String.valueOf(ChatColor.GOLD) + " to " + String.valueOf(ChatColor.AQUA) + value + String.valueOf(ChatColor.GOLD) + " for " + String.valueOf(ChatColor.DARK_AQUA) + player.getDisplayName());
        return true;
    }

    public boolean onMageAttribute(CommandSender sender, Player player, String[] args) {
        double transformed;
        Object value;
        CasterProperties attributeProperties;
        String key;
        block12: {
            Mage mage = this.controller.getMage(player);
            Set<String> internalAttributes = this.api.getController().getInternalAttributes();
            Set<String> attributes = this.api.getController().getAttributes();
            if (attributes.isEmpty()) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "No attributes configured, see attributes.yml");
                return true;
            }
            if (args.length == 0) {
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Attributes for: " + String.valueOf(ChatColor.AQUA) + player.getName());
                ArrayList<String> attributeList = new ArrayList<String>(attributes);
                Collections.sort(attributeList);
                for (String key2 : attributeList) {
                    ChatColor attributeType = internalAttributes.contains(key2) ? ChatColor.DARK_AQUA : ChatColor.GRAY;
                    Double value2 = mage.getAttribute(key2);
                    String valueDescription = value2 == null ? String.valueOf(ChatColor.RED) + "(not set)" : String.valueOf(ChatColor.AQUA) + Double.toString(value2);
                    sender.sendMessage(String.valueOf(attributeType) + key2 + String.valueOf(ChatColor.BLUE) + " = " + valueDescription);
                }
                return true;
            }
            key = args[0];
            if (!attributes.contains(key)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown attribute: " + String.valueOf(ChatColor.YELLOW) + key);
                return true;
            }
            if (args.length == 1) {
                Double value3 = mage.getAttribute(key);
                String valueDescription = value3 == null ? String.valueOf(ChatColor.RED) + "(not set)" : String.valueOf(ChatColor.AQUA) + Double.toString(value3);
                sender.sendMessage(String.valueOf(ChatColor.AQUA) + player.getName() + " has " + String.valueOf(ChatColor.DARK_AQUA) + key + String.valueOf(ChatColor.BLUE) + " of " + valueDescription);
                return true;
            }
            com.elmakers.mine.bukkit.api.magic.MageClass activeClass = mage.getActiveClass();
            attributeProperties = mage.getProperties();
            if (activeClass != null && attributeProperties.getAttribute(key) == null) {
                attributeProperties = activeClass;
            }
            value = args[1];
            for (int i = 2; i < args.length; ++i) {
                value = (String)value + " " + args[i];
            }
            if (((String)value).equals("-")) {
                Double oldValue = attributeProperties.getAttribute(key);
                attributeProperties.setAttribute(key, null);
                String valueDescription = oldValue == null ? String.valueOf(ChatColor.RED) + "(not set)" : String.valueOf(ChatColor.AQUA) + Double.toString(oldValue);
                sender.sendMessage(String.valueOf(ChatColor.BLUE) + "Removed attribute " + String.valueOf(ChatColor.DARK_AQUA) + key + String.valueOf(ChatColor.BLUE) + ", was " + valueDescription);
                return true;
            }
            transformed = Double.NaN;
            try {
                transformed = Double.parseDouble((String)value);
            }
            catch (Exception ex) {
                EquationTransform transform = EquationStore.getInstance().getTransform((String)value);
                if (transform.getException() != null) break block12;
                Double property = attributeProperties.getAttribute(key);
                if (property == null || Double.isNaN(property)) {
                    property = 0.0;
                }
                transform.setVariable("x", property);
                transformed = transform.get();
            }
        }
        if (Double.isNaN(transformed)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Could not set " + String.valueOf(ChatColor.YELLOW) + key + String.valueOf(ChatColor.RED) + " to " + String.valueOf(ChatColor.YELLOW) + (String)value);
            return true;
        }
        attributeProperties.setAttribute(key, transformed);
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Set " + String.valueOf(ChatColor.DARK_AQUA) + key + String.valueOf(ChatColor.GOLD) + " to " + String.valueOf(ChatColor.AQUA) + transformed + String.valueOf(ChatColor.GOLD) + " for " + String.valueOf(ChatColor.DARK_AQUA) + player.getDisplayName());
        return true;
    }

    public boolean onMageUnbind(CommandSender sender, Player player, String[] parameters) {
        Mage mage = this.controller.getMage(player);
        if (parameters.length > 0) {
            String template = parameters[0];
            if (mage.unbind(template)) {
                mage.sendMessage(this.api.getMessages().get("wand.unbound"));
                if (sender != player) {
                    sender.sendMessage(this.api.getMessages().getParameterized("wand.player_unbound", "$name", player.getName()));
                }
            } else {
                mage.sendMessage(this.api.getMessages().get("wand.notunbound").replace("$wand", parameters[0]));
                if (sender != player) {
                    sender.sendMessage(this.api.getMessages().getParameterized("wand.player_notunbound", "$name", player.getName()).replace("$wand", parameters[0]));
                }
            }
            return true;
        }
        mage.unbindAll();
        mage.sendMessage(this.api.getMessages().get("wand.unboundall"));
        if (sender != player) {
            sender.sendMessage(this.api.getMessages().getParameterized("wand.player_unboundall", "$name", player.getName()));
        }
        return true;
    }

    public boolean onMagePromote(CommandSender sender, Player player, String[] parameters) {
        int levels;
        ProgressionPath nextPath;
        Mage mage = this.controller.getMage(player);
        CasterProperties activeProperties = mage.getActiveProperties();
        ProgressionPath currentPath = activeProperties.getPath();
        if (currentPath == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Player " + String.valueOf(ChatColor.YELLOW) + player.getName() + String.valueOf(ChatColor.RED) + " is not currently on a path");
            return true;
        }
        String targetPath = null;
        if (parameters.length > 0) {
            targetPath = parameters[0];
            boolean foundPath = false;
            for (nextPath = currentPath.getNextPath(); nextPath != null && !foundPath; nextPath = nextPath.getNextPath()) {
                foundPath = nextPath.getKey().equalsIgnoreCase(targetPath);
            }
            if (!foundPath) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Player " + String.valueOf(ChatColor.YELLOW) + player.getName() + String.valueOf(ChatColor.RED) + " is not on a path that leads to " + String.valueOf(ChatColor.GOLD) + targetPath);
                return true;
            }
        } else if (nextPath != null) {
            targetPath = nextPath.getKey();
        }
        int totalLevels = 0;
        int iterations = 0;
        while (!(targetPath != null && targetPath.equals(currentPath.getKey()) || (levels = activeProperties.randomize(1, true)) == 0)) {
            totalLevels += levels;
            currentPath = activeProperties.getPath();
            if (++iterations <= 10000) continue;
            this.controller.getLogger().warning("Something went wrong with the mage promote command, it got stuck in a loop");
        }
        if (totalLevels == 0) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Could not promote player " + String.valueOf(ChatColor.GOLD) + player.getName());
        } else {
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Promoted player " + String.valueOf(ChatColor.GOLD) + player.getName());
        }
        return true;
    }

    public boolean onMageConfigure(CommandSender sender, Player player, String[] parameters, boolean safe) {
        Mage mage = this.controller.getMage(player);
        com.elmakers.mine.bukkit.api.magic.MageClass activeClass = mage.getActiveClass();
        return this.onConfigure("mage", activeClass == null ? mage.getProperties() : activeClass, sender, player, parameters, safe);
    }

    public boolean onMageUnlock(CommandSender sender, Player player, String[] parameters) {
        if (parameters.length < 1) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: " + String.valueOf(ChatColor.WHITE) + "/mage unlock [player] <class>");
            return true;
        }
        String classKey = parameters[0];
        Mage mage = this.controller.getMage(player);
        if (mage.hasClassUnlocked(classKey)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Class is already unlocked: " + String.valueOf(ChatColor.WHITE) + classKey);
        } else {
            com.elmakers.mine.bukkit.api.magic.MageClass mageClass = mage.unlockClass(classKey);
            if (mageClass == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid class: " + String.valueOf(ChatColor.WHITE) + classKey);
            } else {
                sender.sendMessage("Unlocked class " + classKey + " for " + player.getName());
            }
        }
        return true;
    }

    public boolean onMageLock(CommandSender sender, Player player, String[] parameters) {
        String classKey;
        if (parameters.length < 1) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: " + String.valueOf(ChatColor.WHITE) + "/mage lock [player] <class>");
            return true;
        }
        Mage mage = this.controller.getMage(player);
        boolean locked = mage.lockClass(classKey = parameters[0]);
        if (!locked) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "No unlocked class: " + String.valueOf(ChatColor.WHITE) + classKey + String.valueOf(ChatColor.RED) + " for " + String.valueOf(ChatColor.WHITE) + player.getName());
        } else {
            sender.sendMessage("Locked class " + classKey + " for " + player.getName());
        }
        return true;
    }

    public boolean onMageSwitch(CommandSender sender, Player player, String[] parameters) {
        com.elmakers.mine.bukkit.api.magic.MageClass targetClass;
        if (parameters.length < 1) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: " + String.valueOf(ChatColor.WHITE) + "/mage switch [player] <class>");
            return true;
        }
        String classKey = parameters[0];
        Mage mage = this.controller.getMage(player);
        com.elmakers.mine.bukkit.api.magic.MageClass activeClass = mage.getActiveClass();
        if (activeClass != null && activeClass.getKey().equals(classKey)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Player " + String.valueOf(ChatColor.WHITE) + player.getName() + String.valueOf(ChatColor.RED) + " already has class active: " + String.valueOf(ChatColor.WHITE) + classKey);
            return true;
        }
        if (activeClass != null) {
            mage.lockClass(activeClass.getKey());
        }
        if ((targetClass = mage.unlockClass(classKey)) == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid class: " + String.valueOf(ChatColor.WHITE) + classKey);
            if (activeClass != null) {
                mage.unlockClass(activeClass.getKey());
            }
            return true;
        }
        mage.setActiveClass(targetClass.getKey());
        mage.deactivate();
        mage.checkWand();
        sender.sendMessage("Switched class to " + classKey + " for " + player.getName());
        return true;
    }

    public boolean onMageActivate(CommandSender sender, Player player, String[] parameters) {
        String classKey;
        Mage mage = this.controller.getMage(player);
        String string = classKey = parameters.length == 0 ? null : parameters[0];
        if (mage.setActiveClass(classKey)) {
            if (classKey == null) {
                sender.sendMessage("Cleared active class for " + player.getName());
            } else {
                sender.sendMessage("Activated class " + classKey + " for " + player.getName());
            }
        } else {
            sender.sendMessage(String.valueOf(ChatColor.RED) + player.getName() + " does not have class: " + String.valueOf(ChatColor.WHITE) + classKey + String.valueOf(ChatColor.RED) + " unlocked");
        }
        return true;
    }

    public boolean onMageDeactivate(CommandSender sender, Player player, String[] parameters) {
        if (parameters.length > 0) {
            return this.onMageLock(sender, player, parameters);
        }
        Mage mage = this.controller.getMage(player);
        mage.deactivate();
        sender.sendMessage("Deactivated " + player.getName());
        return true;
    }

    public boolean onMageDescribe(CommandSender sender, Player player, String[] parameters) {
        Mage mage = this.controller.getMage(player);
        com.elmakers.mine.bukkit.api.magic.MageClass activeClass = mage.getActiveClass();
        CasterProperties mageProperties = mage.getProperties();
        if (parameters.length == 0) {
            ConfigurationSection variables;
            Set keys;
            Set<String> modifierKeys;
            sender.sendMessage(String.valueOf(ChatColor.AQUA) + "Mage " + String.valueOf(ChatColor.GOLD) + mage.getName());
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + mage.getId());
            sender.sendMessage(String.valueOf(ChatColor.BLUE) + "Use " + String.valueOf(ChatColor.AQUA) + "/mage describe <property>" + String.valueOf(ChatColor.BLUE) + " for specific properties");
            sender.sendMessage(String.valueOf(ChatColor.BLUE) + "Use " + String.valueOf(ChatColor.AQUA) + "/mage activate" + String.valueOf(ChatColor.BLUE) + " to change or clear the active class");
            Collection<String> classKeys = mage.getClassKeys();
            if (classKeys.size() > 0) {
                ArrayList<CallSite> coloredClasses = new ArrayList<CallSite>();
                for (String classKey : classKeys) {
                    ChatColor color = mage.hasClassUnlocked(classKey) ? ChatColor.GREEN : ChatColor.GRAY;
                    coloredClasses.add((CallSite)((Object)(String.valueOf(color) + classKey)));
                }
                sender.sendMessage(String.valueOf(ChatColor.AQUA) + "Classes: " + String.valueOf(ChatColor.GREEN) + StringUtils.join(coloredClasses, ","));
            }
            if (!(modifierKeys = mage.getModifierKeys()).isEmpty()) {
                sender.sendMessage(String.valueOf(ChatColor.AQUA) + "Modifiers:");
                for (String modifierKey : modifierKeys) {
                    MageModifier modifier = mage.getModifier(modifierKey);
                    String modifierDescription = String.valueOf(ChatColor.DARK_AQUA) + modifier.getName();
                    if (modifier.hasDuration()) {
                        int timeRemaining = modifier.getTimeRemaining();
                        modifierDescription = modifierDescription + String.valueOf(ChatColor.GRAY) + " (" + String.valueOf(ChatColor.WHITE) + this.controller.getMessages().getTimeDescription(timeRemaining) + String.valueOf(ChatColor.GRAY) + ")";
                    }
                    sender.sendMessage(modifierDescription);
                }
            }
            if (!mageProperties.isEmpty()) {
                sender.sendMessage(String.valueOf(ChatColor.AQUA) + "Mage properties:");
                mageProperties.describe(sender, (Set<String>)BaseMagicProperties.HIDDEN_PROPERTY_KEYS);
            }
            if (!(keys = (variables = mage.getVariables()).getKeys(false)).isEmpty()) {
                sender.sendMessage(String.valueOf(ChatColor.AQUA) + "Mage variables:");
                for (String key : keys) {
                    Object value = variables.get(key);
                    if (value == null) continue;
                    sender.sendMessage(String.valueOf(ChatColor.DARK_AQUA) + key + String.valueOf(ChatColor.GRAY) + ": " + String.valueOf(ChatColor.WHITE) + CompatibilityLib.getInventoryUtils().describeProperty(value, CompatibilityConstants.MAX_PROPERTY_DISPLAY_LENGTH));
                }
            }
            if (activeClass != null) {
                sender.sendMessage(String.valueOf(ChatColor.AQUA) + "Active class: " + String.valueOf(ChatColor.GREEN) + activeClass.getKey());
            } else {
                sender.sendMessage(String.valueOf(ChatColor.DARK_GREEN) + "No active class");
            }
            Set<Spell> activeSpells = mage.getActiveSpells();
            if (activeSpells != null && !activeSpells.isEmpty()) {
                ArrayList<String> spellNames = new ArrayList<String>();
                for (Spell spell : activeSpells) {
                    spellNames.add(spell.getName());
                }
                sender.sendMessage(String.valueOf(ChatColor.AQUA) + "Active spells: " + String.valueOf(ChatColor.DARK_AQUA) + StringUtils.join(spellNames, ","));
            }
            if (activeClass != null) {
                activeClass.describe(sender, (Set<String>)BaseMagicProperties.HIDDEN_PROPERTY_KEYS);
            }
        } else {
            Object property = activeClass.getProperty(parameters[0]);
            if (property == null) {
                sender.sendMessage(String.valueOf(ChatColor.DARK_AQUA) + parameters[0] + String.valueOf(ChatColor.GRAY) + ": " + String.valueOf(ChatColor.RED) + "(Not Set)");
            } else {
                sender.sendMessage(String.valueOf(ChatColor.DARK_AQUA) + parameters[0] + String.valueOf(ChatColor.GRAY) + ": " + String.valueOf(ChatColor.WHITE) + CompatibilityLib.getInventoryUtils().describeProperty(property));
            }
        }
        return true;
    }

    public boolean onMageReward(CommandSender sender, Player player, String[] parameters) {
        if (parameters.length < 1) {
            sender.sendMessage("Use: /mage reward <spell> [currency]");
            return true;
        }
        Mage mage = this.controller.getMage(player);
        CasterProperties caster = mage.getActiveProperties();
        String itemName = parameters[0];
        ItemStack item = this.controller.createItem(itemName);
        if (CompatibilityLib.getItemUtils().isEmpty(item)) {
            sender.sendMessage("Invalid item: " + itemName);
            return true;
        }
        if (caster.addItem(item)) {
            mage.sendMessage(this.controller.getMessages().get("commands.mage.reward.received").replace("$item", this.controller.describeItem(item)));
            if (sender != player) {
                sender.sendMessage(this.controller.getMessages().get("commands.mage.reward.gave").replace("$player", mage.getName()).replace("$item", this.controller.describeItem(item)));
            }
        } else {
            Currency currency;
            String currencyKey = "sp";
            if (parameters.length > 1) {
                currencyKey = parameters[1];
            }
            if ((currency = this.controller.getCurrency(currencyKey)) == null || !currency.isValid()) {
                if (parameters.length > 1) {
                    sender.sendMessage("Invalid currency: " + currencyKey);
                    return true;
                }
                currencyKey = "currency";
                currency = this.controller.getCurrency(currencyKey);
                if (currency == null || !currency.isValid()) {
                    sender.sendMessage("Could not refund, tried sp and Vault currency but neither are available");
                    return true;
                }
            }
            double worth = this.controller.getWorth(item, currencyKey);
            mage.addCurrency(currencyKey, worth);
            mage.sendMessage(this.controller.getMessages().get("commands.mage.reward.received").replace("$item", currency.formatAmount(worth, this.controller.getMessages())));
            if (sender != player) {
                sender.sendMessage(this.controller.getMessages().get("commands.mage.reward.replacement").replace("$player", mage.getName()).replace("$replacement", currency.formatAmount(worth, this.controller.getMessages())).replace("$item", this.controller.describeItem(item)));
            }
        }
        return true;
    }

    public boolean onMageAdd(CommandSender sender, Player player, String[] parameters) {
        if (parameters.length < 1) {
            sender.sendMessage("Use: /mage add <spell|material> [material:data]");
            return true;
        }
        Mage mage = this.controller.getMage(player);
        com.elmakers.mine.bukkit.api.magic.MageClass activeClass = mage.getActiveClass();
        if (activeClass == null) {
            sender.sendMessage("Player " + player.getName() + " has no active class");
            return true;
        }
        String spellName = parameters[0];
        if (spellName.equals("material") || spellName.equals("brush")) {
            if (parameters.length < 2) {
                sender.sendMessage("Use: /mage add brush <material:data>");
                return true;
            }
            String materialKey = parameters[1];
            if (materialKey.equals("*")) {
                int added = 0;
                for (Material material : Material.values()) {
                    if (!material.isBlock() || !activeClass.addBrush(material.name().toLowerCase())) continue;
                    ++added;
                }
                if (sender != player) {
                    sender.sendMessage("Added " + added + " brushes to " + player.getName());
                }
                return true;
            }
            if (!MaterialBrush.isValidMaterial(materialKey, false)) {
                sender.sendMessage(materialKey + " is not a valid brush");
                return true;
            }
            if (activeClass.addBrush(materialKey)) {
                if (sender != player) {
                    sender.sendMessage("Added brush '" + materialKey + "' to " + player.getName());
                } else {
                    sender.sendMessage(this.api.getMessages().get("mage.brush_added").replace("$name", materialKey));
                }
            }
            return true;
        }
        MageSpell spell = mage.getSpell(spellName);
        if (spell == null) {
            sender.sendMessage("Spell '" + spellName + "' unknown, Use /spells for spell list");
            return true;
        }
        SpellTemplate currentSpell = activeClass.getSpellTemplate(spellName);
        if (activeClass.addSpell(spellName)) {
            if (currentSpell != null) {
                String levelDescription = spell.getLevelDescription();
                if (levelDescription == null || levelDescription.isEmpty()) {
                    levelDescription = spell.getName();
                }
                if (sender != player) {
                    sender.sendMessage(this.api.getMessages().get("mage.player_spell_upgraded").replace("$player", player.getName()).replace("$name", currentSpell.getName()).replace("$level", levelDescription));
                }
            } else if (sender != player) {
                sender.sendMessage("Added '" + spell.getName() + "' to " + player.getName());
            }
        } else if (sender != player) {
            sender.sendMessage("Could not add " + spellName + " to " + player.getName());
        }
        return true;
    }

    public boolean onMageRemove(CommandSender sender, Player player, String[] parameters) {
        if (parameters.length < 1) {
            sender.sendMessage("Use: /mage remove <spell|material> [material:data]");
            return true;
        }
        Mage mage = this.controller.getMage(player);
        com.elmakers.mine.bukkit.api.magic.MageClass activeClass = mage.getActiveClass();
        if (activeClass == null) {
            sender.sendMessage("Can't modify player " + player.getName());
            return true;
        }
        String spellName = parameters[0];
        if (spellName.equals("material") || spellName.equals("brush")) {
            if (parameters.length < 2) {
                sender.sendMessage("Use: /mage remove brush <material:data>");
                return true;
            }
            String materialKey = parameters[1];
            if (activeClass.removeBrush(materialKey)) {
                mage.sendMessage("Brush '" + materialKey + "' has been removed");
                if (sender != player) {
                    sender.sendMessage("Removed brush '" + materialKey + "' from " + player.getName());
                }
            } else if (sender != player) {
                sender.sendMessage(player.getName() + " does not have brush " + materialKey);
            }
            return true;
        }
        if (activeClass.removeSpell(spellName)) {
            SpellTemplate template = this.api.getSpellTemplate(spellName);
            if (template != null) {
                spellName = template.getName();
            }
            mage.sendMessage("Spell '" + spellName + "' has been removed");
            if (sender != player) {
                sender.sendMessage("Removed '" + spellName + "' from " + player.getName());
            }
        } else if (sender != player) {
            sender.sendMessage(player.getName() + " does not have " + spellName);
        }
        return true;
    }

    public boolean onMageAddModifier(CommandSender sender, Player player, String[] parameters) {
        Mage mage = this.controller.getMage(player);
        String modifierKey = parameters[0];
        MageModifier modifier = null;
        int duration = 0;
        if (parameters.length > 1) {
            try {
                duration = Integer.parseInt(parameters[1]);
            }
            catch (Exception ex) {
                sender.sendMessage(this.controller.getMessages().get("commands.modifier.add.invalid").replace("$input", parameters[1]));
                return true;
            }
        }
        if (mage.addModifier(modifierKey, duration) && (modifier = mage.getModifier(modifierKey)) != null) {
            String message = duration > 0 ? "commands.modifier.add.success_duration" : "commands.modifier.add.success";
            sender.sendMessage(this.controller.getMessages().get(message).replace("$name", modifier.getName()).replace("$player", player.getName()).replace("$duration", this.controller.getMessages().getTimeDescription(duration)));
        }
        if (modifier == null) {
            sender.sendMessage(this.controller.getMessages().get("commands.modifier.add.fail").replace("$name", modifierKey).replace("$player", player.getName()));
        }
        return true;
    }

    public boolean onMageRemoveModifier(CommandSender sender, Player player, String[] parameters) {
        String modifierKey;
        Mage mage = this.controller.getMage(player);
        MageModifier modifier = mage.removeModifier(modifierKey = parameters[0]);
        if (modifier != null) {
            sender.sendMessage(this.controller.getMessages().get("commands.modifier.remove.success").replace("$name", modifier.getName()).replace("$player", player.getName()));
        } else {
            sender.sendMessage(this.controller.getMessages().get("commands.modifier.remove.fail").replace("$name", modifierKey).replace("$player", player.getName()));
        }
        return true;
    }

    public boolean onMageModifier(CommandSender sender, Player player, String[] parameters) {
        if (parameters.length < 2) {
            sender.sendMessage(this.controller.getMessages().get("commands.modifier.usage"));
            return true;
        }
        String subCommand = parameters[0];
        parameters = Arrays.copyOfRange(parameters, 1, parameters.length);
        if (subCommand.equalsIgnoreCase("add")) {
            return this.onMageAddModifier(sender, player, parameters);
        }
        if (subCommand.equalsIgnoreCase("remove")) {
            return this.onMageRemoveModifier(sender, player, parameters);
        }
        sender.sendMessage(this.controller.getMessages().get("commands.modifier.usage"));
        return true;
    }
}

