/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.entity;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class MobTargeting {
    private final MageController controller;
    private final List<String> requiredParameters;
    private final List<String> deniedPermissions;
    private final double radius;

    private MobTargeting(MageController controller, ConfigurationSection parameters) {
        this.controller = controller;
        this.requiredParameters = ConfigurationUtils.getStringList(parameters, "required_permissions");
        this.deniedPermissions = ConfigurationUtils.getStringList(parameters, "denied_permissions");
        this.radius = parameters.getDouble("radius");
    }

    @Nullable
    public static MobTargeting getFromMobConfig(MageController controller, ConfigurationSection mobConfiguration) {
        ConfigurationSection targetingParameters = mobConfiguration.getConfigurationSection("targeting");
        if (targetingParameters == null) {
            return null;
        }
        return new MobTargeting(controller, targetingParameters);
    }

    public boolean canTarget(Entity target) {
        if (this.isFriendly(target)) {
            return false;
        }
        if (this.requiredParameters != null) {
            boolean hasAny = false;
            for (String permission : this.requiredParameters) {
                if (!this.controller.hasPermission(target, permission)) continue;
                hasAny = true;
                break;
            }
            if (!hasAny) {
                return false;
            }
        }
        return true;
    }

    public boolean isFriendly(Entity target) {
        if (this.deniedPermissions != null) {
            for (String permission : this.deniedPermissions) {
                if (!this.controller.hasPermission(target, permission)) continue;
                return true;
            }
        }
        return false;
    }

    public void tick(Mage mage) {
        if (this.radius <= 0.0) {
            return;
        }
        Entity mageEntity = mage.getEntity();
        if (mageEntity == null || !(mageEntity instanceof Creature)) {
            return;
        }
        Creature mageCreature = (Creature)mageEntity;
        LivingEntity currentTarget = mageCreature.getTarget();
        if (currentTarget != null && currentTarget.isValid() && this.canTarget((Entity)currentTarget)) {
            return;
        }
        Location location = mageEntity.getLocation();
        List nearby = mageEntity.getNearbyEntities(this.radius, this.radius, this.radius);
        double closestDistance = Double.MAX_VALUE;
        Entity closestEntity = null;
        for (Entity checkTarget : nearby) {
            Mage targetMage;
            double distanceTo;
            if (!checkTarget.isValid() || !this.canTarget(checkTarget) || checkTarget == mageEntity || (distanceTo = location.distanceSquared(checkTarget.getLocation())) > closestDistance || (targetMage = this.controller.getRegisteredMage(checkTarget)) != null && targetMage.isIgnoredByMobs()) continue;
            closestDistance = distanceTo;
            closestEntity = checkTarget;
        }
        mage.setTarget(closestEntity);
    }
}

