/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.api.requirements;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bukkit.configuration.ConfigurationSection;

public class Requirement {
    public static final String DEFAULT_TYPE = "magic";
    @Nonnull
    private final String type;
    @Nonnull
    private final ConfigurationSection configuration;

    public Requirement(@Nonnull ConfigurationSection configuration) {
        this.configuration = configuration;
        this.type = configuration.getString("type", DEFAULT_TYPE);
    }

    @Nonnull
    public String getType() {
        return this.type;
    }

    @Nonnull
    public ConfigurationSection getConfiguration() {
        return this.configuration;
    }

    public String toString() {
        ArrayList<CallSite> pairs = new ArrayList<CallSite>();
        Set keys = this.configuration.getKeys(true);
        for (String key : keys) {
            if (this.configuration.isConfigurationSection(key)) continue;
            pairs.add((CallSite)((Object)(key + ":" + this.configuration.getString(key))));
        }
        return "{" + String.join((CharSequence)",", pairs) + "}";
    }
}

