/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.api.data;

import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.util.BlockVector;

public class SerializedLocation {
    private static boolean spammed = false;
    private String worldName;
    private BlockVector location;
    private float yaw;
    private float pitch;

    public SerializedLocation(String worldName, BlockVector location, float yaw, float pitch) {
        this.worldName = worldName;
        this.location = location;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public SerializedLocation(Location location) {
        block2: {
            this.location = new BlockVector(location.toVector());
            this.yaw = location.getYaw();
            this.pitch = location.getPitch();
            try {
                this.worldName = location.getWorld().getName();
            }
            catch (Exception ex) {
                if (spammed) break block2;
                Bukkit.getLogger().log(Level.SEVERE, "Error getting world from location: " + String.valueOf(location), ex);
                spammed = true;
            }
        }
    }

    @Nullable
    public Location asLocation() {
        World world = this.getWorld();
        return world == null ? null : new Location(world, this.location.getX(), this.location.getY(), this.location.getZ(), this.yaw, this.pitch);
    }

    @Nullable
    public World getWorld() {
        if (this.worldName == null || this.worldName.isEmpty()) {
            return null;
        }
        World world = null;
        try {
            world = Bukkit.getWorld((String)this.worldName);
        }
        catch (Exception ex) {
            if (!spammed) {
                Bukkit.getLogger().log(Level.SEVERE, "Error getting world: " + this.worldName, ex);
                spammed = true;
            }
            world = null;
        }
        return world;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public double getX() {
        return this.location.getX();
    }

    public double getY() {
        return this.location.getY();
    }

    public double getZ() {
        return this.location.getZ();
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getYaw() {
        return this.yaw;
    }
}

