/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundEntityAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.Target;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class RectOfEffectAction
extends CompoundEntityAction {
    private Vector min;
    private Vector max;
    protected int targetCount;
    protected boolean targetSource;
    protected boolean ignoreModified;
    protected boolean randomChoose;
    private Location point1;
    private Location point2;
    private Location point3;
    private Location point4;

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.createActionContext(context, context.getTargetEntity(), context.getTargetLocation());
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        this.min = ConfigurationUtils.getVector(parameters, "min");
        this.max = ConfigurationUtils.getVector(parameters, "max");
        this.targetCount = parameters.getInt("target_count", -1);
        this.targetSource = parameters.getBoolean("target_source", true);
        this.ignoreModified = parameters.getBoolean("ignore_modified", false);
        this.randomChoose = parameters.getBoolean("random_choose", false);
        super.prepare(context, parameters);
    }

    @Override
    public void addEntities(CastContext context, List<WeakReference<Entity>> entities) {
        HashSet<UUID> ignore = null;
        UndoList undoList = context.getUndoList();
        if (this.ignoreModified && undoList != null) {
            ignore = new HashSet<UUID>();
            for (Entity entity : undoList.getAllEntities()) {
                ignore.add(entity.getUniqueId());
            }
        }
        double deltaX = this.max.getX() - this.min.getX();
        double deltaY = this.max.getY() - this.min.getY();
        double deltaZ = this.max.getZ() - this.min.getZ();
        double volume = deltaX * deltaY * deltaZ;
        context.addWork((int)Math.ceil(volume / 10.0));
        Mage mage = context.getMage();
        Location sourceLocation = context.getTargetLocation();
        if (mage.getDebugLevel() > 8) {
            mage.sendDebugMessage(String.valueOf(ChatColor.GREEN) + "Rectangle Of Effect Targeting from " + String.valueOf(ChatColor.GRAY) + sourceLocation.getBlockX() + String.valueOf(ChatColor.DARK_GRAY) + "," + String.valueOf(ChatColor.GRAY) + sourceLocation.getBlockY() + String.valueOf(ChatColor.DARK_GRAY) + "," + String.valueOf(ChatColor.GRAY) + sourceLocation.getBlockZ() + String.valueOf(ChatColor.DARK_GREEN) + " with a volume of " + String.valueOf(ChatColor.GREEN) + volume + " blocks," + String.valueOf(ChatColor.GRAY) + " self? " + String.valueOf(ChatColor.DARK_GRAY) + context.getTargetsCaster(), 14);
        }
        double yaw = sourceLocation.getYaw();
        double yawRadians = Math.toRadians(yaw);
        this.point1 = sourceLocation.clone().add(Math.cos(yawRadians) * -this.min.getX(), this.min.getY(), Math.sin(yawRadians) * -this.min.getX());
        this.point2 = sourceLocation.clone().add(Math.cos(yawRadians) * -this.max.getX(), this.min.getY(), Math.sin(yawRadians) * -this.max.getX());
        double cos90 = -Math.cos(Math.toRadians(yaw - 90.0));
        double sin90 = -Math.sin(Math.toRadians(yaw - 90.0));
        this.point3 = this.point1.clone().add(cos90 * this.max.getZ(), 0.0, sin90 * this.max.getZ());
        this.point4 = this.point2.clone().add(cos90 * this.max.getZ(), 0.0, sin90 * this.max.getZ());
        this.point1 = this.point1.add(cos90 * this.min.getZ(), 0.0, sin90 * this.min.getZ());
        this.point2 = this.point2.add(cos90 * this.min.getZ(), 0.0, sin90 * this.min.getZ());
        if (mage.getDebugLevel() >= 10) {
            this.drawLine(context.getWorld(), this.point1.toVector(), this.point2.toVector(), 0.2);
            this.drawLine(context.getWorld(), this.point3.toVector(), this.point4.toVector(), 0.2);
            this.drawLine(context.getWorld(), this.point1.toVector(), this.point3.toVector(), 0.2);
            this.drawLine(context.getWorld(), this.point2.toVector(), this.point4.toVector(), 0.2);
        }
        double inclusionRadius = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
        Collection<Entity> candidates = CompatibilityLib.getCompatibilityUtils().getNearbyEntities(sourceLocation, inclusionRadius, deltaY, inclusionRadius);
        Entity targetEntity = context.getTargetEntity();
        if (this.targetCount > 0) {
            if (this.randomChoose) {
                ArrayList<Entity> candidatesList = new ArrayList<Entity>();
                for (Entity entity : candidates) {
                    boolean canTarget = entity != targetEntity || this.targetSource;
                    if (!canTarget || !this.isTargetWithinRect(sourceLocation, this.min, this.max, entity)) continue;
                    if (ignore != null && ignore.contains(entity.getUniqueId())) {
                        mage.sendDebugMessage(String.valueOf(ChatColor.DARK_RED) + "Ignoring Modified Target " + String.valueOf(ChatColor.GREEN) + String.valueOf(entity.getType()), 16);
                        continue;
                    }
                    if (canTarget && context.canTarget(entity)) {
                        candidatesList.add(entity);
                        mage.sendDebugMessage(String.valueOf(ChatColor.DARK_GREEN) + "Target " + String.valueOf(ChatColor.GREEN) + String.valueOf(entity.getType()), 12);
                        continue;
                    }
                    if (mage.getDebugLevel() <= 7) continue;
                    mage.sendDebugMessage(String.valueOf(ChatColor.DARK_RED) + "Skipped Target " + String.valueOf(ChatColor.GREEN) + String.valueOf(entity.getType()), 16);
                }
                Collections.shuffle(candidatesList);
                for (int i = 0; i < this.targetCount && i < candidatesList.size(); ++i) {
                    entities.add(new WeakReference<Entity>((Entity)candidatesList.get(i)));
                }
                return;
            }
            ArrayList<Target> targets = new ArrayList<Target>();
            for (Entity entity : candidates) {
                boolean canTarget = true;
                if (entity == targetEntity && !this.targetSource || !canTarget || !this.isTargetWithinRect(sourceLocation, this.min, this.max, entity)) continue;
                if (ignore != null && ignore.contains(entity.getUniqueId())) {
                    mage.sendDebugMessage(String.valueOf(ChatColor.DARK_RED) + "Ignoring Modified Target " + String.valueOf(ChatColor.GREEN) + String.valueOf(entity.getType()), 16);
                    continue;
                }
                if (canTarget && context.canTarget(entity)) {
                    double range = sourceLocation.distance(entity.getLocation());
                    Target target = new Target(sourceLocation, entity, (int)range, 0.0);
                    targets.add(target);
                    mage.sendDebugMessage(String.valueOf(ChatColor.DARK_GREEN) + "Target " + String.valueOf(ChatColor.GREEN) + String.valueOf(entity.getType()) + String.valueOf(ChatColor.DARK_GREEN) + ": " + String.valueOf(ChatColor.YELLOW) + target.getScore(), 12);
                    continue;
                }
                if (mage.getDebugLevel() <= 7) continue;
                mage.sendDebugMessage(String.valueOf(ChatColor.DARK_RED) + "Skipped Target " + String.valueOf(ChatColor.GREEN) + String.valueOf(entity.getType()), 16);
            }
            Collections.sort(targets);
            for (int i = 0; i < this.targetCount && i < targets.size(); ++i) {
                Target target = (Target)targets.get(i);
                entities.add(new WeakReference<Entity>(target.getEntity()));
            }
        } else {
            for (Entity entity : candidates) {
                boolean canTarget = true;
                if (entity == targetEntity && !this.targetSource || !canTarget || !this.isTargetWithinRect(sourceLocation, this.min, this.max, entity)) continue;
                if (ignore != null && ignore.contains(entity.getUniqueId())) {
                    mage.sendDebugMessage(String.valueOf(ChatColor.DARK_RED) + "Ignoring Modified Target " + String.valueOf(ChatColor.GREEN) + String.valueOf(entity.getType()), 16);
                    continue;
                }
                if (canTarget && context.canTarget(entity)) {
                    entities.add(new WeakReference<Entity>(entity));
                    mage.sendDebugMessage(String.valueOf(ChatColor.DARK_GREEN) + "Target " + String.valueOf(ChatColor.GREEN) + String.valueOf(entity.getType()), 12);
                    continue;
                }
                if (mage.getDebugLevel() <= 7) continue;
                mage.sendDebugMessage(String.valueOf(ChatColor.DARK_RED) + "Skipped Target " + String.valueOf(ChatColor.GREEN) + String.valueOf(entity.getType()), 16);
            }
        }
    }

    public boolean isTargetWithinRect(Location sourceLocation, Vector min, Vector max, Entity candidate) {
        Vector location = candidate.getLocation().toVector();
        if (location.getY() < sourceLocation.getY() + min.getY() || location.getY() > sourceLocation.getY() + max.getY()) {
            return false;
        }
        if (!this.testPointAgainstLine(location, this.point3.toVector(), this.point1.toVector())) {
            return false;
        }
        if (!this.testPointAgainstLine(location, this.point1.toVector(), this.point2.toVector())) {
            return false;
        }
        if (!this.testPointAgainstLine(location, this.point2.toVector(), this.point4.toVector())) {
            return false;
        }
        return this.testPointAgainstLine(location, this.point4.toVector(), this.point3.toVector());
    }

    public boolean testPointAgainstLine(Vector point, Vector lineStart, Vector lineEnd) {
        double contained = (lineEnd.getX() - lineStart.getX()) * (point.getZ() - lineStart.getZ()) - (point.getX() - lineStart.getX()) * (lineEnd.getZ() - lineStart.getZ());
        return contained < 0.0;
    }

    public void drawLine(World world, Vector p1, Vector p2, double space) {
        double distance = p1.distance(p2);
        Vector vector = p2.clone().subtract(p1).normalize();
        for (double length = 0.0; length < distance; length += space) {
            world.spawnParticle(Particle.FLAME, p1.getX(), p1.getY(), p1.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
            p1.add(vector.clone().multiply(space));
        }
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("target_count");
        parameters.add("target_source");
        parameters.add("random_choose");
        parameters.add("min");
        parameters.add("max");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("target_count") || parameterKey.equals("min") || parameterKey.equals("max")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }
}

