/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.utility.StringUtils;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.configuration.ConfigurationSection;

public class PlayRecordAction
extends BaseSpellAction {
    private Set<String> records = new HashSet<String>();

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.records.clear();
        String recordList = parameters.getString("records", "");
        if (!recordList.isEmpty()) {
            String[] records;
            for (String record : records = StringUtils.split(recordList, ",")) {
                this.records.add(record.toUpperCase(Locale.ROOT));
            }
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        ArrayList<Sound> sounds = new ArrayList<Sound>();
        for (Sound sound : Sound.values()) {
            String musicDiscName;
            String soundName = sound.name().toUpperCase(Locale.ROOT);
            boolean isMusicDisc = soundName.startsWith("MUSIC_DISC");
            if (this.records.isEmpty()) {
                if (!isMusicDisc) continue;
                sounds.add(sound);
                continue;
            }
            if (this.records.contains(soundName)) {
                sounds.add(sound);
                continue;
            }
            if (!isMusicDisc || !this.records.contains(musicDiscName = soundName.substring("MUSIC_DISC_".length()))) continue;
            sounds.add(sound);
        }
        if (sounds.isEmpty()) {
            return SpellResult.FAIL;
        }
        Random random = context.getRandom();
        Sound sound = (Sound)Iterables.get(sounds, (int)random.nextInt(sounds.size()));
        Location location = context.getTargetLocation();
        location.getWorld().playSound(location, sound, SoundCategory.RECORDS, 1.0f, 1.0f);
        return SpellResult.CAST;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }
}

