/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.base.entity;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.utility.ConfigUtils;
import com.elmakers.mine.bukkit.utility.platform.base.entity.EntityAnimalData;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fox;

public class EntityFoxData
extends EntityAnimalData {
    private Fox.Type type;
    private Boolean crouching;
    private UUID firstTrusted;
    private UUID secondTrusted;

    public EntityFoxData(ConfigurationSection parameters, MageController controller) {
        super(parameters, controller);
        String secondTrusted;
        Logger log = controller.getLogger();
        String typeString = parameters.getString("fox_type");
        if (typeString != null && !typeString.isEmpty()) {
            try {
                this.type = Fox.Type.valueOf((String)typeString.toUpperCase());
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Invalid fox_type: " + typeString, ex);
            }
        }
        this.crouching = ConfigUtils.getOptionalBoolean(parameters, "crouching");
        String trusted = parameters.getString("trusted");
        if (trusted != null && !trusted.isEmpty()) {
            try {
                this.firstTrusted = UUID.fromString(trusted);
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Invalid trusted UUID: " + trusted, ex);
            }
        }
        if ((secondTrusted = parameters.getString("second_trusted")) != null && !secondTrusted.isEmpty()) {
            try {
                this.secondTrusted = UUID.fromString(secondTrusted);
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Invalid trusted UUID: " + secondTrusted, ex);
            }
        }
    }

    public EntityFoxData(Entity entity) {
        super(entity);
        if (entity instanceof Fox) {
            AnimalTamer second;
            Fox fox = (Fox)entity;
            this.type = fox.getFoxType();
            this.crouching = fox.isCrouching();
            AnimalTamer trusted = fox.getFirstTrustedPlayer();
            if (trusted != null) {
                this.firstTrusted = trusted.getUniqueId();
            }
            if ((second = fox.getSecondTrustedPlayer()) != null) {
                this.secondTrusted = second.getUniqueId();
            }
        }
    }

    @Override
    public void apply(Entity entity) {
        super.apply(entity);
        if (entity instanceof Fox) {
            OfflinePlayer trusted;
            Fox fox = (Fox)entity;
            if (this.type != null) {
                fox.setFoxType(this.type);
            }
            if (this.crouching != null) {
                fox.setCrouching(this.crouching.booleanValue());
            }
            if (this.firstTrusted != null && (trusted = Bukkit.getOfflinePlayer((UUID)this.firstTrusted)) != null) {
                fox.setFirstTrustedPlayer((AnimalTamer)trusted);
            }
            if (this.secondTrusted != null && (trusted = Bukkit.getOfflinePlayer((UUID)this.secondTrusted)) != null) {
                fox.setSecondTrustedPlayer((AnimalTamer)trusted);
            }
        }
    }

    @Override
    public boolean cycle(Entity entity) {
        if (!this.canCycle(entity)) {
            return false;
        }
        Fox fox = (Fox)entity;
        Fox.Type type = fox.getFoxType();
        Fox.Type[] typeValues = Fox.Type.values();
        int typeOrdinal = (type.ordinal() + 1) % typeValues.length;
        type = typeValues[typeOrdinal];
        fox.setFoxType(type);
        return true;
    }

    @Override
    public boolean canCycle(Entity entity) {
        return entity instanceof Fox;
    }
}

