/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.magic.command.Paginator;
import com.elmakers.mine.bukkit.utility.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class SpellsPaginator
extends Paginator<SpellTemplate> {
    private final MageController controller;

    public SpellsPaginator(MageController controller) {
        this.controller = controller;
    }

    @Override
    @Nonnull
    protected List<SpellTemplate> getList(CommandSender sender) {
        Collection<SpellTemplate> spells = this.controller.getSpellTemplates(sender.hasPermission("magic.bypass_hidden"));
        ArrayList<SpellTemplate> list = new ArrayList<SpellTemplate>(spells);
        Collections.sort(list, new Comparator<SpellTemplate>(this){

            @Override
            public int compare(SpellTemplate spell1, SpellTemplate spell2) {
                return spell1.getName().compareTo(spell2.getName());
            }
        });
        return list;
    }

    @Override
    @Nonnull
    protected String describe(SpellTemplate spell) {
        Object description;
        String name = spell.getName();
        String message = String.valueOf(ChatColor.AQUA) + name;
        if (!name.equals(spell.getKey())) {
            message = message + String.valueOf(ChatColor.DARK_GRAY) + " (" + String.valueOf(ChatColor.BLUE) + spell.getKey() + String.valueOf(ChatColor.DARK_GRAY) + ")";
        }
        if ((description = spell.getDescription()) != null) {
            String[] pieces = StringUtils.split((String)description, "\n");
            if (pieces.length > 0 && ((String)(description = pieces[0])).length() > 30) {
                description = ((String)description).substring(0, 27) + "...";
            }
            if (!((String)description).isEmpty()) {
                message = message + String.valueOf(ChatColor.DARK_GRAY) + " : " + String.valueOf(ChatColor.GRAY) + (String)description;
            }
        }
        return message;
    }

    @Override
    @Nonnull
    protected String getTypeNamePlural() {
        return "spells";
    }
}

