/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.crafting;

import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.crafting.MagicRecipe;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;

public class MagicSmithingRecipe
extends MagicRecipe {
    protected Recipe recipe;
    protected ItemData ingredient;
    protected ItemData addition;
    protected String group;

    protected MagicSmithingRecipe(String key, MagicController controller) {
        super(key, controller);
    }

    @Override
    public ItemStack load(ConfigurationSection configuration) {
        ItemStack additionItem;
        ItemStack ingredientItem;
        ItemStack item = super.load(configuration);
        if (item == null) {
            return null;
        }
        String materialKey = configuration.getString("ingredient");
        this.ingredient = this.controller.getOrCreateItem(materialKey);
        ItemStack itemStack = ingredientItem = this.ingredient == null ? null : this.ingredient.getItemStack();
        if (CompatibilityLib.getItemUtils().isEmpty(ingredientItem)) {
            this.controller.getLogger().warning("Invalid " + this.getType() + " recipe ingredient " + materialKey);
            return null;
        }
        materialKey = configuration.getString("addition");
        this.addition = this.controller.getOrCreateItem(materialKey);
        ItemStack itemStack2 = additionItem = this.addition == null ? null : this.ingredient.getItemStack();
        if (CompatibilityLib.getItemUtils().isEmpty(additionItem)) {
            this.controller.getLogger().warning("Invalid " + this.getType() + " recipe addition ingredient " + materialKey);
            return null;
        }
        this.recipe = CompatibilityLib.getCompatibilityUtils().createSmithingRecipe(this.key, item, ingredientItem, additionItem);
        if (this.recipe != null && this.group != null && !this.group.isEmpty()) {
            CompatibilityLib.getCompatibilityUtils().setRecipeGroup(this.recipe, this.group);
        }
        return item;
    }

    @Override
    public Recipe getRecipe() {
        return this.recipe;
    }

    @Override
    protected String getType() {
        return "smithing";
    }
}

