/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.crafting;

import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.crafting.MagicRecipe;
import com.elmakers.mine.bukkit.crafting.RecipeMatchType;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;

public class MagicShapedRecipe
extends MagicRecipe {
    private Material substitue;
    private String group;
    private ShapedRecipe recipe;
    private Map<Character, ItemData> ingredients = new HashMap<Character, ItemData>();

    protected MagicShapedRecipe(String key, MagicController controller) {
        super(key, controller);
    }

    @Override
    public ItemStack load(ConfigurationSection configuration) {
        boolean isVanillaRecipe;
        ItemStack item = super.load(configuration);
        if (item == null) {
            return null;
        }
        this.substitue = ConfigurationUtils.getMaterial(configuration, "substitute", null);
        this.group = configuration.getString("group", "");
        String vanillaItemKey = configuration.getString("vanilla");
        boolean bl = isVanillaRecipe = vanillaItemKey != null && !vanillaItemKey.isEmpty() && !vanillaItemKey.equalsIgnoreCase("false");
        if (isVanillaRecipe) {
            List recipes;
            ItemStack vanillaItem = item;
            if (!vanillaItemKey.equalsIgnoreCase("true") && (vanillaItem = this.controller.createItem(vanillaItemKey)) == null) {
                this.controller.getLogger().warning("Crafting recipe " + this.key + " specifies a vanilla recipe with an invalid item: " + vanillaItemKey);
                vanillaItem = item;
            }
            if ((recipes = this.controller.getPlugin().getServer().getRecipesFor(vanillaItem)) != null && !recipes.isEmpty()) {
                Recipe recipe;
                if (recipes.size() > 1) {
                    this.controller.getLogger().warning("Crafting recipe " + this.key + " specifies a vanilla recipe, but more than one recipe was found for: " + this.getOutputKey() + ". Only one version will be overridden.");
                }
                if ((recipe = (Recipe)recipes.get(0)) instanceof ShapedRecipe) {
                    ShapedRecipe copyRecipe = (ShapedRecipe)recipe;
                    this.recipe = CompatibilityLib.getCompatibilityUtils().createShapedRecipe(this.key, item);
                    this.recipe.shape(copyRecipe.getShape());
                    for (Map.Entry entry : copyRecipe.getIngredientMap().entrySet()) {
                        ItemData ingredient;
                        ItemStack ingredientItem;
                        char ingredientKey = ((Character)entry.getKey()).charValue();
                        ItemStack input = (ItemStack)entry.getValue();
                        if (CompatibilityLib.getItemUtils().isEmpty(input)) {
                            input = new ItemStack(Material.AIR);
                        }
                        ItemStack itemStack = ingredientItem = (ingredient = this.controller.createItemData(input)) == null ? null : ingredient.getItemStack();
                        if (CompatibilityLib.getItemUtils().isEmpty(ingredientItem)) {
                            this.controller.getLogger().warning("Invalid " + this.getType() + " recipe ingredient " + ingredientKey);
                            return null;
                        }
                        this.ingredients.put(Character.valueOf(ingredientKey), ingredient);
                        if (CompatibilityLib.getCompatibilityUtils().setRecipeIngredient(this.recipe, ingredientKey, ingredientItem, this.ignoreDamage)) continue;
                        this.controller.getLogger().warning("Unable to set recipe ingredient from vanilla ingredient: " + String.valueOf(input));
                        return null;
                    }
                } else {
                    this.controller.getLogger().warning("Crafting recipe " + this.key + " specifies a shapeless vanilla recipe: " + this.getOutputKey());
                }
            } else {
                this.controller.getLogger().warning("Crafting recipe " + this.key + " specifies a vanilla recipe, but no recipe was found for: " + this.getOutputKey());
            }
        } else {
            ShapedRecipe shaped = CompatibilityLib.getCompatibilityUtils().createShapedRecipe(this.key, item);
            HashSet<String> symbolsUsed = new HashSet<String>();
            ArrayList<String> rows = new ArrayList<String>();
            for (int i = 1; i <= 3; ++i) {
                String recipeRow = configuration.getString("row_" + i, "");
                if (recipeRow.length() <= 0) continue;
                rows.add(recipeRow);
                symbolsUsed.addAll(Arrays.asList(recipeRow.split("")));
            }
            if (rows.size() > 0) {
                shaped = shaped.shape(rows.toArray(new String[0]));
                ConfigurationSection materials = configuration.getConfigurationSection("ingredients");
                if (materials == null) {
                    materials = configuration.getConfigurationSection("materials");
                }
                Set keys = materials.getKeys(false);
                for (String key : keys) {
                    ItemStack ingredientItem;
                    String materialKey = materials.getString(key);
                    if (!symbolsUsed.contains(key)) {
                        this.controller.getLogger().warning("Ingredient is not used in recipe " + this.getKey() + ", this may be normal if overriding an existing recipe or on an older server version, but if it is a custom recipe this may be a mistake " + key + ": " + materialKey);
                        continue;
                    }
                    ItemData ingredient = this.controller.getOrCreateItem(materialKey);
                    ItemStack itemStack = ingredientItem = ingredient == null ? null : ingredient.getItemStack();
                    if (CompatibilityLib.getItemUtils().isEmpty(ingredientItem)) {
                        this.controller.getLogger().warning("Invalid " + this.getType() + " recipe ingredient " + materialKey);
                        return null;
                    }
                    if (!CompatibilityLib.getCompatibilityUtils().setRecipeIngredient(shaped, key.charAt(0), ingredientItem, this.ignoreDamage)) {
                        this.controller.getLogger().warning("Unable to set recipe ingredient " + materialKey);
                        return null;
                    }
                    this.ingredients.put(Character.valueOf(key.charAt(0)), ingredient);
                }
                this.recipe = shaped;
            }
        }
        if (this.recipe != null && this.group != null && !this.group.isEmpty()) {
            CompatibilityLib.getCompatibilityUtils().setRecipeGroup((Recipe)this.recipe, this.group);
        }
        return item;
    }

    @Override
    public Recipe getRecipe() {
        return this.recipe;
    }

    @Override
    public Material getSubstitute() {
        return this.substitue;
    }

    @Override
    public RecipeMatchType getMatchType(Recipe matchRecipe, ItemStack[] matrix) {
        if (this.recipe == null || matrix.length < 4) {
            return RecipeMatchType.NONE;
        }
        return this.isSameRecipe(matchRecipe) ? RecipeMatchType.MATCH : RecipeMatchType.NONE;
    }

    @Override
    protected String getType() {
        return "shaped";
    }
}

