/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.base;

import com.elmakers.mine.bukkit.utility.ChatUtils;
import com.elmakers.mine.bukkit.utility.CompatibilityConstants;
import com.elmakers.mine.bukkit.utility.CurrencyAmount;
import com.elmakers.mine.bukkit.utility.StringUtils;
import com.elmakers.mine.bukkit.utility.platform.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.platform.InventoryUtils;
import com.elmakers.mine.bukkit.utility.platform.Platform;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;

public class InventoryUtilsBase
implements InventoryUtils {
    protected final Platform platform;

    protected InventoryUtilsBase(Platform platform) {
        this.platform = platform;
    }

    @Override
    public CurrencyAmount getCurrencyAmount(ItemStack item) {
        if (this.platform.getItemUtils().isEmpty(item)) {
            return null;
        }
        Object currency = this.platform.getNBTUtils().getTag(item, "currency");
        if (currency != null) {
            String currencyType = this.platform.getNBTUtils().getString(currency, "type");
            if (currencyType != null) {
                return new CurrencyAmount(currencyType, this.platform.getNBTUtils().getOptionalInt(currency, "amount"));
            }
            return null;
        }
        int spAmount = this.platform.getNBTUtils().getInt(item, "sp", 0);
        if (spAmount > 0) {
            return new CurrencyAmount("sp", spAmount);
        }
        return null;
    }

    @Override
    public boolean configureSkillItem(ItemStack skillItem, String skillClass, boolean quickCast, ConfigurationSection skillConfig) {
        String quickCastString;
        if (skillItem == null) {
            return false;
        }
        Object handle = this.platform.getItemUtils().getHandle(skillItem);
        if (handle == null) {
            return false;
        }
        Object tag = this.platform.getItemUtils().getOrCreateTag(handle);
        if (tag == null) {
            return false;
        }
        this.platform.getNBTUtils().setBoolean(tag, "skill", true);
        Object spellNode = this.platform.getNBTUtils().getTag(skillItem, "spell");
        if (skillClass != null && spellNode != null) {
            this.platform.getNBTUtils().setString(spellNode, "class", skillClass);
        }
        if (skillConfig == null) {
            return true;
        }
        if (skillConfig.getBoolean("undroppable", false)) {
            this.platform.getNBTUtils().setBoolean(tag, "undroppable", true);
        }
        if (skillConfig.getBoolean("keep", false)) {
            this.platform.getNBTUtils().setBoolean(tag, "keep", true);
        }
        if (!(quickCastString = skillConfig.getString("quick_cast", "")).equalsIgnoreCase("auto")) {
            quickCast = skillConfig.getBoolean("quick_cast", true);
        }
        if (!quickCast && spellNode != null) {
            this.platform.getNBTUtils().setBoolean(spellNode, "quick_cast", false);
        }
        return true;
    }

    @Override
    public ItemStack setSkullURL(ItemStack itemStack, String url) {
        try {
            return this.setSkullURL(itemStack, new URL(url), UUID.nameUUIDFromBytes(url.getBytes()));
        }
        catch (MalformedURLException e) {
            this.platform.getLogger().log(Level.WARNING, "Malformed URL: " + url, e);
            return itemStack;
        }
    }

    @Override
    public ItemStack setSkullURL(ItemStack itemStack, URL url, UUID id) {
        return this.setSkullURL(itemStack, url, id, "MHF_Question");
    }

    @Override
    public ItemStack setSkullURL(ItemStack itemStack, URL url, UUID id, String ownerName) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta instanceof SkullMeta) {
            SkullMeta skullMeta = (SkullMeta)itemMeta;
            PlayerProfile fakeProfile = Bukkit.createPlayerProfile((UUID)id, (String)ownerName);
            fakeProfile.getTextures().setSkin(url);
            skullMeta.setOwnerProfile(fakeProfile);
            itemStack.setItemMeta(itemMeta);
        }
        return itemStack;
    }

    @Override
    public String getSkullURL(ItemStack skull) {
        ItemMeta itemMeta = skull.getItemMeta();
        if (itemMeta instanceof SkullMeta) {
            URL skinURL;
            SkullMeta skullMeta = (SkullMeta)itemMeta;
            PlayerProfile playerProfile = skullMeta.getOwnerProfile();
            URL uRL = skinURL = playerProfile == null ? null : playerProfile.getTextures().getSkin();
            if (skinURL != null) {
                return skinURL.toString();
            }
        }
        return null;
    }

    @Override
    public boolean isSkull(ItemStack item) {
        if (item == null) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        return meta instanceof SkullMeta;
    }

    @Override
    public void makeKeep(ItemStack itemStack) {
        this.platform.getNBTUtils().setBoolean(itemStack, "keep", true);
    }

    @Override
    public boolean isKeep(ItemStack itemStack) {
        return this.platform.getNBTUtils().containsTag(itemStack, "keep");
    }

    @Override
    public void applyAttributes(ItemStack item, ConfigurationSection attributeConfig, String slot) {
        if (item == null) {
            return;
        }
        this.platform.getCompatibilityUtils().removeItemAttributes(item);
        if (attributeConfig == null) {
            return;
        }
        Set attributeKeys = attributeConfig.getKeys(false);
        for (String attributeKey : attributeKeys) {
            try {
                double value = 0.0;
                int operation = 0;
                UUID uuid = null;
                ConfigurationSection attributeConfiguration = attributeConfig.getConfigurationSection(attributeKey);
                if (attributeConfiguration != null) {
                    String uuidString;
                    attributeKey = attributeConfiguration.getString("attribute", attributeKey);
                    value = attributeConfiguration.getDouble("value");
                    slot = attributeConfiguration.getString("slot", slot);
                    String operationKey = attributeConfiguration.getString("operation");
                    if (operationKey != null && !operationKey.isEmpty()) {
                        try {
                            AttributeModifier.Operation eOperation = AttributeModifier.Operation.valueOf((String)operationKey.toUpperCase());
                            operation = eOperation.ordinal();
                        }
                        catch (Exception ex) {
                            this.platform.getLogger().warning("Invalid operation " + operationKey);
                        }
                    }
                    if ((uuidString = attributeConfiguration.getString("uuid")) != null && !uuidString.isEmpty()) {
                        try {
                            uuid = UUID.fromString(uuidString);
                        }
                        catch (Exception ex) {
                            this.platform.getLogger().warning("Invalid UUID " + uuidString);
                        }
                    }
                } else {
                    value = attributeConfig.getDouble(attributeKey);
                }
                if (uuid == null) {
                    uuid = UUID.randomUUID();
                }
                Attribute attribute = Attribute.valueOf((String)attributeKey.toUpperCase());
                if (this.platform.getCompatibilityUtils().setItemAttribute(item, attribute, value, slot, operation, uuid)) continue;
                this.platform.getLogger().warning("Failed to set attribute: " + attributeKey);
            }
            catch (Exception ex) {
                this.platform.getLogger().warning("Invalid attribute: " + attributeKey);
            }
        }
    }

    @Override
    public void applyEnchantments(ItemStack item, ConfigurationSection enchantConfig) {
        if (item == null) {
            return;
        }
        HashSet<Enchantment> keep = null;
        if (enchantConfig != null) {
            keep = new HashSet<Enchantment>();
            CompatibilityUtils compatibilityUtils = this.platform.getCompatibilityUtils();
            Set enchantKeys = enchantConfig.getKeys(false);
            for (String enchantKey : enchantKeys) {
                try {
                    Enchantment enchantment = compatibilityUtils.getEnchantmentByKey(enchantKey);
                    if (enchantment == null) {
                        this.platform.getLogger().warning("Invalid enchantment: " + enchantKey);
                        continue;
                    }
                    item.addUnsafeEnchantment(enchantment, enchantConfig.getInt(enchantKey));
                    keep.add(enchantment);
                }
                catch (Exception ex) {
                    this.platform.getLogger().log(Level.SEVERE, "Error adding enchantment to item " + item.getType() + ": " + enchantKey, ex);
                }
            }
        }
        ArrayList existing = new ArrayList(item.getEnchantments().keySet());
        for (Enchantment enchantment : existing) {
            if (keep != null && keep.contains(enchantment)) continue;
            item.removeEnchantment(enchantment);
        }
    }

    @Override
    public boolean addEnchantments(ItemStack item, ConfigurationSection enchantConfig) {
        if (item == null) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        boolean addedAny = false;
        if (enchantConfig != null) {
            CompatibilityUtils compatibilityUtils = this.platform.getCompatibilityUtils();
            Set enchantKeys = enchantConfig.getKeys(false);
            for (String enchantKey : enchantKeys) {
                try {
                    Enchantment enchantment = compatibilityUtils.getEnchantmentByKey(enchantKey);
                    if (enchantment == null) {
                        this.platform.getLogger().warning("Invalid enchantment: " + enchantKey);
                        continue;
                    }
                    int level = enchantConfig.getInt(enchantKey);
                    if (meta.getEnchantLevel(enchantment) >= level || !meta.hasEnchant(enchantment) && meta.hasConflictingEnchant(enchantment) || !meta.addEnchant(enchantment, level, false)) continue;
                    addedAny = true;
                }
                catch (Exception ex) {
                    this.platform.getLogger().log(Level.SEVERE, "Error adding enchantment to item " + item.getType() + ": " + enchantKey, ex);
                }
            }
        }
        if (addedAny) {
            item.setItemMeta(meta);
        }
        return addedAny;
    }

    @Override
    public String describeProperty(Object property) {
        return this.describeProperty(property, 0);
    }

    @Override
    public String describeProperty(Object property, int maxLength) {
        String propertyString;
        if (property == null) {
            return "(Empty)";
        }
        if (property instanceof ConfigurationSection) {
            ConfigurationSection section = (ConfigurationSection)property;
            Set keys = section.getKeys(false);
            StringBuilder full = new StringBuilder("{");
            boolean first = true;
            for (String key : keys) {
                if (!first) {
                    full.append(',');
                }
                first = false;
                full.append(key).append(':').append(this.describeProperty(section.get(key)));
            }
            propertyString = full.append('}').toString();
        } else {
            propertyString = property.toString();
        }
        if (maxLength > 0 && propertyString.length() > maxLength - 3) {
            propertyString = propertyString.substring(0, maxLength - 3) + "...";
        }
        return propertyString;
    }

    @Override
    public boolean isSameInstance(ItemStack one, ItemStack two) {
        return one == two;
    }

    @Override
    public int getMapId(ItemStack mapItem) {
        ItemMeta meta = mapItem.getItemMeta();
        if (meta instanceof MapMeta) {
            MapMeta mapMeta = (MapMeta)meta;
            return mapMeta.getMapId();
        }
        return 0;
    }

    @Override
    public void setMapId(ItemStack mapItem, int id) {
        ItemMeta meta = mapItem.getItemMeta();
        if (meta instanceof MapMeta) {
            MapMeta mapMeta = (MapMeta)meta;
            mapMeta.setMapId(id);
            mapItem.setItemMeta((ItemMeta)mapMeta);
        }
    }

    @Override
    public ItemStack createMap(Material material, int mapId) {
        ItemStack mapItem = new ItemStack(material, 1);
        this.setMapId(mapItem, mapId);
        return mapItem;
    }

    @Override
    public void wrapText(String text, Collection<String> list) {
        this.wrapText(text, CompatibilityConstants.MAX_LORE_LENGTH, list);
    }

    @Override
    public void wrapText(String text, String prefix, Collection<String> list) {
        this.wrapText(text, prefix, CompatibilityConstants.MAX_LORE_LENGTH, list);
    }

    @Override
    public void wrapText(String text, int maxLength, Collection<String> list) {
        this.wrapText(text, "", maxLength, list);
    }

    @Override
    public void wrapText(String text, String prefix, int maxLength, Collection<String> list) {
        if (text == null || text.isEmpty()) {
            return;
        }
        String colorPrefix = "";
        String[] lines = StringUtils.splitPreserveAllTokens(text, "\n\r");
        if (maxLength == 0) {
            list.addAll(Arrays.asList(lines));
            return;
        }
        String wrapPrefix = CompatibilityConstants.LORE_WRAP_PREFIX;
        for (String line : lines) {
            if (line.isEmpty()) {
                list.add(line);
                continue;
            }
            line = prefix + line;
            String[] components = StringUtils.splitPreserveAllTokens(line, "`");
            StringBuilder currentLine = new StringBuilder();
            int currentLength = 0;
            for (int i = 0; i < components.length; ++i) {
                String[] words;
                String component = components[i];
                if (component.startsWith("{")) {
                    int length = ChatColor.stripColor((String)ChatUtils.getSimpleMessage(component)).length();
                    if (currentLength != 0 && currentLength + length > maxLength) {
                        list.add(colorPrefix + currentLine);
                        currentLine.setLength(0);
                        currentLine.append(wrapPrefix);
                        currentLength = wrapPrefix.length();
                    }
                    currentLine.append('`');
                    currentLine.append(component);
                    currentLine.append('`');
                    currentLength += length;
                    continue;
                }
                boolean hasWord = false;
                for (String word : words = StringUtils.split(component, " ")) {
                    int length = ChatColor.stripColor((String)word).length();
                    if (currentLength != 0 && currentLength + length > maxLength) {
                        String newLine = colorPrefix + currentLine;
                        colorPrefix = ChatColor.getLastColors((String)newLine);
                        list.add(newLine);
                        currentLine.setLength(0);
                        currentLine.append(wrapPrefix);
                        currentLength = wrapPrefix.length();
                    } else if (hasWord) {
                        currentLine.append(" ");
                    }
                    currentLine.append(word);
                    currentLength += length;
                    hasWord = true;
                }
            }
            if (currentLength <= 0) continue;
            list.add(colorPrefix + currentLine);
        }
    }

    @Override
    public boolean hasItem(Inventory inventory, String itemName) {
        ItemStack itemStack = this.getItem(inventory, itemName);
        return itemStack != null;
    }

    @Override
    public ItemStack getItem(Inventory inventory, String itemName) {
        ItemStack[] items;
        if (inventory == null) {
            return null;
        }
        for (ItemStack item : items = inventory.getContents()) {
            String displayName;
            if (item == null || !item.hasItemMeta() || (displayName = item.getItemMeta().getDisplayName()) == null || !displayName.equals(itemName)) continue;
            return item;
        }
        return null;
    }
}

