/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.help;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.utility.ChatUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.Messages;
import com.elmakers.mine.bukkit.utility.StringUtils;
import com.elmakers.mine.bukkit.utility.help.HelpTopic;
import com.elmakers.mine.bukkit.utility.help.HelpTopicMatch;
import com.elmakers.mine.bukkit.utility.help.HelpTopicWord;
import com.elmakers.mine.bukkit.utility.help.ShowTopicsTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public class Help {
    public static final int MIN_WORD_LENGTH = 2;
    private static double DEFAULT_WEIGHT = 1.0E-5;
    private static double META_WEIGHT_MAX = 0.95;
    private static double META_WEIGHT_MIN = 0.75;
    private static double STOP_WEIGHT = 0.0;
    private final Messages messages;
    private final Map<String, HelpTopic> topics = new HashMap<String, HelpTopic>();
    private final Map<String, HelpTopicWord> words = new HashMap<String, HelpTopicWord>();
    private final Set<String> stopWords = new HashSet<String>();
    private final Map<String, String> metaTemplates = new HashMap<String, String>();
    private static final Pattern linkPattern = Pattern.compile("([^`])(<li[^>]*>)([^`])");
    protected int maxCount = 0;
    protected int maxTopicCount = 0;
    protected int maxLength = 0;

    public Help(Messages messages) {
        this.messages = messages;
    }

    public void reset() {
        this.maxCount = 0;
        this.maxTopicCount = 0;
        this.maxLength = 0;
        this.topics.clear();
        this.words.clear();
        this.metaTemplates.clear();
    }

    public void resetStats() {
        for (HelpTopicWord word : this.words.values()) {
            word.reset();
        }
    }

    public void loadMessages(ConfigurationSection messages) {
        ConfigurationSection helpSection = messages.getConfigurationSection("help");
        ConfigurationSection examplesSection = messages.getConfigurationSection("examples");
        ConfigurationSection metaSection = messages.getConfigurationSection("meta");
        ConfigurationSection exampleSection = messages.getConfigurationSection("example");
        this.loadMetaTemplates(metaSection);
        if (examplesSection != null && exampleSection != null) {
            this.processExamples(examplesSection, exampleSection);
        }
        if (helpSection != null) {
            ConfigurationSection helpExamples = helpSection.getConfigurationSection("examples");
            if (helpExamples != null) {
                ConfigurationUtils.addConfigurations(helpExamples, examplesSection);
            } else {
                helpSection.set("examples", (Object)examplesSection);
            }
            this.load(helpSection);
        }
        List stopWords = messages.getStringList("stop");
        messages.set("stop", null);
        this.stopWords.addAll(stopWords);
    }

    private void processExamples(ConfigurationSection examplesSection, ConfigurationSection exampleSection) {
        Set examples = examplesSection.getKeys(false);
        for (String exampleKey : examples) {
            String instructionsKey = exampleKey + ".instructions";
            Object instructions = examplesSection.getString(instructionsKey);
            if (instructions == null) continue;
            String template = exampleSection.getString("instructions_additional");
            instructions = (String)instructions + "\n" + template.replace("$example", exampleKey);
            examplesSection.set(instructionsKey, instructions);
        }
    }

    private void load(ConfigurationSection helpSection) {
        Set keys = helpSection.getKeys(true);
        for (String key : keys) {
            if (helpSection.isConfigurationSection(key)) continue;
            String value = helpSection.getString(key);
            this.loadTopic(key, value);
        }
    }

    public void loadTopic(String key, String contents) {
        this.loadTopic(key, contents, "", "", "", 1.0);
    }

    public void loadTopic(String key, String contents, String extraContents, String tags, String topicType, double weight) {
        HelpTopic helpTopic = new HelpTopic(this.messages, key, contents, extraContents, tags, topicType, weight);
        this.topics.put(key, helpTopic);
        Map<String, Integer> wordCounts = helpTopic.getWordCounts();
        for (Map.Entry<String, Integer> wordEntry : wordCounts.entrySet()) {
            String word = wordEntry.getKey();
            HelpTopicWord wordCount = this.words.get(word);
            if (wordCount == null) {
                wordCount = new HelpTopicWord(word);
                this.words.put(word, wordCount);
            }
            wordCount.addTopic(wordEntry.getValue());
            this.maxCount = Math.max(this.maxCount, wordCount.getCount());
            this.maxTopicCount = Math.max(this.maxTopicCount, wordCount.getTopicCount());
            this.maxLength = Math.max(this.maxLength, word.length());
        }
    }

    private void loadMetaTemplates(ConfigurationSection metaSection) {
        if (metaSection == null) {
            return;
        }
        for (String key : metaSection.getKeys(true)) {
            this.metaTemplates.put(key, metaSection.getString(key));
        }
    }

    public void loadMetaActions(Map<String, Map<String, Object>> actions) {
        this.loadMetaClassed(actions, "action", "action spell", "reference");
    }

    public void loadMetaEffects(Map<String, Map<String, Object>> effects) {
        this.loadMetaClassed(effects, "effect", "effectlib spell", "reference");
    }

    private String convertMetaDescription(String description) {
        return linkPattern.matcher(description).replaceAll("$1`$2`$3");
    }

    private void loadMetaClassed(Map<String, Map<String, Object>> meta, String metaType, String tags, String topicType) {
        String typeTemplate = this.metaTemplates.get(metaType + "_template");
        String defaultDescription = this.metaTemplates.get("default_description");
        String defaultParameterDescription = this.metaTemplates.get("default_parameter_description");
        String parameterTemplate = this.metaTemplates.get("parameter_template");
        String parameterExtraLineTemplate = this.metaTemplates.get("parameter_extra_line");
        String parametersTemplate = this.metaTemplates.get("parameters_template");
        String examplesTemplate = this.metaTemplates.get("examples_template");
        String exampleTemplate = this.metaTemplates.get("example_template");
        String descriptionTemplate = this.metaTemplates.get("description_template");
        for (Map.Entry<String, Map<String, Object>> entry : meta.entrySet()) {
            Map parameters;
            Object rawParameters;
            List exampleList;
            String description;
            Map<String, Object> action = entry.getValue();
            String key = entry.getKey();
            String shortClass = (String)action.get("short_class");
            if (shortClass == null) continue;
            List descriptionList = (List)action.get("description");
            if (descriptionList.size() == 1 && ((String)descriptionList.get(0)).trim().isEmpty()) {
                descriptionList.clear();
            }
            if (descriptionList.isEmpty()) {
                description = descriptionTemplate.replace("$description", defaultDescription);
            } else {
                for (int i = 0; i < descriptionList.size(); ++i) {
                    descriptionList.set(i, descriptionTemplate.replace("$description", (CharSequence)descriptionList.get(i)));
                }
                description = StringUtils.join((Collection)descriptionList, "\n");
            }
            description = typeTemplate.replace("$class", shortClass).replace("$description", description).replace("$key", key);
            String metaCategory = (String)action.get("category");
            if (metaCategory != null && !metaCategory.isEmpty()) {
                tags = (String)tags + " " + metaCategory;
            }
            Object extraDescription = "";
            Object rawExamples = action.get("examples");
            if (rawExamples != null && rawExamples instanceof List && !(exampleList = (List)rawExamples).isEmpty()) {
                for (int i = 0; i < exampleList.size(); ++i) {
                    exampleList.set(i, exampleTemplate.replace("$example", (CharSequence)exampleList.get(i)));
                }
                extraDescription = (String)extraDescription + "\n" + examplesTemplate.replace("$examples", StringUtils.join((Collection)exampleList, " "));
            }
            int importance = 0;
            Object rawImportance = action.get("importance");
            if (rawImportance != null && rawImportance instanceof Integer) {
                importance = (Integer)rawImportance;
            }
            if ((rawParameters = action.get("parameters")) != null && rawParameters instanceof Map && !(parameters = (Map)rawParameters).isEmpty()) {
                ArrayList<String> parameterLines = new ArrayList<String>();
                for (Map.Entry parameterEntry : parameters.entrySet()) {
                    String parameterDescription = parameterEntry.getValue().toString();
                    if (parameterDescription.isEmpty()) {
                        parameterDescription = defaultParameterDescription;
                    }
                    String[] descriptionLines = parameterDescription.split("\\\\n");
                    parameterLines.add(parameterTemplate.replace("$parameter", (CharSequence)parameterEntry.getKey()).replace("$description", descriptionLines[0]));
                    for (int i = 1; i < descriptionLines.length; ++i) {
                        parameterLines.add(parameterExtraLineTemplate.replace("$parameter", (CharSequence)parameterEntry.getKey()).replace("$description", descriptionLines[i]));
                    }
                }
                extraDescription = (String)extraDescription + "\n" + parametersTemplate.replace("$parameters", StringUtils.join(parameterLines, "\n"));
            }
            description = this.convertMetaDescription(description);
            extraDescription = this.convertMetaDescription((String)extraDescription);
            double weight = (double)(Math.min(importance, 100) / 100) * (META_WEIGHT_MAX - META_WEIGHT_MIN) + META_WEIGHT_MIN;
            this.loadTopic("reference." + metaType + "s." + key, description, (String)extraDescription, (String)tags, topicType, weight);
        }
    }

    public Set<String> getWords() {
        return this.words.keySet();
    }

    public double getWeight(String word) {
        if (this.maxCount == 0 || this.maxLength == 0 || this.maxTopicCount == 0) {
            return DEFAULT_WEIGHT;
        }
        HelpTopicWord wordCount = this.words.get(word);
        if (wordCount == null) {
            return DEFAULT_WEIGHT;
        }
        double weight = wordCount.getWeight(this);
        if (this.stopWords.contains(word)) {
            weight *= STOP_WEIGHT;
        }
        return weight;
    }

    public String getDebugText(String word) {
        HelpTopicWord wordCount = this.words.get(word);
        if (wordCount == null) {
            return "";
        }
        return wordCount.getDebugText(this);
    }

    public boolean showTopic(Mage mage, String key) {
        HelpTopic topic = this.topics.get(key);
        if (topic == null) {
            return false;
        }
        mage.sendMessage(topic.getText());
        return true;
    }

    public HelpTopic getTopic(String key) {
        return this.topics.get(key);
    }

    @Nonnull
    public List<HelpTopicMatch> findMatches(List<String> keywords, int listLength) {
        ArrayList<HelpTopicMatch> matches = new ArrayList<HelpTopicMatch>();
        for (HelpTopic helpTopic : this.topics.values()) {
            HelpTopicMatch match = helpTopic.match(this, keywords);
            if (!match.isRelevant()) continue;
            matches.add(match);
        }
        HashMap<String, PriorityQueue<HelpTopicMatch>> grouped = new HashMap<String, PriorityQueue<HelpTopicMatch>>();
        for (HelpTopicMatch match : matches) {
            String topicType = match.getTopic().getTopicType();
            PriorityQueue<HelpTopicMatch> groupedList = (PriorityQueue<HelpTopicMatch>)grouped.get(topicType);
            if (groupedList == null) {
                groupedList = new PriorityQueue<HelpTopicMatch>();
                grouped.put(topicType, groupedList);
            }
            groupedList.add(match);
        }
        matches.clear();
        ArrayList<HelpTopicMatch> arrayList = new ArrayList<HelpTopicMatch>();
        HashSet<String> addedThisPage = new HashSet<String>();
        int thisPageCount = 0;
        while (!grouped.isEmpty()) {
            Iterator it = grouped.entrySet().iterator();
            if (grouped.size() == 1) {
                arrayList.addAll((Collection)it.next().getValue());
                break;
            }
            String bestMatchType = null;
            HelpTopicMatch bestMatch = null;
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Queue typeMatches = (Queue)entry.getValue();
                if (typeMatches.isEmpty()) {
                    it.remove();
                    continue;
                }
                HelpTopicMatch match = (HelpTopicMatch)typeMatches.peek();
                if (bestMatch != null && !(match.getRelevance() > bestMatch.getRelevance())) continue;
                bestMatch = match;
                bestMatchType = (String)entry.getKey();
            }
            if (bestMatch == null) break;
            ((Queue)grouped.get(bestMatchType)).remove();
            addedThisPage.add(bestMatchType);
            arrayList.add(bestMatch);
            int haveNotAdded = grouped.size() - addedThisPage.size();
            if (++thisPageCount < listLength - haveNotAdded) continue;
            if (haveNotAdded > 0) {
                for (Map.Entry entry : grouped.entrySet()) {
                    if (addedThisPage.contains(entry.getKey())) continue;
                    arrayList.add((HelpTopicMatch)((Queue)entry.getValue()).remove());
                }
            }
            Collections.sort(arrayList);
            matches.addAll(arrayList);
            arrayList.clear();
            addedThisPage.clear();
            thisPageCount = 0;
        }
        Collections.sort(arrayList);
        matches.addAll(arrayList);
        return matches;
    }

    public void search(Mage mage, String[] args, int maxTopics) {
        List<String> keywords = Arrays.asList(ChatUtils.getWords(StringUtils.join((Object[])args, " ").toLowerCase()));
        List<HelpTopicMatch> matches = this.findMatches(keywords, maxTopics);
        ShowTopicsTask showTask = new ShowTopicsTask(this, mage, keywords, matches, maxTopics);
        Plugin plugin = mage.getController().getPlugin();
        plugin.getServer().getScheduler().runTask(plugin, (Runnable)showTask);
    }

    public boolean isValidWord(String keyword) {
        if (keyword.length() < 2) {
            return false;
        }
        return !this.stopWords.contains(keyword);
    }
}

