/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.spell.BlockSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.StringUtils;
import com.elmakers.mine.bukkit.utility.Target;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Art;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.inventory.ItemStack;
import org.bukkit.map.MapView;

@Deprecated
public class AlterSpell
extends BlockSpell {
    static final String DEFAULT_ADJUSTABLES = "3 ,5, 6, 8, 9, 10,11,12,17,162,18,161,23,24,27,28,29,31,33,35,37,38,43,44,52,53,54,55,58,59,60,61,62,63,65,66,67,68,69,77,78,81,83,85,86,93,94,95,97,98,99,100,104,105,108,109,114,115,125,126,128,134,135,136,140,141,142,144,155,156,159,160,171,172,175";
    static final String DEFAULT_ADJUST_MAX = "2 ,5, 5 ,15,15,15,15,1 ,15,1 ,3 ,1  ,5 ,2 ,9 ,9 ,5 ,2 ,5 ,15,8 ,8 ,15,15,15,3 ,5 ,15,5 ,7 ,8 ,5 ,5 ,15,3 ,9 ,3 ,2 ,14,15,7 ,15,15,5 ,0 ,5 ,5 ,15, 5,3 ,15,15 ,7  ,7  ,3  ,3  ,3  ,7  ,15 ,15 ,3  ,3  ,3  ,3  ,15 ,7  ,7  ,4  ,4  ,3  ,15 ,15 ,15 ,15 ,6";
    static final String DEFAULT_ADJUST_MIN = "0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0  ,0 ,0  ,2 ,0 ,0, 0, 0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,2 ,0 ,2 ,0 ,0 ,2 ,2 ,0 ,0 ,0 ,0 ,5 ,6 ,0 ,0 ,0 ,0 ,0 ,3 ,2 ,2 ,0 , 0,0 ,0 ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0";
    static final int DEFAULT_RECURSE_DISTANCE = 0;

    public static List<Integer> parseIntegers(String csvList) {
        String[] intStrings;
        ArrayList<Integer> ints = new ArrayList<Integer>();
        for (String s : intStrings = StringUtils.split(csvList, ',')) {
            try {
                int thisInt = Integer.parseInt(s.trim());
                ints.add(thisInt);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ints;
    }

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        SpellResult result;
        Target target = this.getTarget();
        if (target.hasEntity() && (result = this.alterEntity(target.getEntity())) != SpellResult.NO_TARGET) {
            return result;
        }
        Block targetBlock = target.getBlock();
        if (targetBlock == null) {
            return SpellResult.NO_TARGET;
        }
        int recurseDistance = parameters.getInt("depth", 0);
        recurseDistance = (int)(this.mage.getRadiusMultiplier() * (float)recurseDistance);
        List<Integer> adjustableMaterials = AlterSpell.parseIntegers(DEFAULT_ADJUSTABLES);
        List<Integer> maxData = AlterSpell.parseIntegers(DEFAULT_ADJUST_MAX);
        List<Integer> minData = AlterSpell.parseIntegers(DEFAULT_ADJUST_MIN);
        if (adjustableMaterials.size() != maxData.size() || maxData.size() != minData.size()) {
            this.controller.getLogger().warning("Spells:Alter: Mis-match in adjustable material lists!");
        }
        if (!adjustableMaterials.contains(targetBlock.getType().getId())) {
            return SpellResult.FAIL;
        }
        if (!this.hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (this.mage.isIndestructible(targetBlock)) {
            return SpellResult.NO_TARGET;
        }
        if (!this.isDestructible(targetBlock)) {
            return SpellResult.NO_TARGET;
        }
        byte originalData = targetBlock.getData();
        int materialIndex = adjustableMaterials.indexOf(targetBlock.getType().getId());
        int minValue = minData.get(materialIndex);
        int maxValue = maxData.get(materialIndex);
        int dataSize = maxValue - minValue + 1;
        byte data = (byte)((originalData - minValue + 1) % dataSize + minValue);
        boolean recursive = recurseDistance > 0;
        this.adjust(targetBlock, data, recursive, recurseDistance, 0);
        this.registerForUndo();
        return SpellResult.CAST;
    }

    protected void adjust(Block block, byte dataValue, boolean recursive, int recurseDistance, int rDepth) {
        this.registerForUndo(block);
        try {
            CompatibilityLib.getDeprecatedUtils().setTypeAndData(block, block.getType(), dataValue, false);
        }
        catch (Exception ex) {
            this.controller.getLogger().log(Level.WARNING, "Failed to alter block state: " + ex.getMessage());
        }
        if (recursive && rDepth < recurseDistance) {
            Material targetMaterial = block.getType();
            this.tryAdjust(block.getRelative(BlockFace.NORTH), dataValue, targetMaterial, recurseDistance, rDepth + 1);
            this.tryAdjust(block.getRelative(BlockFace.WEST), dataValue, targetMaterial, recurseDistance, rDepth + 1);
            this.tryAdjust(block.getRelative(BlockFace.SOUTH), dataValue, targetMaterial, recurseDistance, rDepth + 1);
            this.tryAdjust(block.getRelative(BlockFace.EAST), dataValue, targetMaterial, recurseDistance, rDepth + 1);
            this.tryAdjust(block.getRelative(BlockFace.UP), dataValue, targetMaterial, recurseDistance, rDepth + 1);
            this.tryAdjust(block.getRelative(BlockFace.DOWN), dataValue, targetMaterial, recurseDistance, rDepth + 1);
        }
    }

    protected SpellResult alterEntity(Entity entity) {
        EntityType entityType = entity.getType();
        switch (entityType) {
            case PAINTING: {
                Art oldArt;
                this.registerModified(entity);
                Painting painting = (Painting)entity;
                Art[] artValues = Art.values();
                Art newArt = oldArt = painting.getArt();
                int ordinal = oldArt.ordinal() + 1;
                for (int i = 0; i < artValues.length; ++i) {
                    newArt = artValues[ordinal++ % artValues.length];
                    painting.setArt(newArt);
                    newArt = painting.getArt();
                    if (oldArt != newArt) break;
                }
                if (oldArt == newArt) {
                    return SpellResult.FAIL;
                }
                this.mage.sendDebugMessage("Altering art from " + String.valueOf(oldArt) + " to " + String.valueOf(newArt));
                break;
            }
            case ITEM_FRAME: {
                ItemFrame itemFrame = (ItemFrame)entity;
                ItemStack frameItem = itemFrame.getItem();
                if (frameItem == null || !DefaultMaterials.isFilledMap(frameItem.getType())) {
                    return SpellResult.NO_TARGET;
                }
                int mapId = CompatibilityLib.getInventoryUtils().getMapId(frameItem);
                MapView mapView = CompatibilityLib.getDeprecatedUtils().getMap(++mapId);
                if (mapView == null) {
                    mapId = 0;
                    mapView = CompatibilityLib.getDeprecatedUtils().getMap(mapId);
                    if (mapView == null) {
                        return SpellResult.NO_TARGET;
                    }
                }
                this.registerModified(entity);
                CompatibilityLib.getInventoryUtils().setMapId(frameItem, mapId);
                itemFrame.setItem(frameItem);
                break;
            }
            case HORSE: {
                this.registerModified(entity);
                Horse horse = (Horse)entity;
                Horse.Color color = horse.getColor();
                Horse.Color[] colorValues = Horse.Color.values();
                color = colorValues[(color.ordinal() + 1) % colorValues.length];
                Horse.Style horseStyle = horse.getStyle();
                Horse.Style[] styleValues = Horse.Style.values();
                horseStyle = styleValues[(horseStyle.ordinal() + 1) % styleValues.length];
                horse.setStyle(horseStyle);
                horse.setColor(color);
                break;
            }
            case VILLAGER: {
                this.registerModified(entity);
                Villager villager = (Villager)entity;
                Villager.Profession profession = villager.getProfession();
                Villager.Profession[] professionValues = Villager.Profession.values();
                profession = professionValues[(profession.ordinal() + 1) % professionValues.length];
                villager.setProfession(profession);
                break;
            }
            case WOLF: {
                this.registerModified(entity);
                Wolf wolf = (Wolf)entity;
                DyeColor wolfColor = wolf.getCollarColor();
                DyeColor[] wolfColorValues = DyeColor.values();
                wolfColor = wolfColorValues[(wolfColor.ordinal() + 1) % wolfColorValues.length];
                wolf.setCollarColor(wolfColor);
                break;
            }
            case SHEEP: {
                this.registerModified(entity);
                Sheep sheep = (Sheep)entity;
                DyeColor dyeColor = sheep.getColor();
                DyeColor[] dyeColorValues = DyeColor.values();
                dyeColor = dyeColorValues[(dyeColor.ordinal() + 1) % dyeColorValues.length];
                sheep.setColor(dyeColor);
                break;
            }
            default: {
                return SpellResult.NO_TARGET;
            }
        }
        this.registerForUndo();
        return SpellResult.CAST;
    }

    protected void tryAdjust(Block target, byte dataValue, Material targetMaterial, int recurseDistance, int rDepth) {
        if (target.getType() != targetMaterial || this.contains(target)) {
            return;
        }
        this.adjust(target, dataValue, true, recurseDistance, rDepth);
    }
}

